/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.prores;

import java.nio.ByteBuffer;
import org.jcodec.codecs.prores.Codebook;
import org.jcodec.codecs.prores.ProresConsts;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.dct.DCTRef;
import org.jcodec.common.io.BitWriter;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Rect;
import org.jcodec.common.tools.ImageOP;
import org.jcodec.common.tools.MathUtil;

public class ProresEncoder {
    private static final int LOG_DEFAULT_SLICE_MB_WIDTH = 3;
    private static final int DEFAULT_SLICE_MB_WIDTH = 8;
    protected Profile profile;
    private int[][] scaledLuma;
    private int[][] scaledChroma;

    public ProresEncoder(Profile profile) {
        this.profile = profile;
        this.scaledLuma = this.scaleQMat(profile.qmatLuma, 1, 16);
        this.scaledChroma = this.scaleQMat(profile.qmatChroma, 1, 16);
    }

    private int[][] scaleQMat(int[] qmatLuma, int start, int count) {
        int[][] result = new int[count][];
        for (int i = 0; i < count; ++i) {
            result[i] = new int[qmatLuma.length];
            for (int j = 0; j < qmatLuma.length; ++j) {
                result[i][j] = qmatLuma[j] * (i + start);
            }
        }
        return result;
    }

    public static final void writeCodeword(BitWriter writer, Codebook codebook, int val) {
        int firstExp = codebook.switchBits + 1 << codebook.riceOrder;
        if (val >= firstExp) {
            val -= firstExp;
            int exp = MathUtil.log2(val += 1 << codebook.expOrder);
            int zeros = exp - codebook.expOrder + codebook.switchBits + 1;
            for (int i = 0; i < zeros; ++i) {
                writer.write1Bit(0);
            }
            writer.write1Bit(1);
            writer.writeNBit(val, exp);
        } else if (codebook.riceOrder > 0) {
            for (int i = 0; i < val >> codebook.riceOrder; ++i) {
                writer.write1Bit(0);
            }
            writer.write1Bit(1);
            writer.writeNBit(val & (1 << codebook.riceOrder) - 1, codebook.riceOrder);
        } else {
            for (int i = 0; i < val; ++i) {
                writer.write1Bit(0);
            }
            writer.write1Bit(1);
        }
    }

    private static final int qScale(int[] qMat, int ind, int val) {
        return val / qMat[ind];
    }

    private static final int toGolumb(int val) {
        return val << 1 ^ val >> 31;
    }

    private static final int toGolumb(int val, int sign) {
        if (val == 0) {
            return 0;
        }
        return (val << 1) + sign;
    }

    private static final int diffSign(int val, int sign) {
        return val >> 31 ^ sign;
    }

    public static final int getLevel(int val) {
        int sign = val >> 31;
        return (val ^ sign) - sign;
    }

    static final void writeDCCoeffs(BitWriter bits, int[] qMat, int[] in, int blocksPerSlice) {
        int prevDc = ProresEncoder.qScale(qMat, 0, in[0] - 16384);
        ProresEncoder.writeCodeword(bits, ProresConsts.firstDCCodebook, ProresEncoder.toGolumb(prevDc));
        int code = 5;
        int sign = 0;
        int idx = 64;
        int i = 1;
        while (i < blocksPerSlice) {
            int newDc = ProresEncoder.qScale(qMat, 0, in[idx] - 16384);
            int delta = newDc - prevDc;
            int newCode = ProresEncoder.toGolumb(ProresEncoder.getLevel(delta), ProresEncoder.diffSign(delta, sign));
            ProresEncoder.writeCodeword(bits, ProresConsts.dcCodebooks[Math.min(code, 6)], newCode);
            code = newCode;
            sign = delta >> 31;
            prevDc = newDc;
            ++i;
            idx += 64;
        }
    }

    static final void writeACCoeffs(BitWriter bits, int[] qMat, int[] in, int blocksPerSlice, int[] scan, int maxCoeff) {
        int prevRun = 4;
        int prevLevel = 2;
        int run = 0;
        for (int i = 1; i < maxCoeff; ++i) {
            int indp = scan[i];
            for (int j = 0; j < blocksPerSlice; ++j) {
                int val = ProresEncoder.qScale(qMat, indp, in[(j << 6) + indp]);
                if (val == 0) {
                    ++run;
                    continue;
                }
                ProresEncoder.writeCodeword(bits, ProresConsts.runCodebooks[Math.min(prevRun, 15)], run);
                prevRun = run;
                run = 0;
                int level = ProresEncoder.getLevel(val);
                ProresEncoder.writeCodeword(bits, ProresConsts.levCodebooks[Math.min(prevLevel, 9)], level - 1);
                prevLevel = level;
                bits.write1Bit(MathUtil.sign(val));
            }
        }
    }

    static final void encodeOnePlane(BitWriter bits, int blocksPerSlice, int[] qMat, int[] scan, int[] in) {
        ProresEncoder.writeDCCoeffs(bits, qMat, in, blocksPerSlice);
        ProresEncoder.writeACCoeffs(bits, qMat, in, blocksPerSlice, scan, 64);
    }

    private void dctOnePlane(int blocksPerSlice, int[] in) {
        for (int i = 0; i < blocksPerSlice; ++i) {
            DCTRef.fdct(in, i << 6);
        }
    }

    protected int encodeSlice(ByteBuffer out, int[][] scaledLuma, int[][] scaledChroma, int[] scan, int sliceMbCount, int mbX, int mbY, Picture result, int prevQp, int mbWidth, int mbHeight, boolean unsafe) {
        Picture striped = this.splitSlice(result, mbX, mbY, sliceMbCount, unsafe);
        this.dctOnePlane(sliceMbCount << 2, striped.getPlaneData(0));
        this.dctOnePlane(sliceMbCount << 1, striped.getPlaneData(1));
        this.dctOnePlane(sliceMbCount << 1, striped.getPlaneData(2));
        int est = (sliceMbCount >> 2) * this.profile.bitrate;
        int low = est - (est >> 3);
        int high = est + (est >> 3);
        int qp = prevQp;
        out.put((byte)48);
        ByteBuffer fork = out.duplicate();
        NIOUtils.skip(out, 5);
        int rem = out.position();
        int[] sizes = new int[3];
        ProresEncoder.encodeSliceData(out, scaledLuma[qp - 1], scaledChroma[qp - 1], scan, sliceMbCount, striped, qp, sizes);
        if (ProresEncoder.bits(sizes) > high && qp < this.profile.lastQp) {
            do {
                out.position(rem);
                ProresEncoder.encodeSliceData(out, scaledLuma[++qp - 1], scaledChroma[qp - 1], scan, sliceMbCount, striped, qp, sizes);
            } while (ProresEncoder.bits(sizes) > high && qp < this.profile.lastQp);
        } else if (ProresEncoder.bits(sizes) < low && qp > this.profile.firstQp) {
            do {
                out.position(rem);
                ProresEncoder.encodeSliceData(out, scaledLuma[--qp - 1], scaledChroma[qp - 1], scan, sliceMbCount, striped, qp, sizes);
            } while (ProresEncoder.bits(sizes) < low && qp > this.profile.firstQp);
        }
        fork.put((byte)qp);
        fork.putShort((short)sizes[0]);
        fork.putShort((short)sizes[1]);
        return qp;
    }

    static final int bits(int[] sizes) {
        return sizes[0] + sizes[1] + sizes[2] << 3;
    }

    protected static final void encodeSliceData(ByteBuffer out, int[] qmatLuma, int[] qmatChroma, int[] scan, int sliceMbCount, Picture striped, int qp, int[] sizes) {
        sizes[0] = ProresEncoder.onePlane(out, sliceMbCount << 2, qmatLuma, scan, striped.getPlaneData(0));
        sizes[1] = ProresEncoder.onePlane(out, sliceMbCount << 1, qmatChroma, scan, striped.getPlaneData(1));
        sizes[2] = ProresEncoder.onePlane(out, sliceMbCount << 1, qmatChroma, scan, striped.getPlaneData(2));
    }

    static final int onePlane(ByteBuffer out, int blocksPerSlice, int[] qmatLuma, int[] scan, int[] data) {
        int rem = out.position();
        BitWriter bits = new BitWriter(out);
        ProresEncoder.encodeOnePlane(bits, blocksPerSlice, qmatLuma, scan, data);
        bits.flush();
        return out.position() - rem;
    }

    protected void encodePicture(ByteBuffer out, int[][] scaledLuma, int[][] scaledChroma, int[] scan, Picture picture) {
        int mbWidth = picture.getWidth() + 15 >> 4;
        int mbHeight = picture.getHeight() + 15 >> 4;
        int qp = this.profile.firstQp;
        int nSlices = this.calcNSlices(mbWidth, mbHeight);
        ProresEncoder.writePictureHeader(3, nSlices, out);
        ByteBuffer fork = out.duplicate();
        NIOUtils.skip(out, nSlices << 1);
        int i = 0;
        int[] total = new int[nSlices];
        for (int mbY = 0; mbY < mbHeight; ++mbY) {
            int sliceMbCount = 8;
            for (int mbX = 0; mbX < mbWidth; mbX += sliceMbCount) {
                while (mbWidth - mbX < sliceMbCount) {
                    sliceMbCount >>= 1;
                }
                int sliceStart = out.position();
                boolean unsafeBottom = picture.getHeight() % 16 != 0 && mbY == mbHeight - 1;
                boolean unsafeRight = picture.getWidth() % 16 != 0 && mbX + sliceMbCount == mbWidth;
                qp = this.encodeSlice(out, scaledLuma, scaledChroma, scan, sliceMbCount, mbX, mbY, picture, qp, mbWidth, mbHeight, unsafeBottom || unsafeRight);
                fork.putShort((short)(out.position() - sliceStart));
                total[i++] = (short)(out.position() - sliceStart);
            }
        }
    }

    public static void writePictureHeader(int logDefaultSliceMbWidth, int nSlices, ByteBuffer out) {
        int headerLen = 8;
        out.put((byte)(headerLen << 3));
        out.putInt(0);
        out.putShort((short)nSlices);
        out.put((byte)(logDefaultSliceMbWidth << 4));
    }

    private int calcNSlices(int mbWidth, int mbHeight) {
        int nSlices = mbWidth >> 3;
        for (int i = 0; i < 3; ++i) {
            nSlices += mbWidth >> i & 1;
        }
        return nSlices * mbHeight;
    }

    private Picture splitSlice(Picture result, int mbX, int mbY, int sliceMbCount, boolean unsafe) {
        Picture out = Picture.create(sliceMbCount << 4, 16, ColorSpace.YUV422_10);
        if (unsafe) {
            Picture filled = Picture.create(sliceMbCount << 4, 16, ColorSpace.YUV422_10);
            ImageOP.subImageWithFill(result, filled, new Rect(mbX << 4, mbY << 4, sliceMbCount << 4, 16));
            this.split(filled, out, 0, 0, sliceMbCount);
        } else {
            this.split(result, out, mbX, mbY, sliceMbCount);
        }
        return out;
    }

    private void split(Picture in, Picture out, int mbX, int mbY, int sliceMbCount) {
        this.split(in.getPlaneData(0), out.getPlaneData(0), in.getPlaneWidth(0), mbX, mbY, sliceMbCount, 0);
        this.split(in.getPlaneData(1), out.getPlaneData(1), in.getPlaneWidth(1), mbX, mbY, sliceMbCount, 1);
        this.split(in.getPlaneData(2), out.getPlaneData(2), in.getPlaneWidth(2), mbX, mbY, sliceMbCount, 1);
    }

    private int[] split(int[] in, int[] out, int stride, int mbX, int mbY, int sliceMbCount, int chroma) {
        int outOff = 0;
        int off = (mbY << 4) * stride + (mbX << 4 - chroma);
        for (int i = 0; i < sliceMbCount; ++i) {
            this.splitBlock(in, stride, off, out, outOff);
            this.splitBlock(in, stride, off + (stride << 3), out, outOff + (128 >> chroma));
            if (chroma == 0) {
                this.splitBlock(in, stride, off + 8, out, outOff + 64);
                this.splitBlock(in, stride, off + (stride << 3) + 8, out, outOff + 192);
            }
            outOff += 256 >> chroma;
            off += 16 >> chroma;
        }
        return out;
    }

    private void splitBlock(int[] y, int stride, int off, int[] out, int outOff) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                out[outOff++] = y[off++];
            }
            off += stride - 8;
        }
    }

    public void encodeFrame(ByteBuffer out, Picture ... pics) {
        ByteBuffer fork = out.duplicate();
        int[] scan = pics.length > 1 ? ProresConsts.interlaced_scan : ProresConsts.progressive_scan;
        ProresEncoder.writeFrameHeader(out, new ProresConsts.FrameHeader(0, pics[0].getCroppedWidth(), pics[0].getCroppedHeight() * pics.length, pics.length == 1 ? 0 : 1, true, scan, this.profile.qmatLuma, this.profile.qmatChroma, 2));
        this.encodePicture(out, this.scaledLuma, this.scaledChroma, scan, pics[0]);
        if (pics.length > 1) {
            this.encodePicture(out, this.scaledLuma, this.scaledChroma, scan, pics[1]);
        }
        out.flip();
        fork.putInt(out.remaining());
    }

    public static void writeFrameHeader(ByteBuffer outp, ProresConsts.FrameHeader header) {
        short headerSize = 148;
        outp.putInt(headerSize + 8 + header.payloadSize);
        outp.put(new byte[]{105, 99, 112, 102});
        outp.putShort(headerSize);
        outp.putShort((short)0);
        outp.put(new byte[]{97, 112, 108, 48});
        outp.putShort((short)header.width);
        outp.putShort((short)header.height);
        outp.put((byte)(header.frameType == 0 ? 131 : 135));
        outp.put(new byte[]{0, 2, 2, 6, 32, 0});
        outp.put((byte)3);
        ProresEncoder.writeQMat(outp, header.qMatLuma);
        ProresEncoder.writeQMat(outp, header.qMatChroma);
    }

    static final void writeQMat(ByteBuffer out, int[] qmat) {
        for (int i = 0; i < 64; ++i) {
            out.put((byte)qmat[i]);
        }
    }

    public static enum Profile {
        PROXY(ProresConsts.QMAT_LUMA_APCO, ProresConsts.QMAT_CHROMA_APCO, "apco", 1000, 4, 8),
        LT(ProresConsts.QMAT_LUMA_APCS, ProresConsts.QMAT_CHROMA_APCS, "apcs", 2100, 1, 9),
        STANDARD(ProresConsts.QMAT_LUMA_APCN, ProresConsts.QMAT_CHROMA_APCN, "apcn", 3500, 1, 6),
        HQ(ProresConsts.QMAT_LUMA_APCH, ProresConsts.QMAT_CHROMA_APCH, "apch", 5400, 1, 6);

        final int[] qmatLuma;
        final int[] qmatChroma;
        public final String fourcc;
        final int bitrate;
        final int firstQp;
        final int lastQp;

        private Profile(int[] qmatLuma, int[] qmatChroma, String fourcc, int bitrate, int firstQp, int lastQp) {
            this.qmatLuma = qmatLuma;
            this.qmatChroma = qmatChroma;
            this.fourcc = fourcc;
            this.bitrate = bitrate;
            this.firstQp = firstQp;
            this.lastQp = lastQp;
        }
    }
}

