/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.boxes;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mkv.MKVType;
import org.jcodec.containers.mkv.boxes.EbmlMaster;
import org.jcodec.containers.mkv.util.EbmlUtil;

public abstract class EbmlBase {
    protected EbmlMaster parent;
    public MKVType type;
    public byte[] id = new byte[]{0};
    public int dataLen = 0;
    public long offset;
    public long dataOffset;
    public int typeSizeLength;

    public boolean equalId(byte[] typeId) {
        return Arrays.equals(this.id, typeId);
    }

    public abstract ByteBuffer getData();

    public long size() {
        return this.dataLen + EbmlUtil.ebmlLength(this.dataLen) + this.id.length;
    }

    public long mux(SeekableByteChannel os) throws IOException {
        ByteBuffer bb = this.getData();
        return os.write(bb);
    }
}

