/*
 * Decompiled with CFR 0.152.
 */
package Sonnet;

import Sonnet.ColorSlider;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import org.jcodec.api.awt.SequenceEncoder;

public class Sonnet
extends Application {
    public void start(final Stage stage) throws IOException {
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException exc) {
                throw new Error("Unexpected interruption", exc);
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Sonnet.RainbowSystem(stage);
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                }
            });
        });
        thread.setDaemon(true);
        thread.start();
    }

    static void RainbowSystem(Stage primaryStage) throws IOException {
        ColorSlider black;
        primaryStage.setTitle("Sonnet");
        primaryStage.setWidth(1920.0);
        primaryStage.setHeight(1080.0);
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        System.out.println(bounds);
        double fRateDivisor = 444.0;
        FXMLLoader loader = new FXMLLoader(Sonnet.class.getResource("main.fxml"));
        StackPane[] stackPane = new StackPane[(int)(fRateDivisor + 1.0)];
        stackPane[0] = new StackPane();
        stackPane[0].setPrefSize(1920.0, 1080.0);
        Dimension dimension = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        dimension.width = (int)bounds.getWidth();
        dimension.height = (int)bounds.getHeight() + 40;
        Dimension Dim = dimension;
        WritableImage writableImage = new WritableImage(dimension.width, dimension.height);
        ImageView imageView = new ImageView();
        PixelWriter pw = writableImage.getPixelWriter();
        PixelReader pr = writableImage.getPixelReader();
        Image image = new Image("http://www.nanofirm.org/scimagorder.com/Pictures/Pixies%20Text.png");
        ImageView waterMark = new ImageView();
        WritableImage writableWaterMark = new WritableImage(dimension.width, dimension.height);
        waterMark.setImage((Image)writableWaterMark);
        PixelWriter pwWaterMark = writableWaterMark.getPixelWriter();
        PixelReader prWaterMark = writableWaterMark.getPixelReader();
        waterMark.setImage(image);
        JFileChooser jFileChooser = new JFileChooser();
        String path = "C:\\TestVideo.mp4";
        String text = "Sky.Netarianism";
        File selectedFile = new File(path);
        jFileChooser.setSelectedFile(selectedFile);
        int returnValue = jFileChooser.showSaveDialog(null);
        if (returnValue == 0) {
            selectedFile = jFileChooser.getSelectedFile();
            System.out.println(selectedFile.getName());
            System.out.println(selectedFile.getPath());
        }
        SequenceEncoder enc = new SequenceEncoder(selectedFile);
        primaryStage.setFullScreen(true);
        Scene[] scene = new Scene[(int)(fRateDivisor + 1.0)];
        scene[0] = new Scene((Parent)stackPane[0]);
        ColorSlider startColor = black = new ColorSlider(new double[]{0.0, 0.0, 0.0});
        int x = 0;
        while (x < dimension.width) {
            int y = 0;
            while (y < dimension.height) {
                pwWaterMark.setArgb(x, y, prWaterMark.getArgb(x, y));
                pw.setArgb(x, y, -16777216 + (int)startColor.RGB[0] * 65536 + (int)startColor.RGB[1] * 256 + (int)startColor.RGB[2]);
                ++y;
            }
            ++x;
        }
        imageView.setImage((Image)writableImage);
        waterMark.snapshot(null, writableWaterMark);
        stackPane[0].getChildren().add((Object)imageView);
        primaryStage.setScene(scene[0]);
        primaryStage.setFullScreen(true);
        primaryStage.show();
        double xSlider = 0.0;
        ColorSlider color = startColor;
        ColorSlider white = new ColorSlider(new double[]{255.0, 255.0, 255.0});
        ColorSlider skyblue = new ColorSlider(new double[]{134.0, 206.0, 249.0});
        ColorSlider pink = new ColorSlider(new double[]{255.0, 64.0, 143.0});
        ColorSlider blue = new ColorSlider(new double[]{0.0, 0.0, 192.0});
        ColorSlider red = new ColorSlider(new double[]{193.0, 0.0, 0.0});
        ColorSlider purple = new ColorSlider(new double[]{122.0, 0.0, 178.0});
        ColorSlider orange = new ColorSlider(new double[]{255.0, 134.0, 0.0});
        ColorSlider green = new ColorSlider(new double[]{0.0, 133.0, 50.0});
        ColorSlider yellow = new ColorSlider(new double[]{246.0, 252.0, 15.0});
        ColorSlider teal = new ColorSlider(new double[]{3.0, 224.0, 149.0});
        ColorSlider bronze = new ColorSlider(new double[]{152.0, 123.0, 46.0});
        ColorSlider silver = new ColorSlider(new double[]{193.0, 192.0, 192.0});
        ColorSlider gold = new ColorSlider(new double[]{205.0, 191.0, 44.0});
        ColorSlider lime = new ColorSlider(new double[]{126.0, 193.0, 33.0});
        ColorSlider brown = new ColorSlider(new double[]{131.0, 103.0, 71.0});
        int pixiePink = -65281;
        int numberOfColorsInTheRainbow = 7;
        Dimension HalfedDim = new Dimension(Dim.width / 2, Dim.height / 2);
        double radialDistance = Math.pow(Math.pow(HalfedDim.width + 1, 2.0) + Math.pow(HalfedDim.height + 1, 2.0), 0.5);
        double fullAngle = Math.PI * radialDistance;
        double angle = 0.0;
        double a = 0.0;
        double radius = 0.0;
        double colorDisplacement = 0.0;
        double interval = fullAngle / 2.0 / fRateDivisor;
        double colorInterval = fullAngle / (double)(numberOfColorsInTheRainbow - 1);
        while (xSlider < fullAngle / 10.0) {
            int x2 = 0;
            while (x2 < Dim.width) {
                int y = 0;
                while (y < Dim.height) {
                    angle = Math.atan2(x2 - HalfedDim.width + 1, y - Dim.height * 4 / 3 + 1);
                    a = angle * Math.tan(angle) * radialDistance / 4.46783504 + xSlider;
                    radius = a * 10.0;
                    while (radius < colorDisplacement) {
                        radius = radius + fullAngle - colorDisplacement;
                    }
                    while (radius > fullAngle) {
                        radius = radius - fullAngle - colorDisplacement;
                    }
                    if (radius >= colorDisplacement && radius < (double)(numberOfColorsInTheRainbow - 1) * colorInterval + colorDisplacement) {
                        if (prWaterMark.getArgb(x2, y) == pixiePink) {
                            if (radius < colorInterval + colorDisplacement) {
                                color.ColorSliderFunction(colorInterval, radius - colorDisplacement, purple, blue);
                            } else if (radius < 2.0 * colorInterval + colorDisplacement) {
                                color.ColorSliderFunction(colorInterval, radius - colorInterval - colorDisplacement, blue, teal);
                            } else if (radius < 3.0 * colorInterval + colorDisplacement) {
                                color.ColorSliderFunction(colorInterval, radius - 2.0 * colorInterval - colorDisplacement, teal, pink);
                            } else if (radius < 4.0 * colorInterval + colorDisplacement) {
                                color.ColorSliderFunction(colorInterval, radius - 3.0 * colorInterval - colorDisplacement, pink, yellow);
                            } else if (radius < 5.0 * colorInterval + colorDisplacement) {
                                color.ColorSliderFunction(colorInterval, radius - 4.0 * colorInterval - colorDisplacement, yellow, orange);
                            } else {
                                color.ColorSliderFunction(colorInterval, radius - 5.0 * colorInterval - colorDisplacement, orange, red);
                            }
                        } else if (radius < colorInterval + colorDisplacement) {
                            color.ColorSliderFunction(colorInterval, radius - colorDisplacement, red, orange);
                        } else if (radius < 2.0 * colorInterval + colorDisplacement) {
                            color.ColorSliderFunction(colorInterval, radius - colorInterval - colorDisplacement, orange, yellow);
                        } else if (radius < 3.0 * colorInterval + colorDisplacement) {
                            color.ColorSliderFunction(colorInterval, radius - 2.0 * colorInterval - colorDisplacement, yellow, green);
                        } else if (radius < 4.0 * colorInterval + colorDisplacement) {
                            color.ColorSliderFunction(colorInterval, radius - 3.0 * colorInterval - colorDisplacement, green, teal);
                        } else if (radius < 5.0 * colorInterval + colorDisplacement) {
                            color.ColorSliderFunction(colorInterval, radius - 4.0 * colorInterval - colorDisplacement, teal, blue);
                        } else {
                            color.ColorSliderFunction(colorInterval, radius - 5.0 * colorInterval - colorDisplacement, blue, purple);
                        }
                    }
                    pw.setArgb(x2, y, -16777216 + (int)color.RGB[0] * 65536 + (int)color.RGB[1] * 256 + (int)color.RGB[2]);
                    ++y;
                }
                ++x2;
            }
            System.out.println(Dim);
            stackPane[(int)(fRateDivisor * xSlider / fullAngle) + 1] = new StackPane();
            stackPane[(int)(fRateDivisor * xSlider / fullAngle) + 1].getChildren().add((Object)imageView);
            scene[(int)(fRateDivisor * xSlider / fullAngle) + 1] = new Scene((Parent)stackPane[(int)(fRateDivisor * xSlider / fullAngle) + 1]);
            primaryStage.setScene(scene[(int)(fRateDivisor * xSlider / fullAngle) + 1]);
            System.out.println(Dim);
            primaryStage.setFullScreen(true);
            primaryStage.show();
            if (xSlider == 0.0) {
                File outputFile = new File("C:/TestImage.png");
                BufferedImage bImage = SwingFXUtils.fromFXImage((Image)scene[(int)(fRateDivisor * xSlider / fullAngle) + 1].snapshot(null), null);
                try {
                    ImageIO.write((RenderedImage)bImage, "png", outputFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            enc.encodeImage(SwingFXUtils.fromFXImage((Image)scene[(int)(fRateDivisor * xSlider / fullAngle) + 1].snapshot(null), null));
            xSlider += interval;
            System.out.println(Dim);
        }
        enc.finish();
        System.out.println("Done Making Video");
    }

    public static void main(String[] args) throws IOException {
        Sonnet.launch((String[])args);
    }
}

