/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileDeleteStrategyTestCase {
    @TempDir
    public File temporaryFolder;

    @Test
    public void testDeleteNormal() throws Exception {
        File baseDir = this.temporaryFolder;
        File subDir = new File(baseDir, "test");
        Assertions.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        if (!subFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + subFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(subFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 16L);
        }
        Assertions.assertTrue((boolean)subDir.exists());
        Assertions.assertTrue((boolean)subFile.exists());
        try {
            FileDeleteStrategy.NORMAL.delete(subDir);
            Assertions.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)subDir.exists());
        Assertions.assertTrue((boolean)subFile.exists());
        FileDeleteStrategy.NORMAL.delete(subFile);
        Assertions.assertTrue((boolean)subDir.exists());
        Assertions.assertFalse((boolean)subFile.exists());
        FileDeleteStrategy.NORMAL.delete(subDir);
        Assertions.assertFalse((boolean)subDir.exists());
        FileDeleteStrategy.NORMAL.delete(subDir);
        Assertions.assertFalse((boolean)subDir.exists());
    }

    @Test
    public void testDeleteQuietlyNormal() throws Exception {
        File baseDir = this.temporaryFolder;
        File subDir = new File(baseDir, "test");
        Assertions.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        if (!subFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + subFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(subFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 16L);
        }
        Assertions.assertTrue((boolean)subDir.exists());
        Assertions.assertTrue((boolean)subFile.exists());
        Assertions.assertFalse((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        Assertions.assertTrue((boolean)subDir.exists());
        Assertions.assertTrue((boolean)subFile.exists());
        Assertions.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subFile));
        Assertions.assertTrue((boolean)subDir.exists());
        Assertions.assertFalse((boolean)subFile.exists());
        Assertions.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        Assertions.assertFalse((boolean)subDir.exists());
        Assertions.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        Assertions.assertFalse((boolean)subDir.exists());
    }

    @Test
    public void testDeleteForce() throws Exception {
        File baseDir = this.temporaryFolder;
        File subDir = new File(baseDir, "test");
        Assertions.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        if (!subFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + subFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(subFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 16L);
        }
        Assertions.assertTrue((boolean)subDir.exists());
        Assertions.assertTrue((boolean)subFile.exists());
        FileDeleteStrategy.FORCE.delete(subDir);
        Assertions.assertFalse((boolean)subDir.exists());
        Assertions.assertFalse((boolean)subFile.exists());
        FileDeleteStrategy.FORCE.delete(subDir);
        Assertions.assertFalse((boolean)subDir.exists());
    }

    @Test
    public void testDeleteNull() throws Exception {
        try {
            FileDeleteStrategy.NORMAL.delete(null);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(null));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"FileDeleteStrategy[Normal]", (Object)FileDeleteStrategy.NORMAL.toString());
        Assertions.assertEquals((Object)"FileDeleteStrategy[Force]", (Object)FileDeleteStrategy.FORCE.toString());
    }
}

