/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsFileNewerTestCase {
    @TempDir
    public File temporaryFolder;
    private static final int FILE1_SIZE = 1;
    private static final int FILE2_SIZE = 4097;
    private File testFile1;
    private File testFile2;

    @BeforeEach
    public void setUp() throws Exception {
        this.testFile1 = new File(this.temporaryFolder, "file1-test.txt");
        this.testFile2 = new File(this.temporaryFolder, "file2-test.txt");
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 1L);
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 4097L);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testIsFileNewer() throws IOException {
        if (!this.testFile1.exists()) {
            throw new IllegalStateException("The testFile1 should exist");
        }
        long fileLastModified = FileUtils.lastModified((File)this.testFile1);
        long TWO_SECOND = 2000L;
        this.testIsFileNewer("two second earlier is not newer", this.testFile1, fileLastModified + 2000L, false);
        this.testIsFileNewer("same time is not newer", this.testFile1, fileLastModified, false);
        this.testIsFileNewer("two second later is newer", this.testFile1, fileLastModified - 2000L, true);
    }

    @Test
    public void testIsFileNewerImaginaryFile() throws IOException {
        File imaginaryFile = new File(this.temporaryFolder, "imaginaryFile");
        if (imaginaryFile.exists()) {
            throw new IllegalStateException("The imaginary File exists");
        }
        this.testIsFileNewer("imaginary file can be newer", imaginaryFile, FileUtils.lastModified((File)this.testFile2), false);
    }

    protected void testIsFileNewer(String description, File file, long time, boolean wantedResult) throws IOException {
        Assertions.assertEquals((Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (long)time), (String)(description + " - time"));
        Assertions.assertEquals((Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (Date)new Date(time)), (String)(description + " - date"));
        File temporaryFile = this.testFile2;
        temporaryFile.setLastModified(time);
        Assertions.assertEquals((long)time, (long)FileUtils.lastModified((File)temporaryFile), (String)"The temporary file hasn't the right last modification date");
        Assertions.assertEquals((Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (File)temporaryFile), (String)(description + " - file"));
    }

    @Test
    public void testIsFileNewerNoFile() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer(null, (long)0L), (String)"file");
    }

    @Test
    public void testIsFileNewerNoDate() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer((File)this.testFile1, (Date)null), (String)"date");
    }

    @Test
    public void testIsFileNewerNoFileReference() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer((File)this.testFile1, (File)null), (String)"reference");
    }
}

