/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsListFilesTestCase {
    @TempDir
    public File temporaryFolder;

    @BeforeEach
    public void setUp() throws Exception {
        File dir = this.temporaryFolder;
        File file = new File(dir, "dummy-build.xml");
        FileUtils.touch((File)file);
        file = new File(dir, "README");
        FileUtils.touch((File)file);
        dir = new File(dir, "subdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-build.xml");
        FileUtils.touch((File)file);
        file = new File(dir, "dummy-readme.txt");
        FileUtils.touch((File)file);
        dir = new File(dir, "subsubdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-file.txt");
        FileUtils.touch((File)file);
        file = new File(dir, "dummy-index.html");
        FileUtils.touch((File)file);
        dir = dir.getParentFile();
        dir = new File(dir, "CVS");
        dir.mkdirs();
        file = new File(dir, "Entries");
        FileUtils.touch((File)file);
        file = new File(dir, "Repository");
        FileUtils.touch((File)file);
    }

    private Collection<String> filesToFilenames(Collection<File> files) {
        ArrayList<String> filenames = new ArrayList<String>(files.size());
        for (File file : files) {
            filenames.add(file.getName());
        }
        return filenames;
    }

    private Collection<String> filesToFilenames(Iterator<File> files) {
        ArrayList<String> filenames = new ArrayList<String>();
        while (files.hasNext()) {
            filenames.add(files.next().getName());
        }
        return filenames;
    }

    @Test
    public void testIterateFilesByExtension() {
        String[] extensions = new String[]{"xml", "txt"};
        Iterator files = FileUtils.iterateFiles((File)this.temporaryFolder, (String[])extensions, (boolean)false);
        Collection<String> filenames = this.filesToFilenames(files);
        Assertions.assertEquals((int)1, (int)filenames.size());
        Assertions.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        Assertions.assertFalse((boolean)filenames.contains("README"));
        Assertions.assertFalse((boolean)filenames.contains("dummy-file.txt"));
        files = FileUtils.iterateFiles((File)this.temporaryFolder, (String[])extensions, (boolean)true);
        filenames = this.filesToFilenames(files);
        Assertions.assertEquals((int)4, (int)filenames.size());
        Assertions.assertTrue((boolean)filenames.contains("dummy-file.txt"));
        Assertions.assertFalse((boolean)filenames.contains("dummy-index.html"));
        files = FileUtils.iterateFiles((File)this.temporaryFolder, null, (boolean)false);
        filenames = this.filesToFilenames(files);
        Assertions.assertEquals((int)2, (int)filenames.size());
        Assertions.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        Assertions.assertTrue((boolean)filenames.contains("README"));
        Assertions.assertFalse((boolean)filenames.contains("dummy-file.txt"));
    }

    @Test
    public void testListFilesByExtension() {
        String[] extensions = new String[]{"xml", "txt"};
        Collection files = FileUtils.listFiles((File)this.temporaryFolder, (String[])extensions, (boolean)false);
        Assertions.assertEquals((int)1, (int)files.size());
        Collection<String> filenames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        Assertions.assertFalse((boolean)filenames.contains("README"));
        Assertions.assertFalse((boolean)filenames.contains("dummy-file.txt"));
        files = FileUtils.listFiles((File)this.temporaryFolder, (String[])extensions, (boolean)true);
        filenames = this.filesToFilenames(files);
        Assertions.assertEquals((int)4, (int)filenames.size());
        Assertions.assertTrue((boolean)filenames.contains("dummy-file.txt"));
        Assertions.assertFalse((boolean)filenames.contains("dummy-index.html"));
        files = FileUtils.listFiles((File)this.temporaryFolder, null, (boolean)false);
        Assertions.assertEquals((int)2, (int)files.size());
        filenames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        Assertions.assertTrue((boolean)filenames.contains("README"));
        Assertions.assertFalse((boolean)filenames.contains("dummy-file.txt"));
    }

    @Test
    public void testListFiles() {
        IOFileFilter fileFilter = FileFilterUtils.trueFileFilter();
        Collection files = FileUtils.listFiles((File)this.temporaryFolder, (IOFileFilter)fileFilter, null);
        Collection<String> filenames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)filenames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertFalse((boolean)filenames.contains("dummy-index.html"), (String)"'dummy-index.html' shouldn't be found");
        Assertions.assertFalse((boolean)filenames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        IOFileFilter dirFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"CVS"));
        files = FileUtils.listFiles((File)this.temporaryFolder, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)filenames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)filenames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)filenames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.makeCVSAware(null);
        files = FileUtils.listFiles((File)this.temporaryFolder, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)filenames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)filenames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)filenames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.prefixFileFilter((String)"sub");
        dirFilter = FileFilterUtils.makeCVSAware((IOFileFilter)dirFilter);
        files = FileUtils.listFiles((File)this.temporaryFolder, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)filenames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)filenames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)filenames.contains("Entries"), (String)"'Entries' shouldn't be found");
        try {
            FileUtils.listFiles((File)this.temporaryFolder, null, null);
            Assertions.fail((String)"Expected error about null parameter");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

