/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PathVisitorFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class AccumulatorPathVisitorTest {
    @TempDir
    File tempDirFile;

    static Stream<Arguments> testParameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{AccumulatorPathVisitor::withLongCounters}), Arguments.of((Object[])new Object[]{AccumulatorPathVisitor::withBigIntegerCounters}));
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testEmptyFolder(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        Path tempDir = this.tempDirFile.toPath();
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new AndFileFilter(new IOFileFilter[]{countingFileFilter, DirectoryFileFilter.INSTANCE, EmptyFileFilter.EMPTY}));
        CounterAssertions.assertCounts(1L, 0L, 0L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getDirList().size());
        Assertions.assertTrue((boolean)accPathVisitor.getFileList().isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testFolders1FileSize0(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(1L, 1L, 0L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getDirList().size());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getFileList().size());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testFolders1FileSize1(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(1L, 1L, 1L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getDirList().size());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getFileList().size());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testFolders2FileSize2(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(3L, 2L, 2L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)3, (int)accPathVisitor.getDirList().size());
        Assertions.assertEquals((int)2, (int)accPathVisitor.getFileList().size());
    }
}

