/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathUtilsIsEmptyTest {
    public static final Path DIR_SIZE_1 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]);
    private static final Path FILE_SIZE_0 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0/file-size-0.bin", new String[0]);
    private static final Path FILE_SIZE_1 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]);

    @Test
    public void testIsEmpty() throws IOException {
        Assertions.assertTrue((boolean)PathUtils.isEmpty((Path)FILE_SIZE_0));
        Assertions.assertFalse((boolean)PathUtils.isEmpty((Path)FILE_SIZE_1));
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        try {
            Assertions.assertTrue((boolean)PathUtils.isEmpty((Path)tempDir));
        }
        finally {
            Files.delete(tempDir);
        }
        Assertions.assertFalse((boolean)PathUtils.isEmpty((Path)DIR_SIZE_1));
    }

    @Test
    public void testIsEmptyDirectory() throws IOException {
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        try {
            Assertions.assertTrue((boolean)PathUtils.isEmptyDirectory((Path)tempDir));
        }
        finally {
            Files.delete(tempDir);
        }
        Assertions.assertFalse((boolean)PathUtils.isEmptyDirectory((Path)DIR_SIZE_1));
    }

    @Test
    public void testisEmptyFile() throws IOException {
        Assertions.assertTrue((boolean)PathUtils.isEmptyFile((Path)FILE_SIZE_0));
        Assertions.assertFalse((boolean)PathUtils.isEmptyFile((Path)FILE_SIZE_1));
    }
}

