/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.MarkShieldInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MarkShieldInputStreamTest {
    @Test
    public void markIsNoOpWhenUnderlyingDoesNotSupport() throws IOException {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream(64L, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            msis.mark(1024);
            Assertions.assertEquals((int)0, (int)in.markcount);
            Assertions.assertEquals((int)0, (int)in.readlimit);
        }
    }

    @Test
    public void markIsNoOpWhenUnderlyingSupports() throws IOException {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream(64L, true, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            msis.mark(1024);
            Assertions.assertEquals((int)0, (int)in.markcount);
            Assertions.assertEquals((int)0, (int)in.readlimit);
        }
    }

    @Test
    public void markSupportedIsFalseWhenUnderlyingFalse() throws IOException {
        try (NullInputStream is = new NullInputStream(64L, false, false);){
            Assertions.assertFalse((boolean)is.markSupported());
            try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)is);){
                Assertions.assertFalse((boolean)msis.markSupported());
            }
        }
    }

    @Test
    public void markSupportedIsFalseWhenUnderlyingTrue() throws IOException {
        try (NullInputStream is = new NullInputStream(64L, true, false);){
            Assertions.assertTrue((boolean)is.markSupported());
            try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)is);){
                Assertions.assertFalse((boolean)msis.markSupported());
            }
        }
    }

    @Test
    public void resetThrowsExceptionWhenUnderylingDoesNotSupport() throws IOException {
        try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)new NullInputStream(64L, false, false));){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> msis.reset());
        }
    }

    @Test
    public void resetThrowsExceptionWhenUnderylingSupports() throws IOException {
        try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)new NullInputStream(64L, true, false));){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> msis.reset());
        }
    }

    private static class MarkTestableInputStream
    extends ProxyInputStream {
        int markcount;
        int readlimit;

        public MarkTestableInputStream(InputStream in) {
            super(in);
        }

        public void mark(int readlimit) {
            ++this.markcount;
            this.readlimit = readlimit;
            super.mark(readlimit);
        }
    }
}

