/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.MessageDigestCalculatingInputStreamTest;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ObservableInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObservableInputStreamTest {
    @Test
    public void testBrokenInputStreamRead() throws IOException {
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new BrokenInputStream());){
            Assertions.assertThrows(IOException.class, () -> ois.read());
        }
    }

    @Test
    public void testBrokenInputStreamReadBuffer() throws IOException {
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new BrokenInputStream());){
            Assertions.assertThrows(IOException.class, () -> ois.read(new byte[1]));
        }
    }

    @Test
    public void testBrokenInputStreamReadSubBuffer() throws IOException {
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new BrokenInputStream());){
            Assertions.assertThrows(IOException.class, () -> ois.read(new byte[2], 0, 1));
        }
    }

    @Test
    public void testDataByteCalled_add() throws Exception {
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(8192);
        DataViewObserver lko = new DataViewObserver();
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer));){
            Assertions.assertEquals((int)-1, (int)lko.lastValue);
            ois.read();
            Assertions.assertEquals((int)-1, (int)lko.lastValue);
            Assertions.assertEquals((long)0L, (long)lko.getFinishedCount());
            Assertions.assertEquals((long)0L, (long)lko.getClosedCount());
            ois.add((ObservableInputStream.Observer)lko);
            for (int i = 1; i < buffer.length; ++i) {
                int result = ois.read();
                Assertions.assertEquals((byte)((byte)result), (byte)buffer[i]);
                Assertions.assertEquals((int)result, (int)lko.lastValue);
                Assertions.assertEquals((long)0L, (long)lko.getFinishedCount());
                Assertions.assertEquals((long)0L, (long)lko.getClosedCount());
            }
            int result = ois.read();
            Assertions.assertEquals((int)-1, (int)result);
            Assertions.assertEquals((long)1L, (long)lko.getFinishedCount());
            Assertions.assertEquals((long)0L, (long)lko.getClosedCount());
            ois.close();
            Assertions.assertEquals((long)1L, (long)lko.getFinishedCount());
            Assertions.assertEquals((long)1L, (long)lko.getClosedCount());
        }
    }

    @Test
    public void testDataByteCalled_ctor() throws Exception {
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(8192);
        DataViewObserver lko = new DataViewObserver();
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer), new ObservableInputStream.Observer[]{lko});){
            Assertions.assertEquals((int)-1, (int)lko.lastValue);
            ois.read();
            Assertions.assertNotEquals((int)-1, (int)lko.lastValue);
            Assertions.assertEquals((long)0L, (long)lko.getFinishedCount());
            Assertions.assertEquals((long)0L, (long)lko.getClosedCount());
            for (int i = 1; i < buffer.length; ++i) {
                int result = ois.read();
                Assertions.assertEquals((byte)((byte)result), (byte)buffer[i]);
                Assertions.assertEquals((int)result, (int)lko.lastValue);
                Assertions.assertEquals((long)0L, (long)lko.getFinishedCount());
                Assertions.assertEquals((long)0L, (long)lko.getClosedCount());
            }
            int result = ois.read();
            Assertions.assertEquals((int)-1, (int)result);
            Assertions.assertEquals((long)1L, (long)lko.getFinishedCount());
            Assertions.assertEquals((long)0L, (long)lko.getClosedCount());
            ois.close();
            Assertions.assertEquals((long)1L, (long)lko.getFinishedCount());
            Assertions.assertEquals((long)1L, (long)lko.getClosedCount());
        }
    }

    @Test
    public void testDataBytesCalled() throws Exception {
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(8192);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
             ObservableInputStream ois = new ObservableInputStream((InputStream)bais);){
            DataViewObserver observer = new DataViewObserver();
            byte[] readBuffer = new byte[23];
            Assertions.assertNull((Object)observer.buffer);
            ois.read(readBuffer);
            Assertions.assertNull((Object)observer.buffer);
            ois.add((ObservableInputStream.Observer)observer);
            while (true) {
                if (bais.available() >= 2048) {
                    int result = ois.read(readBuffer);
                    if (result == -1) {
                        ois.close();
                        break;
                    }
                    Assertions.assertEquals((Object)readBuffer, (Object)observer.buffer);
                    Assertions.assertEquals((int)0, (int)observer.offset);
                    Assertions.assertEquals((int)readBuffer.length, (int)observer.length);
                    continue;
                }
                int res = Math.min(11, bais.available());
                int result = ois.read(readBuffer, 1, 11);
                if (result == -1) {
                    ois.close();
                    break;
                }
                Assertions.assertEquals((Object)readBuffer, (Object)observer.buffer);
                Assertions.assertEquals((int)1, (int)observer.offset);
                Assertions.assertEquals((int)res, (int)observer.length);
            }
        }
    }

    @Test
    public void testGetObservers0() throws IOException {
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new NullInputStream());){
            Assertions.assertTrue((boolean)ois.getObservers().isEmpty());
        }
    }

    @Test
    public void testGetObservers1() throws IOException {
        DataViewObserver observer0 = new DataViewObserver();
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new NullInputStream(), new ObservableInputStream.Observer[]{observer0});){
            Assertions.assertEquals((Object)((Object)observer0), ois.getObservers().get(0));
        }
    }

    @Test
    public void testGetObserversOrder() throws IOException {
        DataViewObserver observer0 = new DataViewObserver();
        DataViewObserver observer1 = new DataViewObserver();
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new NullInputStream(), new ObservableInputStream.Observer[]{observer0, observer1});){
            Assertions.assertEquals((Object)((Object)observer0), ois.getObservers().get(0));
            Assertions.assertEquals((Object)((Object)observer1), ois.getObservers().get(1));
        }
    }

    private void testNotificationCallbacks(int bufferSize) throws IOException {
        byte[] buffer = IOUtils.byteArray();
        LengthObserver lengthObserver = new LengthObserver();
        MethodCountObserver methodCountObserver = new MethodCountObserver();
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer), new ObservableInputStream.Observer[]{lengthObserver, methodCountObserver});){
            Assertions.assertEquals((long)8192L, (long)IOUtils.copy((InputStream)ois, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, (int)bufferSize));
        }
        Assertions.assertEquals((long)8192L, (long)lengthObserver.getTotal());
        Assertions.assertEquals((long)1L, (long)methodCountObserver.getClosedCount());
        Assertions.assertEquals((long)1L, (long)methodCountObserver.getFinishedCount());
        Assertions.assertEquals((long)0L, (long)methodCountObserver.getErrorCount());
        Assertions.assertEquals((long)0L, (long)methodCountObserver.getDataCount());
        Assertions.assertEquals((long)(buffer.length / bufferSize), (long)methodCountObserver.getDataBufferCount());
    }

    @Test
    public void testNotificationCallbacksBufferSize1() throws Exception {
        this.testNotificationCallbacks(1);
    }

    @Test
    public void testNotificationCallbacksBufferSize2() throws Exception {
        this.testNotificationCallbacks(2);
    }

    @Test
    public void testNotificationCallbacksBufferSizeDefault() throws Exception {
        this.testNotificationCallbacks(8192);
    }

    private static class MethodCountObserver
    extends ObservableInputStream.Observer {
        private long closedCount;
        private long dataBufferCount;
        private long dataCount;
        private long errorCount;
        private long finishedCount;

        private MethodCountObserver() {
        }

        public void closed() throws IOException {
            ++this.closedCount;
        }

        public void data(byte[] buffer, int offset, int length) throws IOException {
            ++this.dataBufferCount;
        }

        public void data(int value) throws IOException {
            ++this.dataCount;
        }

        public void error(IOException exception) throws IOException {
            ++this.errorCount;
        }

        public void finished() throws IOException {
            ++this.finishedCount;
        }

        public long getClosedCount() {
            return this.closedCount;
        }

        public long getDataBufferCount() {
            return this.dataBufferCount;
        }

        public long getDataCount() {
            return this.dataCount;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public long getFinishedCount() {
            return this.finishedCount;
        }
    }

    private static class LengthObserver
    extends ObservableInputStream.Observer {
        private long total;

        private LengthObserver() {
        }

        public void data(byte[] buffer, int offset, int length) throws IOException {
            this.total += (long)length;
        }

        public void data(int value) throws IOException {
            ++this.total;
        }

        public long getTotal() {
            return this.total;
        }
    }

    private static class DataViewObserver
    extends MethodCountObserver {
        private byte[] buffer;
        private int lastValue = -1;
        private int length = -1;
        private int offset = -1;

        private DataViewObserver() {
        }

        @Override
        public void data(byte[] buffer, int offset, int length) throws IOException {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public void data(int value) throws IOException {
            super.data(value);
            this.lastValue = value;
        }
    }
}

