/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Stack;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.TestResources;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ReversedLinesFileReaderTestParamFile {
    public static Stream<Arguments> testDataIntegrityWithBufferedReader() throws IOException, URISyntaxException {
        Path sourcePath = TestResources.getPath("test-file-utf8-win-linebr.bin");
        Path targetPath = Files.createTempFile("ReversedLinesFileReaderTestParamFile", ".bin", new FileAttribute[0]);
        try (BufferedReader input = Files.newBufferedReader(sourcePath, StandardCharsets.UTF_8);
             BufferedWriter output = Files.newBufferedWriter(targetPath, Charset.defaultCharset(), new OpenOption[0]);){
            IOUtils.copyLarge((Reader)input, (Writer)output);
        }
        return Stream.of(Arguments.of((Object[])new Object[]{targetPath.toAbsolutePath().toString(), null, null, false, false}), Arguments.of((Object[])new Object[]{"test-file-20byteslength.bin", "ISO_8859_1", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-iso8859-1-shortlines-win-linebr.bin", "ISO_8859_1", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-iso8859-1.bin", "ISO_8859_1", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-shiftjis.bin", "Shift_JIS", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf16be.bin", "UTF-16BE", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf16le.bin", "UTF-16LE", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf8-cr-only.bin", "UTF-8", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", null, false, true, Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", 1, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", 2, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", 3, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", 4, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf8.bin", "UTF-8", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-utf8.bin", "UTF-8", null, true, true}), Arguments.of((Object[])new Object[]{"test-file-windows-31j.bin", "windows-31j", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-gbk.bin", "gbk", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-x-windows-949.bin", "x-windows-949", null, false, true}), Arguments.of((Object[])new Object[]{"test-file-x-windows-950.bin", "x-windows-950", null, false, true})}));
    }

    @ParameterizedTest(name="{0}, encoding={1}, blockSize={2}, useNonDefaultFileSystem={3}, isResource={4}")
    @MethodSource
    public void testDataIntegrityWithBufferedReader(String fileName, String charsetName, Integer blockSize, boolean useNonDefaultFileSystem, boolean isResource) throws IOException, URISyntaxException {
        Path filePath = isResource ? TestResources.getPath(fileName) : Paths.get(fileName, new String[0]);
        FileSystem fileSystem = null;
        if (useNonDefaultFileSystem) {
            fileSystem = Jimfs.newFileSystem((Configuration)Configuration.unix());
            filePath = Files.copy(filePath, fileSystem.getPath("/" + fileName, new String[0]), new CopyOption[0]);
        }
        Charset charset = charsetName != null ? Charset.forName(charsetName) : null;
        try (ReversedLinesFileReader reversedLinesFileReader = blockSize == null ? new ReversedLinesFileReader(filePath, charset) : new ReversedLinesFileReader(filePath, blockSize.intValue(), charset);){
            String line;
            Stack<String> lineStack = new Stack<String>();
            try (BufferedReader bufferedReader = Files.newBufferedReader(filePath, Charsets.toCharset((Charset)charset));){
                while ((line = bufferedReader.readLine()) != null) {
                    lineStack.push(line);
                }
            }
            while ((line = reversedLinesFileReader.readLine()) != null) {
                String lineFromBufferedReader = (String)lineStack.pop();
                Assertions.assertEquals((Object)lineFromBufferedReader, (Object)line);
            }
            Assertions.assertEquals((int)0, (int)lineStack.size(), (String)"Stack should be empty");
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
    }
}

