/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.QueueInputStream;
import org.apache.commons.io.output.QueueOutputStream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueueOutputStreamTest {
    private static final ExecutorService executorService = Executors.newFixedThreadPool(5);

    @AfterAll
    public static void afterAll() {
        executorService.shutdown();
    }

    private static <T> T callInThrowAwayThread(Callable<T> callable) throws Exception {
        Exchanger<Object> exchanger = new Exchanger<Object>();
        executorService.submit(() -> {
            Object value = callable.call();
            exchanger.exchange(value);
            return null;
        });
        return exchanger.exchange(null);
    }

    @Test
    public void testNullArgument() {
        Assertions.assertThrows(NullPointerException.class, () -> new QueueOutputStream(null), (String)"queue is required");
    }

    @Test
    public void writeInterrupted() throws Exception {
        try (QueueOutputStream outputStream = new QueueOutputStream(new LinkedBlockingQueue(1));
             QueueInputStream inputStream = outputStream.newQueueInputStream();){
            boolean timeout = true;
            Exchanger writerThreadExchanger = new Exchanger();
            Exchanger<Object> exceptionExchanger = new Exchanger<Object>();
            executorService.submit(() -> {
                Thread writerThread = writerThreadExchanger.exchange(null, 1L, TimeUnit.SECONDS);
                writerThread.interrupt();
                return null;
            });
            executorService.submit(() -> {
                try {
                    writerThreadExchanger.exchange(Thread.currentThread(), 1L, TimeUnit.SECONDS);
                    outputStream.write("ABC".getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    Thread.interrupted();
                    exceptionExchanger.exchange(e, 1L, TimeUnit.SECONDS);
                }
                return null;
            });
            Exception exception = exceptionExchanger.exchange(null, 1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)exception);
            Assertions.assertEquals(exception.getClass(), InterruptedIOException.class);
        }
    }

    @Test
    public void writeString() throws Exception {
        try (QueueOutputStream outputStream = new QueueOutputStream();
             QueueInputStream inputStream = outputStream.newQueueInputStream();){
            outputStream.write("ABC".getBytes(StandardCharsets.UTF_8));
            String value = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)"ABC", (Object)value);
        }
    }

    @Test
    public void writeStringMultiThread() throws Exception {
        try (QueueOutputStream outputStream = QueueOutputStreamTest.callInThrowAwayThread(QueueOutputStream::new);
             QueueInputStream inputStream = QueueOutputStreamTest.callInThrowAwayThread(() -> ((QueueOutputStream)outputStream).newQueueInputStream());){
            QueueOutputStreamTest.callInThrowAwayThread(() -> {
                outputStream.write("ABC".getBytes(StandardCharsets.UTF_8));
                return null;
            });
            String value = QueueOutputStreamTest.callInThrowAwayThread(() -> IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"ABC", (Object)value);
        }
    }
}

