using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Storage;
//This Program is Made with XNA Game Studio 4.0

namespace SpaceCommand
{
    /// This is the main type for the game
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        ContentManager content;

        //The Main Body That Stores Strategic Data About All SpaceShips Reference SpaceShip.cs
        SpaceCommand.Resources.Ship[] ShipS;

        //shipNumber is always set to the number of ShipS which is selected.
        int shipNumber = 0;
        //shipNumberOfActive is always set to the number of ShipS which is Either Launching Rail, Launching STEX,
        //AutoRepairing, or is About to Detonate.
        int shipNumberOfActive = 0;
        //Helps Differentiate which ship has its future trajectory shown so that it is not shown when a new ship is selected.
        int shipNumberOfTrajectoryShown = 1;//1 so that Trajectorys are not intially shown.
        //Contains The Rail Damage from 1 ship to another Ship.
        int RailDamage = 0;
        //Contains the STEX capabilitys in launching STEX at another Ship.
        int STEXImpact = 0;
        //Contains the number of Ship System Integrity Points that can be used to repair the Ship
        int AutoRepairValue = 0;
        //DistanceForMove Determines how far a right click on the Star Field will factor into changing the ships acceleration.
        const float DistanceForMove = 100;
        //DistanceForRail is the maximum distance rail can hit 1 ship from another.
        const float DistanceForRail = 200;
        //DistanceForRail is the maximum distance STEX can invade 1 ship from another.
        const float DistanceForSTEX = 100;

        bool leftMouseClicked = false;
        bool rightMouseClicked = false;
        bool RailLaunchFromShip = false;
        bool STEXLaunchFromShip = false;
        bool AutoRepairActivated = false;
        bool DetonateStandUp = false;
        Vector2 mousePosition;
        MouseState mouseState;

        //Declaration of Texture of Background
        Texture2D starFieldTexture;
        //Declaration of the Array of Ship Textures
        Texture2D[] ShipTextures;
        //Declare Ship Statistics Background Textures
        Texture2D greenShipReadoutTexture;
        Texture2D greenSelectedReadoutTexture;
        Texture2D purpleSelectedReadoutTexture;
        Texture2D redShipReadoutTexture;
        Texture2D redSelectedReadoutTexture;
        Texture2D orangeSelectedReadoutTexture;
        //Dots show the future trajectory of the selected ship when you right click anywhere on the screen.
        Texture2D DotTexture;
        //Declare the X to Leave the Program in the Upper Righthand Corner And its Position
        Texture2D xOut;
        Vector2 xOutPosition;
        Vector2 xOutTextureWidthHeight;
        //Declares and Sets the Size of the Screen For the Entire Game
        Vector2 ScreenSize = new Vector2(1440, 900);
        // Sets the coordinates to draw the map.
        Vector2 starFieldPosition = Vector2.Zero;
        // Set the coordinates to initially draw the Ships.
        Vector2[] ShipPositions;// Will Be in SpaceShip.cs
        //Declaration of Ship Texture Widths and Heights
        Vector2[] ShipTextureWidthHeights;

        //Sets the coordinates to draw Ship Readout Squares and Selection Borders by 
        //Drawing purple and orange sqares with green and Red Squares on the inside.
        Vector2[] ShipReadoutPositions;
        Vector2[] ShipSelectedReadoutPositions;
        //For Finding Where in Ship Readouts is mousePosition.
        Vector2 ShipReadoutWidthHeight;

        //Sets the coordinates of all Ship Stats Text.
        Vector2[] ShipNamePositions;
        Vector2[] ShipHIPositions;
        Vector2[] ShipPSIPositions;
        Vector2[] ShipRSIPositions;
        Vector2[] ShipIDSIPositions;
        Vector2[] ShipSTEXPositions;
        Vector2[] ShipAutoRepairPositions;
        Vector2[] ShipDetonateTextPositions;
        Vector2[] ShipDetonateSureTextPositions;
        //Sets a vector that points from above upper left positions to lower right hand corner of the texts
        Vector2[] ShipHITextSizes;
        Vector2[] ShipPSITextSizes;
        Vector2[] ShipRSITextSizes;
        Vector2[] ShipIDSITextSizes;
        Vector2[] ShipSTEXTextSizes;
        Vector2[] ShipAutoRepairTextSizes;
        Vector2 ShipDetonateTextSize;
        Vector2 ShipDetonateSureTextSize;
        Vector2 DotTextureSize;
        //Sets the position of 33 Blue Dots which show the user future points of trajectories
        //so that they can decide where to steer their ships.
        Vector2[] FutureTrajectoryPoints;

        //Declares the vector that determines how far from the position of the text to the center of the text.
        Vector2 ShipTextOrigin = new Vector2(0,0);

        //Declares the texts for all ship Readouts.
        //The Type of Spaceship
        string[] ShipNameTexts;
        //Hull Integrity
        string[] ShipHITexts;
        //Power System Integrity
        string[] ShipPSITexts;
        //Rail Launch System Integrity (How much damage is caused when multiplied by the PSI).
        string[] ShipRSITexts;
        //Internal Defence System Integrity (1 STEX when launched eats away 1 IDSI point).
        string[] ShipIDSITexts;
        //Strength Enhancing eXosceleton Intruder to Take over Enemy Ships.
        string[] ShipSTEXTexts;
        //This can be used to automatically Repair the Ship.
        string[] ShipAutoRepairTexts;
        //This is the initial primer for the fusion detonator of a Ship's Self Destruct.
        string ShipDetonateText = "Detonate";
        //This is the final detonation sequence which will instantly blow up the given ship and anything near it.
        string ShipDetonateSureText = "Sure?";

        //When AlignmentOfTurn is 0 it is Green's turn, When it is 1 it is Red's
        int AlignmentOfTurn = 0;

        //Declaration of Font, Size, Style, and Spacing
        SpriteFont AstonF1;

        //Declares Sound and not SoundEffectInstance
        SoundEffect soundRailLaunch;
        SoundEffect soundAutoRepair;
        SoundEffect soundSTEXLaunch;
        SoundEffect soundDetonationStandUp;
        SoundEffect soundDetonation;
        SoundEffect soundCollision;
        //SoundEffectInstance soundEngineInstance;


        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            //Declares the length of all Arrays
            ShipS = new SpaceCommand.Resources.Ship[16];
            ShipPositions = new Vector2[16];
            ShipTextOrigin = new Vector2(0, 0);
            ShipTextures = new Texture2D[16];
            ShipTextureWidthHeights = new Vector2[16];
            ShipReadoutPositions = new Vector2[16];
            ShipSelectedReadoutPositions = new Vector2[16];
            ShipNamePositions = new Vector2[16];
            ShipNameTexts = new string[16];
            ShipHIPositions = new Vector2[16];
            ShipHITexts = new string[16];
            ShipHITextSizes = new Vector2[16];
            ShipPSIPositions = new Vector2[16];
            ShipPSITexts = new string[16];
            ShipPSITextSizes = new Vector2[16];
            ShipRSIPositions = new Vector2[16];
            ShipRSITexts = new string[16];
            ShipRSITextSizes = new Vector2[16];
            ShipIDSIPositions = new Vector2[16];
            ShipIDSITexts = new string[16];
            ShipIDSITextSizes = new Vector2[16];
            ShipSTEXPositions = new Vector2[16];
            ShipSTEXTexts = new string[16];
            ShipSTEXTextSizes = new Vector2[16];
            ShipAutoRepairPositions = new Vector2[16];
            ShipAutoRepairTexts = new string[16];
            ShipAutoRepairTextSizes = new Vector2[16];
            ShipDetonateTextPositions = new Vector2[16];
            ShipDetonateSureTextPositions = new Vector2[16];
            FutureTrajectoryPoints = new Vector2[33];
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);
            AstonF1 = Content.Load<SpriteFont>("Aston-F1");
            // Loads Background Image for 2D map.
            starFieldTexture = Content.Load<Texture2D>("StarsPicture");
            //Loads Ship Stats Backgrounds.
            greenShipReadoutTexture = Content.Load<Texture2D>("GreenShipReadout");
            greenSelectedReadoutTexture = Content.Load<Texture2D>("GreenSelectedReadout");
            purpleSelectedReadoutTexture = Content.Load<Texture2D>("PurpleSelectedReadout");
            redShipReadoutTexture = Content.Load<Texture2D>("RedShipReadout");
            redSelectedReadoutTexture = Content.Load<Texture2D>("RedSelectedReadout");
            orangeSelectedReadoutTexture = Content.Load<Texture2D>("OrangeSelectedReadout");
            ShipReadoutWidthHeight = new Vector2(greenShipReadoutTexture.Width, greenShipReadoutTexture.Height);
            //Dots show the future trajectory of the selected ship when you right click anywhere on the screen.
            DotTexture = Content.Load<Texture2D>("Dot");
            DotTextureSize = new Vector2(DotTexture.Width, DotTexture.Height);
            //Input the X to Leave the Program in the Upper Righthand Corner.
            xOut = Content.Load<Texture2D>("XOut");
            xOutPosition = new Vector2(1420, 0);
            xOutTextureWidthHeight = new Vector2(xOut.Width, xOut.Height);
            soundRailLaunch = Content.Load<SoundEffect>("RailLaunchSound");
            soundAutoRepair = Content.Load<SoundEffect>("AutoRepairSound");
            soundSTEXLaunch = Content.Load<SoundEffect>("STEXLaunchSound");
            soundDetonationStandUp = Content.Load<SoundEffect>("DetonationStandUpSound");
            soundDetonation = Content.Load<SoundEffect>("DetonationSound");
            soundCollision = Content.Load<SoundEffect>("CollisionSound");
            //soundEngineInstance = soundRailLaunch.CreateInstance();//Do not need
            //soundEngineInstance.IsLooped = false;
            //Inputs all Ships using the SpaceShip.cs Reference File and Gives them thier intial values.
            InputShipS();
            //Assigns all text to Ship Readouts.
            ReassignShipStats();
            //Assigns all Vector2 sizes of Ship Readout Texts.
            AssignTextSizes();
            //Assigns all Vector2 Positions of Ship Readout Texts.
            AssignShipReadoutPositions();
            //Adjusts Ship Position Vector2s so that Ships are centered at their given ShipS[a].xL ,yL locations.
            ReassignShipVectors();
        }

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            content = new ContentManager(Services);
            Content.RootDirectory = "Content";
            graphics.PreferredBackBufferWidth = (int)ScreenSize.X;
            graphics.PreferredBackBufferHeight = (int)ScreenSize.Y;
            this.graphics.IsFullScreen = true;
            this.IsMouseVisible = true;
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        //protected override void UnloadContent()
        //{
        // TODO: Unload any non ContentManager content here
        //}

        //Assigns All Ship Arrays
        public void InputShipS()
        {
            // public SpaceShip(double xL, double yL, double xV, double yV, double xA, double yA, int Alignment,
            //int TypeOfSpaceShip, int HI, int PSI, int RSI, int IDSI, int STEX)
            //public SpaceShip(double xL, double yL, double xV, double yV, double xA, double yA, int Alignment, int TypeOfSpaceShip)
            //public SpaceShip(double xL, double yL, int Alignment, int TypeOfSpaceShip)
            
            //Inputs Green Ships
            ShipS[0] = new SpaceCommand.Resources.Ship(340, 25, 0, 0);
            ShipS[1] = new SpaceCommand.Resources.Ship(393, 25, 0, 0);
            ShipS[2] = new SpaceCommand.Resources.Ship(446, 25, 0, 0);
            ShipS[3] = new SpaceCommand.Resources.Ship( 86, 25, 0, 1);
            ShipS[4] = new SpaceCommand.Resources.Ship(700, 25, 0, 1);
            ShipS[5] = new SpaceCommand.Resources.Ship(340, 75, 0, 2);
            ShipS[6] = new SpaceCommand.Resources.Ship(393, 75, 0, 2);
            ShipS[7] = new SpaceCommand.Resources.Ship(446, 75, 0, 2);
            //Inputs Red Ships
            ShipS[8] = new SpaceCommand.Resources.Ship (340, 875, 1, 0);
            ShipS[9] = new SpaceCommand.Resources.Ship (393, 875, 1, 0);
            ShipS[10] = new SpaceCommand.Resources.Ship(446, 875, 1, 0);
            ShipS[11] = new SpaceCommand.Resources.Ship( 86, 875, 1, 1);
            ShipS[12] = new SpaceCommand.Resources.Ship(700, 875, 1, 1);
            ShipS[13] = new SpaceCommand.Resources.Ship(340, 825, 1, 2);
            ShipS[14] = new SpaceCommand.Resources.Ship(393, 825, 1, 2);
            ShipS[15] = new SpaceCommand.Resources.Ship(446, 825, 1, 2);
        }

        public void AssignShipReadoutPositions()
        {
            //Sets the coordinates to draw Ship Readout Squares and Selection Borders by 
            //Drawing purple and orange sqares with green and Red Squares on the inside.
            ShipReadoutPositions[0] = new Vector2(784, 0);
            ShipReadoutPositions[1] = new Vector2(948, 0);
            ShipReadoutPositions[2] = new Vector2(1112, 0);
            ShipReadoutPositions[3] = new Vector2(1276, 0);
            ShipReadoutPositions[4] = new Vector2(784, 150);
            ShipReadoutPositions[5] = new Vector2(948, 150);
            ShipReadoutPositions[6] = new Vector2(1112, 150);
            ShipReadoutPositions[7] = new Vector2(1276, 150);
            ShipReadoutPositions[8] = new Vector2(784, 300);
            ShipReadoutPositions[9] = new Vector2(948, 300);
            ShipReadoutPositions[10] = new Vector2(1112, 300);
            ShipReadoutPositions[11] = new Vector2(1276, 300);
            ShipReadoutPositions[12] = new Vector2(784, 450);
            ShipReadoutPositions[13] = new Vector2(948, 450);
            ShipReadoutPositions[14] = new Vector2(1112, 450);
            ShipReadoutPositions[15] = new Vector2(1276, 450);
            //Draws the Box inside the Purple or Orange Box
            ShipSelectedReadoutPositions[0] = new Vector2(790, 6);
            ShipSelectedReadoutPositions[1] = new Vector2(954, 6);
            ShipSelectedReadoutPositions[2] = new Vector2(1118, 6);
            ShipSelectedReadoutPositions[3] = new Vector2(1284, 6);
            ShipSelectedReadoutPositions[4] = new Vector2(790, 156);
            ShipSelectedReadoutPositions[5] = new Vector2(954, 156);
            ShipSelectedReadoutPositions[6] = new Vector2(1118, 156);
            ShipSelectedReadoutPositions[7] = new Vector2(1284, 156);
            ShipSelectedReadoutPositions[8] = new Vector2(790, 306);
            ShipSelectedReadoutPositions[9] = new Vector2(954, 306);
            ShipSelectedReadoutPositions[10] = new Vector2(1118, 306);
            ShipSelectedReadoutPositions[11] = new Vector2(1284, 306);
            ShipSelectedReadoutPositions[12] = new Vector2(790, 456);
            ShipSelectedReadoutPositions[13] = new Vector2(954, 456);
            ShipSelectedReadoutPositions[14] = new Vector2(1118, 456);
            ShipSelectedReadoutPositions[15] = new Vector2(1284, 456);
            //Sets Positions of Ship Name Text Drawings
            ShipNamePositions[0] = new Vector2(790, 6);
            ShipNamePositions[1] = new Vector2(954, 6);
            ShipNamePositions[2] = new Vector2(1118, 6);
            ShipNamePositions[3] = new Vector2(1284, 6);
            ShipNamePositions[4] = new Vector2(790, 156);
            ShipNamePositions[5] = new Vector2(954, 156);
            ShipNamePositions[6] = new Vector2(1118, 156);
            ShipNamePositions[7] = new Vector2(1284, 156);
            ShipNamePositions[8] = new Vector2(790, 306);
            ShipNamePositions[9] = new Vector2(954, 306);
            ShipNamePositions[10] = new Vector2(1118, 306);
            ShipNamePositions[11] = new Vector2(1284, 306);
            ShipNamePositions[12] = new Vector2(790, 456);
            ShipNamePositions[13] = new Vector2(954, 456);
            ShipNamePositions[14] = new Vector2(1118, 456);
            ShipNamePositions[15] = new Vector2(1284, 456);
            //Sets The Hull Integrity Display Position
            ShipHIPositions[0] = new Vector2(790, 23);
            ShipHIPositions[1] = new Vector2(954, 23);
            ShipHIPositions[2] = new Vector2(1118, 23);
            ShipHIPositions[3] = new Vector2(1284, 23);
            ShipHIPositions[4] = new Vector2(790, 173);
            ShipHIPositions[5] = new Vector2(954, 173);
            ShipHIPositions[6] = new Vector2(1118, 173);
            ShipHIPositions[7] = new Vector2(1284, 173);
            ShipHIPositions[8] = new Vector2(790, 323);
            ShipHIPositions[9] = new Vector2(954, 323);
            ShipHIPositions[10] = new Vector2(1118, 323);
            ShipHIPositions[11] = new Vector2(1284, 323);
            ShipHIPositions[12] = new Vector2(790, 473);
            ShipHIPositions[13] = new Vector2(954, 473);
            ShipHIPositions[14] = new Vector2(1118, 473);
            ShipHIPositions[15] = new Vector2(1284, 473);
            //Sets The Power System Integrity Display Position
            ShipPSIPositions[0] = new Vector2(790, 40);
            ShipPSIPositions[1] = new Vector2(954, 40);
            ShipPSIPositions[2] = new Vector2(1118, 40);
            ShipPSIPositions[3] = new Vector2(1284, 40);
            ShipPSIPositions[4] = new Vector2(790, 190);
            ShipPSIPositions[5] = new Vector2(954, 190);
            ShipPSIPositions[6] = new Vector2(1118, 190);
            ShipPSIPositions[7] = new Vector2(1284, 190);
            ShipPSIPositions[8] = new Vector2(790, 340);
            ShipPSIPositions[9] = new Vector2(954, 340);
            ShipPSIPositions[10] = new Vector2(1118, 340);
            ShipPSIPositions[11] = new Vector2(1284, 340);
            ShipPSIPositions[12] = new Vector2(790, 490);
            ShipPSIPositions[13] = new Vector2(954, 490);
            ShipPSIPositions[14] = new Vector2(1118, 490);
            ShipPSIPositions[15] = new Vector2(1284, 490);
            //Sets The Rail System Integrity Display Position
            ShipRSIPositions[0] = new Vector2(790, 57);
            ShipRSIPositions[1] = new Vector2(954, 57);
            ShipRSIPositions[2] = new Vector2(1118, 57);
            ShipRSIPositions[3] = new Vector2(1284, 57);
            ShipRSIPositions[4] = new Vector2(790, 207);
            ShipRSIPositions[5] = new Vector2(954, 207);
            ShipRSIPositions[6] = new Vector2(1118, 207);
            ShipRSIPositions[7] = new Vector2(1284, 207);
            ShipRSIPositions[8] = new Vector2(790, 357);
            ShipRSIPositions[9] = new Vector2(954, 357);
            ShipRSIPositions[10] = new Vector2(1118, 357);
            ShipRSIPositions[11] = new Vector2(1284, 357);
            ShipRSIPositions[12] = new Vector2(790, 507);
            ShipRSIPositions[13] = new Vector2(954, 507);
            ShipRSIPositions[14] = new Vector2(1118, 507);
            ShipRSIPositions[15] = new Vector2(1284, 507);
            //Sets The Internal Defence System Integrity Display Position
            ShipIDSIPositions[0] = new Vector2(790, 74);
            ShipIDSIPositions[1] = new Vector2(954, 74);
            ShipIDSIPositions[2] = new Vector2(1118, 74);
            ShipIDSIPositions[3] = new Vector2(1284, 74);
            ShipIDSIPositions[4] = new Vector2(790, 224);
            ShipIDSIPositions[5] = new Vector2(954, 224);
            ShipIDSIPositions[6] = new Vector2(1118, 224);
            ShipIDSIPositions[7] = new Vector2(1284, 224);
            ShipIDSIPositions[8] = new Vector2(790, 374);
            ShipIDSIPositions[9] = new Vector2(954, 374);
            ShipIDSIPositions[10] = new Vector2(1118, 374);
            ShipIDSIPositions[11] = new Vector2(1284, 374);
            ShipIDSIPositions[12] = new Vector2(790, 524);
            ShipIDSIPositions[13] = new Vector2(954, 524);
            ShipIDSIPositions[14] = new Vector2(1118, 524);
            ShipIDSIPositions[15] = new Vector2(1284, 524);
            //Sets The Number Of STEX Invaders Display Position
            ShipSTEXPositions[0] = new Vector2(790, 91);
            ShipSTEXPositions[1] = new Vector2(954, 91);
            ShipSTEXPositions[2] = new Vector2(1118, 91);
            ShipSTEXPositions[3] = new Vector2(1284, 91);
            ShipSTEXPositions[4] = new Vector2(790, 241);
            ShipSTEXPositions[5] = new Vector2(954, 241);
            ShipSTEXPositions[6] = new Vector2(1118, 241);
            ShipSTEXPositions[7] = new Vector2(1284, 241);
            ShipSTEXPositions[8] = new Vector2(790, 391);
            ShipSTEXPositions[9] = new Vector2(954, 391);
            ShipSTEXPositions[10] = new Vector2(1118, 391);
            ShipSTEXPositions[11] = new Vector2(1284, 391);
            ShipSTEXPositions[12] = new Vector2(790, 541);
            ShipSTEXPositions[13] = new Vector2(954, 541);
            ShipSTEXPositions[14] = new Vector2(1118, 541);
            ShipSTEXPositions[15] = new Vector2(1284, 541);
            //Sets The Number Of AutoRepair Points Display Position
            ShipAutoRepairPositions[0] = new Vector2(790, 108);
            ShipAutoRepairPositions[1] = new Vector2(954, 108);
            ShipAutoRepairPositions[2] = new Vector2(1118, 108);
            ShipAutoRepairPositions[3] = new Vector2(1284, 108);
            ShipAutoRepairPositions[4] = new Vector2(790, 258);
            ShipAutoRepairPositions[5] = new Vector2(954, 258);
            ShipAutoRepairPositions[6] = new Vector2(1118, 258);
            ShipAutoRepairPositions[7] = new Vector2(1284, 258);
            ShipAutoRepairPositions[8] = new Vector2(790, 408);
            ShipAutoRepairPositions[9] = new Vector2(954, 408);
            ShipAutoRepairPositions[10] = new Vector2(1118, 408);
            ShipAutoRepairPositions[11] = new Vector2(1284, 408);
            ShipAutoRepairPositions[12] = new Vector2(790, 558);
            ShipAutoRepairPositions[13] = new Vector2(954, 558);
            ShipAutoRepairPositions[14] = new Vector2(1118, 558);
            ShipAutoRepairPositions[15] = new Vector2(1284, 558);
            //Sets The position of the Self-Destruct Initiator.
            ShipDetonateTextPositions[0] = new Vector2(790, 125);
            ShipDetonateTextPositions[1] = new Vector2(954, 125);
            ShipDetonateTextPositions[2] = new Vector2(1118, 125);
            ShipDetonateTextPositions[3] = new Vector2(1284, 125);
            ShipDetonateTextPositions[4] = new Vector2(790, 275);
            ShipDetonateTextPositions[5] = new Vector2(954, 275);
            ShipDetonateTextPositions[6] = new Vector2(1118, 275);
            ShipDetonateTextPositions[7] = new Vector2(1284, 275);
            ShipDetonateTextPositions[8] = new Vector2(790, 425);
            ShipDetonateTextPositions[9] = new Vector2(954, 425);
            ShipDetonateTextPositions[10] = new Vector2(1118, 425);
            ShipDetonateTextPositions[11] = new Vector2(1284, 425);
            ShipDetonateTextPositions[12] = new Vector2(790, 575);
            ShipDetonateTextPositions[13] = new Vector2(954, 575);
            ShipDetonateTextPositions[14] = new Vector2(1118, 575);
            ShipDetonateTextPositions[15] = new Vector2(1284, 575);
            //Sets The position of the Self-Destruct Finalizer.
            ShipDetonateSureTextPositions[0] = new Vector2(875, 125);
            ShipDetonateSureTextPositions[1] = new Vector2(1039, 125);
            ShipDetonateSureTextPositions[2] = new Vector2(1203, 125);
            ShipDetonateSureTextPositions[3] = new Vector2(1369, 125);
            ShipDetonateSureTextPositions[4] = new Vector2(875, 275);
            ShipDetonateSureTextPositions[5] = new Vector2(1039, 275);
            ShipDetonateSureTextPositions[6] = new Vector2(1203, 275);
            ShipDetonateSureTextPositions[7] = new Vector2(1369, 275);
            ShipDetonateSureTextPositions[8] = new Vector2(875, 425);
            ShipDetonateSureTextPositions[9] = new Vector2(1039, 425);
            ShipDetonateSureTextPositions[10] = new Vector2(1203, 425);
            ShipDetonateSureTextPositions[11] = new Vector2(1369, 425);
            ShipDetonateSureTextPositions[12] = new Vector2(875, 575);
            ShipDetonateSureTextPositions[13] = new Vector2(1039, 575);
            ShipDetonateSureTextPositions[14] = new Vector2(1203, 575);
            ShipDetonateSureTextPositions[15] = new Vector2(1369, 575);
        }

        public void ReassignShipStats()
        {
            for (int a = 0; a <= 15; a++)
            {
                ReloadShipStats(a);                
            }
        }

        public void ReloadShipStats(int a)
        {
            //The Following If Else Sequence Loads Both Names and Textured Depending on the Type Of SpaceShip
            if (ShipS[a].Alignment == 0 && ShipS[a].TypeOfSpaceShip == 0)
            {
                ShipNameTexts[a] = "Green Leviathan";
                ShipTextures[a] = Content.Load<Texture2D>("GreenLeviathan");
            }
            else if (ShipS[a].Alignment == 0 && ShipS[a].TypeOfSpaceShip == 1)
            {
                ShipNameTexts[a] = "Green Cruiser";
                ShipTextures[a] = Content.Load<Texture2D>("GreenCruiser");
            }
            else if (ShipS[a].Alignment == 0 && ShipS[a].TypeOfSpaceShip == 2)
            {
                ShipNameTexts[a] = "Green Invader";
                ShipTextures[a] = Content.Load<Texture2D>("GreenInvader");
            }
            else if (ShipS[a].Alignment == 1 && ShipS[a].TypeOfSpaceShip == 0)
            {
                ShipNameTexts[a] = "Red Leviathan";
                ShipTextures[a] = Content.Load<Texture2D>("RedLeviathan");
            }
            else if (ShipS[a].Alignment == 1 && ShipS[a].TypeOfSpaceShip == 1)
            {
                ShipNameTexts[a] = "Red Cruiser";
                ShipTextures[a] = Content.Load<Texture2D>("RedCruiser");
            }
            else if (ShipS[a].Alignment == 1 && ShipS[a].TypeOfSpaceShip == 2)
            {
                ShipNameTexts[a] = "Red Invader";
                ShipTextures[a] = Content.Load<Texture2D>("RedInvader");
            }
            else
            {
                //Control Element in case a new number is found for Alignment or TypeOfSpaceship
                ShipNameTexts[a] = "Control";
                ShipTextures[a] = Content.Load<Texture2D>("xOut");
            }
            //Loads Hull Integrity, Power System Integrity, Rail System Integrity which could be depleted until the next turn,
            //Internal Defence Systems, STEX invaders, and AutoRepair
            ShipHITexts[a] = "Hull I: " + Convert.ToString(ShipS[a].HI);
            ShipPSITexts[a] = "Power SI: " + Convert.ToString(ShipS[a].PSI);
            if (ShipS[a].CanLaunchRail == true)
                ShipRSITexts[a] = "Rail SI: " + Convert.ToString(ShipS[a].RSI);
            else
                ShipRSITexts[a] = "Rail SI: " + Convert.ToString(ShipS[a].RSI) + " Out";
            ShipIDSITexts[a] = "InternalDefI: " + Convert.ToString(ShipS[a].IDSI);
            ShipSTEXTexts[a] = "STEX: " + Convert.ToString(ShipS[a].STEX);
            ShipAutoRepairTexts[a] = "AutoRepair: " + Convert.ToString(ShipS[a].AutoRepair);
            //Makes it easier for the computer to access the width and height of a ship sprite
            ShipTextureWidthHeights[a] = new Vector2(ShipTextures[a].Width, ShipTextures[a].Height);
        }

        public void AssignTextSizes()
        {
            for (int a = 0; a <= 15; a++)
            {
                ShipHITextSizes[a] = AstonF1.MeasureString(ShipHITexts[a]);
                ShipPSITextSizes[a] = AstonF1.MeasureString(ShipPSITexts[a]);
                ShipRSITextSizes[a] = AstonF1.MeasureString(ShipRSITexts[a]);
                ShipIDSITextSizes[a] = AstonF1.MeasureString(ShipIDSITexts[a]);
                ShipSTEXTextSizes[a] = AstonF1.MeasureString(ShipSTEXTexts[a]);
                ShipAutoRepairTextSizes[a] = AstonF1.MeasureString(ShipAutoRepairTexts[a]);
            }
            ShipDetonateTextSize = AstonF1.MeasureString(ShipDetonateText);
            ShipDetonateSureTextSize = AstonF1.MeasureString(ShipDetonateSureText);
        }

        public void UpdateShipLocations()
        {
            //Update Coords for Green Ships
            ShipS[0].UpdateCoordsAndV();
            ShipS[1].UpdateCoordsAndV();
            ShipS[2].UpdateCoordsAndV();
            ShipS[3].UpdateCoordsAndV();
            ShipS[4].UpdateCoordsAndV();
            ShipS[5].UpdateCoordsAndV();
            ShipS[6].UpdateCoordsAndV();
            ShipS[7].UpdateCoordsAndV();
            //Update Coords for Red Ships
            ShipS[8].UpdateCoordsAndV();
            ShipS[9].UpdateCoordsAndV();
            ShipS[10].UpdateCoordsAndV();
            ShipS[11].UpdateCoordsAndV();
            ShipS[12].UpdateCoordsAndV();
            ShipS[13].UpdateCoordsAndV();
            ShipS[14].UpdateCoordsAndV();
            ShipS[15].UpdateCoordsAndV();
            ReassignShipVectors();
        }

        public void ReassignShipVectors()
        {
            for (int a = 0; a <= 15; a++)
            {
                ShipPositions[a] = new Vector2(ShipS[a].xL - ShipTextureWidthHeights[a].X / 2,
                    ShipS[a].yL - ShipTextureWidthHeights[a].Y / 2);
            }
        }
        //What Happens When a Ship Self Destructs its fusion generators blowing up every ship in its Radius of Death.
        public void NuclearDetonation(int NumberToBeDetonated)
        {
            soundDetonation.Play();
            float radiusOfDeath = 0;
            if (ShipS[NumberToBeDetonated].TypeOfSpaceShip == 0)
                radiusOfDeath = 50;
            else
                if (ShipS[NumberToBeDetonated].TypeOfSpaceShip == 1)
                    radiusOfDeath = 36;
                else
                    if (ShipS[NumberToBeDetonated].TypeOfSpaceShip == 2)
                        radiusOfDeath = 18;
            for (int a = 0; a <= 15; a++)
            {
                if (System.Math.Pow((System.Math.Pow((ShipS[a].xL - ShipS[NumberToBeDetonated].xL), 2) +
                    System.Math.Pow((ShipS[a].yL - ShipS[NumberToBeDetonated].yL), 2)), 0.5) < radiusOfDeath
                    && ShipS[a].HI > 0)
                {
                    DestroyShip(a);
                    ReloadShipStats(a);
                }
            }

        }

        public void CheckForCollisions()
        {
            for (int a = 0; a <= 15; a++)
            {
                for (int b = 0; b <= 15; b++)
                {
                    if (b != a & Math.Abs(ShipS[a].xL - ShipS[b].xL) < (ShipS[a].XDim + ShipS[b].XDim) / 2 &
                    Math.Abs(ShipS[a].yL - ShipS[b].yL) < (ShipS[a].YDim + ShipS[b].YDim) / 2 &
                    ShipS[a].HI > 0 & ShipS[b].HI > 0)
                    {
                        soundCollision.Play();
                        if (ShipS[a].TypeOfSpaceShip == 0 & ShipS[b].TypeOfSpaceShip == 0)
                        {
                            DestroyShip(a);
                            DestroyShip(b);
                        }
                        else if (ShipS[a].TypeOfSpaceShip != 0 & ShipS[b].TypeOfSpaceShip != 0)
                        {
                            int TempHI = ShipS[a].HI;
                            ShipS[a].HI = ShipS[a].HI - ShipS[b].HI;
                            ShipS[b].HI = ShipS[b].HI - TempHI;
                            //Mabey have checking of Hull Integrity for Ship destruction asdf Aparently Works without
                        }
                        else if (ShipS[a].TypeOfSpaceShip == 0 & ShipS[b].TypeOfSpaceShip != 0)
                        {
                            ShipS[a].HI = ShipS[a].HI - ShipS[b].HI;
                            DestroyShip(b);
                        }
                        else if (ShipS[a].TypeOfSpaceShip != 0 & ShipS[b].TypeOfSpaceShip == 0)
                        {
                            ShipS[b].HI = ShipS[b].HI - ShipS[a].HI;
                            DestroyShip(a);
                        }
                    }
                }
            }
        }

        //Destroy Ship Destroys ships by making all their Integrity Values 0
        public void DestroyShip(int NumberToBeDestroyed)
        {
            ShipS[NumberToBeDestroyed].HI = 0;
            ShipS[NumberToBeDestroyed].PSI = 0;
            ShipS[NumberToBeDestroyed].RSI = 0;
            ShipS[NumberToBeDestroyed].IDSI = 0;
            ShipS[NumberToBeDestroyed].STEX = 0;
            ShipS[NumberToBeDestroyed].AutoRepair = 0;
            //GameTime gameTime = new GameTime(0,0);
            //Draw(gameTime);
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {

            checkMouseClick();
            if (leftMouseClicked)
                checkMouseClickWithinShipSprites();
            if (leftMouseClicked || rightMouseClicked)
                checkMouseClickWithinShipReadout();
            if (rightMouseClicked && mousePosition.X >= starFieldPosition.X && mousePosition.Y >= starFieldPosition.X
                && mousePosition.X <= starFieldTexture.Width && mousePosition.Y <= starFieldTexture.Height)
                checkFutureTrajectory();
            // Allows the game to exit
            if (mousePosition.X <= xOutPosition.X + xOutTextureWidthHeight.X && mousePosition.X > xOutPosition.X &&
                mousePosition.Y >= xOutPosition.Y && mousePosition.Y < xOutPosition.Y + xOutTextureWidthHeight.Y)
                this.Exit();
            //Checks to see if any ships have been destroyed and destroys them.
            CheckForCollisions();
            for (int a = 0; a <= 15; a++)
            {
                if (ShipS[a].HI <= 0)
                    DestroyShip(a);
            }
            if (AlignmentOfTurn == 0)
            {
                if (mousePosition.X >= 925 && mousePosition.Y >= 850)
                {
                    mousePosition.X = 900;
                    AlignmentOfTurn = 1;
                    for (int a = 0; a < 100; a++)
                    {
                        UpdateShipLocations();
                        CheckForCollisions();
                        RailLaunchFromShip= false;
                        STEXLaunchFromShip = false;
                        AutoRepairActivated = false;
                        DetonateStandUp = false;
                        DrawStuff(); //Does not work asdf
                        System.Threading.Thread.Sleep(TimeSpan.FromSeconds(.005));
                    }
                }
            }
            else
                if (AlignmentOfTurn == 1)
                {
                    if (mousePosition.X >= 1000 && mousePosition.Y >= 850)
                    {
                        mousePosition.X = 900;
                        AlignmentOfTurn = 0;
                        for (int a = 0; a < 100; a++)
                        {
                            UpdateShipLocations();
                            CheckForCollisions();
                            RailLaunchFromShip = false;
                            STEXLaunchFromShip = false;
                            AutoRepairActivated = false;
                            DetonateStandUp = false;
                            DrawStuff(); //Does not work asdf
                            System.Threading.Thread.Sleep(TimeSpan.FromSeconds(.005));
                        }
                    }
                }
            for (int a = 0; a <= 15; a++)
            {
                ReloadShipStats(a);
            }

            Draw(gameTime);
            base.Update(gameTime);
        }

        //Checks if the Mouse has been clicked and sets which botton has been clicked and writes X,Y coordinates to mouseX and mouseY
        void checkMouseClick()
        {
            mouseState = Mouse.GetState();
            if (mouseState.LeftButton == ButtonState.Pressed)
                leftMouseClicked = true;
            else
            {
                leftMouseClicked = false;
                if (mouseState.RightButton == ButtonState.Pressed)
                    rightMouseClicked = true;
                else
                    rightMouseClicked = false;
            }
            if ((leftMouseClicked == true  || rightMouseClicked == true))
            {
                mousePosition = new Vector2 (mouseState.X, mouseState.Y);
            }
        }

        public void checkMouseClickWithinShipSprites()
        {
            uint[] PixelData = new uint[1];
            Vector2 pixelPosition;
            for (int a = 0; a <= 15; a++)
            {
                pixelPosition = mousePosition - ShipPositions[a];
                //Checks first if mouse click position is within the rectangle where the sprite is drawn.
                if (pixelPosition.X >= 0 && pixelPosition.X < ShipTextureWidthHeights[a].X &&
                    pixelPosition.Y >= 0 && pixelPosition.Y < ShipTextureWidthHeights[a].Y)
                {
                    //Checks second if pixel is not invisible so that the mouse has definitaly clicked directly onto an active part of the sprite.

                    ShipTextures[a].GetData<uint>(0, new Rectangle(((int)pixelPosition.X), ((int)pixelPosition.Y), (1), (1)), PixelData, 0, 1);
                    // Check if pixel in Array is non Alpha ( plus a fudge factor of 20 )
                    if (((PixelData[0] & 0xFF000000) >> 24) > 20)
                        shipNumber = a;
                }
            }
        }

        //Main Body of Game Engine.
        void checkMouseClickWithinShipReadout()
        {
            if (leftMouseClicked)
                for (int a = 0; a <= 15; a++)
                {
                    if (mousePosition.X >= ShipReadoutPositions[a].X && mousePosition.Y >= ShipReadoutPositions[a].Y
                        && mousePosition.X <= ShipReadoutPositions[a].X + ShipReadoutWidthHeight.X
                        && mousePosition.Y <= ShipReadoutPositions[a].Y + ShipReadoutWidthHeight.Y)
                    {
                        if (shipNumber == a)
                        {
                            if (RailLaunchFromShip == false && STEXLaunchFromShip == false && AutoRepairActivated == false
                            && DetonateStandUp == false && ShipS[a].Alignment == AlignmentOfTurn)
                            {
                                if (RailLaunchFromShip == false && STEXLaunchFromShip == false && AutoRepairActivated == false && DetonateStandUp == false)
                                    if (mousePosition.X >= ShipRSIPositions[a].X && mousePosition.X <= ShipRSIPositions[a].X + ShipRSITextSizes[a].X
                                        && mousePosition.Y >= ShipRSIPositions[a].Y && mousePosition.Y <= ShipRSIPositions[a].Y + ShipRSITextSizes[a].Y
                                        && ShipS[a].CanLaunchRail)
                                    {
                                        RailLaunchFromShip = true;
                                        RailDamage = ShipS[a].RSI * ShipS[a].PSI / ShipS[a].PSIMax;
                                        shipNumberOfActive = a;
                                    }
                                    else
                                        if (mousePosition.X >= ShipSTEXPositions[a].X && mousePosition.X <= ShipSTEXPositions[a].X + ShipSTEXTextSizes[a].X
                                            && mousePosition.Y >= ShipSTEXPositions[a].Y && mousePosition.Y <= ShipSTEXPositions[a].Y + ShipSTEXTextSizes[a].Y
                                            && ShipS[a].STEX > 0)
                                        {
                                            STEXLaunchFromShip = true;
                                            STEXImpact = ShipS[a].STEX;
                                            shipNumberOfActive = a;
                                        }
                                        else
                                            if (mousePosition.X >= ShipAutoRepairPositions[a].X && mousePosition.X <= ShipAutoRepairPositions[a].X + ShipAutoRepairTextSizes[a].X
                                            && mousePosition.Y >= ShipAutoRepairPositions[a].Y && mousePosition.Y <= ShipAutoRepairPositions[a].Y + ShipAutoRepairTextSizes[a].Y
                                            && ShipS[a].AutoRepair > 0)
                                            {
                                                AutoRepairActivated = true;
                                                AutoRepairValue = ShipS[a].AutoRepair;
                                                shipNumberOfActive = a;
                                            }
                                            else
                                                if (mousePosition.X >= ShipDetonateTextPositions[a].X && mousePosition.X <= ShipDetonateTextPositions[a].X +
                                                    ShipDetonateTextSize.X && mousePosition.Y >= ShipDetonateTextPositions[a].Y
                                                    && mousePosition.Y <= ShipDetonateTextPositions[a].Y + ShipDetonateTextSize.Y)
                                                {
                                                    soundDetonationStandUp.Play();
                                                    DetonateStandUp = true;
                                                    shipNumberOfActive = a;
                                                }
                            }
                        }
                        else
                            shipNumber = a;
                    }
                }
            else
                if (rightMouseClicked)
                {
                    for (int a = 0; a <= 15; a++)
                    {
                        if (mousePosition.X >= ShipReadoutPositions[a].X && mousePosition.Y >= ShipReadoutPositions[a].Y
                            && mousePosition.X <= ShipReadoutPositions[a].X + ShipReadoutWidthHeight.X
                            && mousePosition.Y <= ShipReadoutPositions[a].Y + ShipReadoutWidthHeight.Y)
                        {
                            if (shipNumberOfActive == a)
                            {
                                if (AutoRepairActivated)
                                {
                                    if (mousePosition.X >= ShipAutoRepairPositions[a].X && mousePosition.X <= ShipAutoRepairPositions[a].X + ShipAutoRepairTextSizes[a].X
                                        && mousePosition.Y >= ShipAutoRepairPositions[a].Y && mousePosition.Y <= ShipAutoRepairPositions[a].Y + ShipAutoRepairTextSizes[a].Y)
                                    {
                                        AutoRepairActivated = false;
                                    }
                                    else
                                        if (mousePosition.X >= ShipHIPositions[a].X && mousePosition.X <= ShipHIPositions[a].X + ShipHITextSizes[a].X
                                            && mousePosition.Y >= ShipHIPositions[a].Y && mousePosition.Y <= ShipHIPositions[a].Y + ShipHITextSizes[a].Y)
                                        {
                                            if (ShipS[a].HI < ShipS[a].HIMax)
                                            {
                                                soundAutoRepair.Play();
                                                if (ShipS[a].HIMax - ShipS[a].HI >= AutoRepairValue)
                                                {
                                                    ShipS[a].HI = ShipS[a].HI + AutoRepairValue;
                                                    ShipS[a].AutoRepair = 0;
                                                    AutoRepairActivated = false;
                                                }
                                                else
                                                {
                                                    AutoRepairValue = AutoRepairValue - (ShipS[a].HIMax - ShipS[a].HI);
                                                    ShipS[a].AutoRepair = AutoRepairValue;
                                                    ShipS[a].HI = ShipS[a].HIMax;
                                                    AutoRepairActivated = false;
                                                }
                                            }
                                        }
                                        else
                                            if (mousePosition.X >= ShipPSIPositions[a].X && mousePosition.X <= ShipPSIPositions[a].X + ShipPSITextSizes[a].X
                                            && mousePosition.Y >= ShipPSIPositions[a].Y && mousePosition.Y <= ShipPSIPositions[a].Y + ShipPSITextSizes[a].Y)
                                            {
                                                if (ShipS[a].PSI < ShipS[a].PSIMax)
                                                {
                                                    soundAutoRepair.Play();
                                                    if (ShipS[a].PSIMax - ShipS[a].PSI >= AutoRepairValue)
                                                    {
                                                        ShipS[a].PSI = ShipS[a].PSI + AutoRepairValue;
                                                        ShipS[a].AutoRepair = 0;
                                                        AutoRepairActivated = false;
                                                    }
                                                    else
                                                    {
                                                        AutoRepairValue = AutoRepairValue - (ShipS[a].PSIMax - ShipS[a].PSI);
                                                        ShipS[a].AutoRepair = AutoRepairValue;
                                                        ShipS[a].PSI = ShipS[a].PSIMax;
                                                    }
                                                }
                                            }
                                            else
                                                if (mousePosition.X >= ShipRSIPositions[a].X && mousePosition.X <= ShipRSIPositions[a].X + ShipRSITextSizes[a].X
                                                && mousePosition.Y >= ShipRSIPositions[a].Y && mousePosition.Y <= ShipRSIPositions[a].Y + ShipRSITextSizes[a].Y)
                                                {
                                                    if (ShipS[a].RSI < ShipS[a].RSIMax)
                                                    {
                                                        soundAutoRepair.Play();
                                                        if (ShipS[a].RSIMax - ShipS[a].RSI >= AutoRepairValue)
                                                        {
                                                            ShipS[a].RSI = ShipS[a].RSI + AutoRepairValue;
                                                            ShipS[a].AutoRepair = 0;
                                                            AutoRepairActivated = false;
                                                        }
                                                        else
                                                        {
                                                            AutoRepairValue = AutoRepairValue - (ShipS[a].RSIMax - ShipS[a].RSI);
                                                            ShipS[a].AutoRepair = AutoRepairValue;
                                                            ShipS[a].RSI = ShipS[a].RSIMax;
                                                        }
                                                    }
                                                }
                                                else
                                                    if (mousePosition.X >= ShipIDSIPositions[a].X && mousePosition.X <= ShipIDSIPositions[a].X + ShipIDSITextSizes[a].X
                                                    && mousePosition.Y >= ShipIDSIPositions[a].Y && mousePosition.Y <= ShipIDSIPositions[a].Y + ShipIDSITextSizes[a].Y)
                                                    {
                                                        if (ShipS[a].IDSI < ShipS[a].IDSIMax)
                                                        {
                                                            soundAutoRepair.Play();
                                                            if (ShipS[a].IDSIMax - ShipS[a].IDSI >= AutoRepairValue)
                                                            {
                                                                ShipS[a].IDSI = ShipS[a].IDSI + AutoRepairValue;
                                                                ShipS[a].AutoRepair = 0;
                                                                AutoRepairActivated = false;
                                                            }
                                                            else
                                                            {
                                                                AutoRepairValue = AutoRepairValue - (ShipS[a].IDSIMax - ShipS[a].IDSI);
                                                                ShipS[a].AutoRepair = AutoRepairValue;
                                                                ShipS[a].IDSI = ShipS[a].IDSIMax;
                                                            }
                                                        }
                                                    }
                                    ReloadShipStats(a);
                                }
                                else
                                    if (mousePosition.X >= ShipRSIPositions[a].X && mousePosition.X <= ShipRSIPositions[a].X + ShipRSITextSizes[a].X
                                            && mousePosition.Y >= ShipRSIPositions[a].Y && mousePosition.Y <= ShipRSIPositions[a].Y + ShipRSITextSizes[a].Y
                                            && RailLaunchFromShip)
                                    {
                                        RailLaunchFromShip = false;
                                    }
                                    else
                                        if (mousePosition.X >= ShipSTEXPositions[a].X && mousePosition.X <= ShipSTEXPositions[a].X + ShipSTEXTextSizes[a].X
                                            && mousePosition.Y >= ShipSTEXPositions[a].Y && mousePosition.Y <= ShipSTEXPositions[a].Y + ShipSTEXTextSizes[a].Y
                                            && STEXLaunchFromShip)
                                        {
                                            STEXLaunchFromShip = false;
                                        }
                                        else
                                            if (mousePosition.X >= ShipDetonateTextPositions[a].X && mousePosition.X <= ShipDetonateTextPositions[a].X +
                                                ShipDetonateTextSize.X && mousePosition.Y >= ShipDetonateTextPositions[a].Y
                                                && mousePosition.Y <= ShipDetonateTextPositions[a].Y + ShipDetonateTextSize.Y
                                                && DetonateStandUp)
                                            {
                                                DetonateStandUp = false;
                                            }
                                            else
                                                if (mousePosition.X >= ShipDetonateSureTextPositions[a].X && mousePosition.X <= ShipDetonateSureTextPositions[a].X +
                                                ShipDetonateSureTextSize.X && mousePosition.Y >= ShipDetonateSureTextPositions[a].Y
                                                && mousePosition.Y <= ShipDetonateSureTextPositions[a].Y + ShipDetonateSureTextSize.Y
                                                && DetonateStandUp)
                                                {
                                                    NuclearDetonation(a);
                                                    DetonateStandUp = false;
                                                }
                            }
                            else
                            {//Too Make progam more efficent do if(RailLaunchFromShip) then the rail test and put other actions under the else of if(RailLaunchFromShip)
                                if (RailLaunchFromShip && System.Math.Pow((System.Math.Pow((ShipS[a].xL - ShipS[shipNumberOfActive].xL), 2) +
                                    System.Math.Pow((ShipS[a].yL - ShipS[shipNumberOfActive].yL), 2)), 0.5) < DistanceForRail)
                                {
                                    if (mousePosition.X >= ShipHIPositions[a].X && mousePosition.X <= ShipHIPositions[a].X + ShipHITextSizes[a].X
                                        && mousePosition.Y >= ShipHIPositions[a].Y && mousePosition.Y <= ShipHIPositions[a].Y + ShipHITextSizes[a].Y
                                        && RailLaunchFromShip)
                                    {
                                        soundRailLaunch.Play();
                                        ShipS[a].HI = ShipS[a].HI - RailDamage;
                                        if (ShipS[a].HI < 0)
                                            ShipS[a].HI = 0;
                                        ShipS[shipNumberOfActive].CanLaunchRail = false;
                                        RailLaunchFromShip = false;
                                        ReloadShipStats(shipNumberOfActive);
                                        ReloadShipStats(a);
                                    }
                                    else
                                        if (mousePosition.X >= ShipPSIPositions[a].X && mousePosition.X <= ShipPSIPositions[a].X + ShipPSITextSizes[a].X
                                        && mousePosition.Y >= ShipPSIPositions[a].Y && mousePosition.Y <= ShipPSIPositions[a].Y + ShipPSITextSizes[a].Y
                                        && RailLaunchFromShip)
                                        {
                                            soundRailLaunch.Play();
                                            ShipS[a].PSI = ShipS[a].PSI - RailDamage;
                                            if (ShipS[a].PSI < 0)
                                                ShipS[a].PSI = 0;
                                            ShipS[shipNumberOfActive].CanLaunchRail = false;
                                            RailLaunchFromShip = false;
                                            ReloadShipStats(shipNumberOfActive);
                                            ReloadShipStats(a);
                                        }
                                        else
                                            if (mousePosition.X >= ShipRSIPositions[a].X && mousePosition.X <= ShipRSIPositions[a].X + ShipRSITextSizes[a].X
                                        && mousePosition.Y >= ShipRSIPositions[a].Y && mousePosition.Y <= ShipRSIPositions[a].Y + ShipRSITextSizes[a].Y
                                        && RailLaunchFromShip)
                                            {
                                                soundRailLaunch.Play();
                                                ShipS[a].RSI = ShipS[a].RSI - RailDamage;
                                                if (ShipS[a].RSI < 0)
                                                    ShipS[a].RSI = 0;
                                                ShipS[shipNumberOfActive].CanLaunchRail = false;
                                                RailLaunchFromShip = false;
                                                ReloadShipStats(shipNumberOfActive);
                                                ReloadShipStats(a);
                                            }
                                            else
                                                if (mousePosition.X >= ShipIDSIPositions[a].X && mousePosition.X <= ShipIDSIPositions[a].X + ShipIDSITextSizes[a].X
                                                    && mousePosition.Y >= ShipIDSIPositions[a].Y && mousePosition.Y <= ShipIDSIPositions[a].Y + ShipIDSITextSizes[a].Y
                                                    && RailLaunchFromShip)
                                                {
                                                    soundRailLaunch.Play();
                                                    ShipS[a].IDSI = ShipS[a].IDSI - RailDamage;
                                                    if (ShipS[a].IDSI < 0)
                                                        ShipS[a].IDSI = 0;
                                                    ShipS[shipNumberOfActive].CanLaunchRail = false;
                                                    RailLaunchFromShip = false;
                                                    ReloadShipStats(shipNumberOfActive);
                                                    ReloadShipStats(a);
                                                }
                                }
                                if (STEXLaunchFromShip && System.Math.Pow((System.Math.Pow((ShipS[a].xL - ShipS[shipNumberOfActive].xL), 2) +
                                    System.Math.Pow((ShipS[a].yL - ShipS[shipNumberOfActive].yL), 2)), 0.5) < DistanceForSTEX
                                    && mousePosition.X >= ShipReadoutPositions[a].X && mousePosition.X <= ShipReadoutPositions[a].X + ShipReadoutWidthHeight.X
                                    && mousePosition.Y >= ShipReadoutPositions[a].Y && mousePosition.Y <= ShipReadoutPositions[a].Y + ShipReadoutWidthHeight.Y
                                    && ShipS[a].Alignment != ShipS[shipNumberOfActive].Alignment)
                                {
                                    soundSTEXLaunch.Play();
                                    if (STEXImpact < ShipS[a].IDSI)
                                    {
                                        ShipS[shipNumberOfActive].STEX = 0;
                                        ShipS[a].IDSI = ShipS[a].IDSI - STEXImpact;
                                    }
                                    else
                                    {
                                        STEXImpact = STEXImpact - ShipS[a].IDSI;
                                        ShipS[a].IDSI = 0;
                                        if (STEXImpact <= ShipS[a].STEX)
                                        {
                                            ShipS[shipNumberOfActive].STEX = 0;
                                            ShipS[a].STEX = ShipS[a].STEX - STEXImpact;
                                        }
                                        else
                                        {
                                            ShipS[a].Alignment = ShipS[shipNumberOfActive].Alignment;
                                            STEXImpact = STEXImpact - ShipS[a].STEX;
                                            if (STEXImpact > 3)
                                            {
                                                STEXImpact = STEXImpact - 2;
                                                ShipS[shipNumberOfActive].STEX = 2;
                                                ShipS[a].STEX = STEXImpact;
                                            }
                                            else
                                            {
                                                ShipS[shipNumberOfActive].STEX = 0;
                                                ShipS[0].STEX = STEXImpact;
                                            }
                                        }
                                    }
                                    STEXLaunchFromShip = false;
                                    ReloadShipStats(a);
                                    ReloadShipStats(shipNumberOfActive);
                                }
                            }
                        }
                    }
                }
        }

        public void checkFutureTrajectory()
        {
            Vector2 StarField;
            if (ShipS[shipNumber].Alignment == AlignmentOfTurn)
            {
                StarField.X = mousePosition.X;
                StarField.Y = mousePosition.Y;
                StarField.X = StarField.X - ShipS[shipNumber].xL;
                StarField.Y = StarField.Y - ShipS[shipNumber].yL;
                float DistanceFromShip = (float)System.Math.Pow(System.Math.Pow(StarField.X, 2) + System.Math.Pow(StarField.Y, 2), 0.5);
                if (DistanceFromShip > DistanceForMove)
                {
                    StarField.X = StarField.X * DistanceForMove / DistanceFromShip;
                    StarField.Y = StarField.Y * DistanceForMove / DistanceFromShip;
                }
                ShipS[shipNumber].xA = StarField.X * ShipS[shipNumber].MaxAcc / DistanceForMove;
                ShipS[shipNumber].yA = StarField.Y * ShipS[shipNumber].MaxAcc / DistanceForMove;
                ShipS[shipNumber].MapFutureTrajectory();
                FutureTrajectoryPoints[0].X = ShipS[shipNumber].FutureTrajectory[0].x;
                FutureTrajectoryPoints[0].Y = ShipS[shipNumber].FutureTrajectory[0].y;
                FutureTrajectoryPoints[1].X = ShipS[shipNumber].FutureTrajectory[1].x;
                FutureTrajectoryPoints[1].Y = ShipS[shipNumber].FutureTrajectory[1].y;
                FutureTrajectoryPoints[2].X = ShipS[shipNumber].FutureTrajectory[2].x;
                FutureTrajectoryPoints[2].Y = ShipS[shipNumber].FutureTrajectory[2].y;
                FutureTrajectoryPoints[3].X = ShipS[shipNumber].FutureTrajectory[3].x;
                FutureTrajectoryPoints[3].Y = ShipS[shipNumber].FutureTrajectory[3].y;
                FutureTrajectoryPoints[4].X = ShipS[shipNumber].FutureTrajectory[4].x;
                FutureTrajectoryPoints[4].Y = ShipS[shipNumber].FutureTrajectory[4].y;
                FutureTrajectoryPoints[5].X = ShipS[shipNumber].FutureTrajectory[5].x;
                FutureTrajectoryPoints[5].Y = ShipS[shipNumber].FutureTrajectory[5].y;
                FutureTrajectoryPoints[6].X = ShipS[shipNumber].FutureTrajectory[6].x;
                FutureTrajectoryPoints[6].Y = ShipS[shipNumber].FutureTrajectory[6].y;
                FutureTrajectoryPoints[7].X = ShipS[shipNumber].FutureTrajectory[7].x;
                FutureTrajectoryPoints[7].Y = ShipS[shipNumber].FutureTrajectory[7].y;
                FutureTrajectoryPoints[8].X = ShipS[shipNumber].FutureTrajectory[8].x;
                FutureTrajectoryPoints[8].Y = ShipS[shipNumber].FutureTrajectory[8].y;
                FutureTrajectoryPoints[9].X = ShipS[shipNumber].FutureTrajectory[9].x;
                FutureTrajectoryPoints[9].Y = ShipS[shipNumber].FutureTrajectory[9].y;
                FutureTrajectoryPoints[10].X = ShipS[shipNumber].FutureTrajectory[10].x;
                FutureTrajectoryPoints[10].Y = ShipS[shipNumber].FutureTrajectory[10].y;
                FutureTrajectoryPoints[11].X = ShipS[shipNumber].FutureTrajectory[11].x;
                FutureTrajectoryPoints[11].Y = ShipS[shipNumber].FutureTrajectory[11].y;
                FutureTrajectoryPoints[12].X = ShipS[shipNumber].FutureTrajectory[12].x;
                FutureTrajectoryPoints[12].Y = ShipS[shipNumber].FutureTrajectory[12].y;
                FutureTrajectoryPoints[13].X = ShipS[shipNumber].FutureTrajectory[13].x;
                FutureTrajectoryPoints[13].Y = ShipS[shipNumber].FutureTrajectory[13].y;
                FutureTrajectoryPoints[14].X = ShipS[shipNumber].FutureTrajectory[14].x;
                FutureTrajectoryPoints[14].Y = ShipS[shipNumber].FutureTrajectory[14].y;
                FutureTrajectoryPoints[15].X = ShipS[shipNumber].FutureTrajectory[15].x;
                FutureTrajectoryPoints[15].Y = ShipS[shipNumber].FutureTrajectory[15].y;
                FutureTrajectoryPoints[16].X = ShipS[shipNumber].FutureTrajectory[16].x;
                FutureTrajectoryPoints[16].Y = ShipS[shipNumber].FutureTrajectory[16].y;
                FutureTrajectoryPoints[17].X = ShipS[shipNumber].FutureTrajectory[17].x;
                FutureTrajectoryPoints[17].Y = ShipS[shipNumber].FutureTrajectory[17].y;
                FutureTrajectoryPoints[18].X = ShipS[shipNumber].FutureTrajectory[18].x;
                FutureTrajectoryPoints[18].Y = ShipS[shipNumber].FutureTrajectory[18].y;
                FutureTrajectoryPoints[19].X = ShipS[shipNumber].FutureTrajectory[19].x;
                FutureTrajectoryPoints[19].Y = ShipS[shipNumber].FutureTrajectory[19].y;
                FutureTrajectoryPoints[20].X = ShipS[shipNumber].FutureTrajectory[20].x;
                FutureTrajectoryPoints[20].Y = ShipS[shipNumber].FutureTrajectory[20].y;
                FutureTrajectoryPoints[21].X = ShipS[shipNumber].FutureTrajectory[21].x;
                FutureTrajectoryPoints[21].Y = ShipS[shipNumber].FutureTrajectory[21].y;
                FutureTrajectoryPoints[22].X = ShipS[shipNumber].FutureTrajectory[22].x;
                FutureTrajectoryPoints[22].Y = ShipS[shipNumber].FutureTrajectory[22].y;
                FutureTrajectoryPoints[23].X = ShipS[shipNumber].FutureTrajectory[23].x;
                FutureTrajectoryPoints[23].Y = ShipS[shipNumber].FutureTrajectory[23].y;
                FutureTrajectoryPoints[24].X = ShipS[shipNumber].FutureTrajectory[24].x;
                FutureTrajectoryPoints[24].Y = ShipS[shipNumber].FutureTrajectory[24].y;
                FutureTrajectoryPoints[25].X = ShipS[shipNumber].FutureTrajectory[25].x;
                FutureTrajectoryPoints[25].Y = ShipS[shipNumber].FutureTrajectory[25].y;
                FutureTrajectoryPoints[26].X = ShipS[shipNumber].FutureTrajectory[26].x;
                FutureTrajectoryPoints[26].Y = ShipS[shipNumber].FutureTrajectory[26].y;
                FutureTrajectoryPoints[27].X = ShipS[shipNumber].FutureTrajectory[27].x;
                FutureTrajectoryPoints[27].Y = ShipS[shipNumber].FutureTrajectory[27].y;
                FutureTrajectoryPoints[28].X = ShipS[shipNumber].FutureTrajectory[28].x;
                FutureTrajectoryPoints[28].Y = ShipS[shipNumber].FutureTrajectory[28].y;
                FutureTrajectoryPoints[29].X = ShipS[shipNumber].FutureTrajectory[29].x;
                FutureTrajectoryPoints[29].Y = ShipS[shipNumber].FutureTrajectory[29].y;
                FutureTrajectoryPoints[30].X = ShipS[shipNumber].FutureTrajectory[30].x;
                FutureTrajectoryPoints[30].Y = ShipS[shipNumber].FutureTrajectory[30].y;
                FutureTrajectoryPoints[31].X = ShipS[shipNumber].FutureTrajectory[31].x;
                FutureTrajectoryPoints[31].Y = ShipS[shipNumber].FutureTrajectory[31].y;
                FutureTrajectoryPoints[32].X = ShipS[shipNumber].FutureTrajectory[32].x;
                FutureTrajectoryPoints[32].Y = ShipS[shipNumber].FutureTrajectory[32].y;
                shipNumberOfTrajectoryShown = shipNumber;
            }
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.Black);

            // Draws the Star Field Background.
            spriteBatch.Begin(SpriteSortMode.FrontToBack, BlendState.AlphaBlend);
            spriteBatch.Draw(starFieldTexture, starFieldPosition, Color.White);
            if (AlignmentOfTurn == 0)
            spriteBatch.DrawString(AstonF1, "End Green's Turn", new Vector2(925, 850), Color.Red,
                                   0, ShipTextOrigin, 4.0f, SpriteEffects.None, 0.5f);
            else if(AlignmentOfTurn == 1)
                spriteBatch.DrawString(AstonF1, "End Red's Turn", new Vector2(1000, 850), Color.Green,
                                       0, ShipTextOrigin, 4.0f, SpriteEffects.None, 0.5f);
            spriteBatch.End();

            DrawStuff();
            

            //Displays Selection Box Around Selected Ship Based On The Variable shipNumber
            DrawSelectionBox();
            //Draws Ship Statistics and Ship Name directly over selection boxes
            DrawShipStats();
            //Draws the X in the UpperRightHand Corner to Exit the Game
            spriteBatch.Begin(SpriteSortMode.BackToFront, BlendState.AlphaBlend);
            spriteBatch.Draw(xOut, xOutPosition, Color.White);
            spriteBatch.End();
            VictoryTest();
            if (shipNumberOfTrajectoryShown == shipNumber) //Makes sure that Trajectorys are not shown when another ship is selected.
            {
                //Draws 33 dots along the future trajectory of the selected ship when right clicking anywhere on the screen.
                DrawFutureTrajectoryDots();
            }
            base.Draw(gameTime);
        }


        public void DrawStuff()
        {
            spriteBatch.Begin(SpriteSortMode.BackToFront, BlendState.AlphaBlend);
            for (int a = 0; a <= 15; a++)
            {   //Draws the Sprites.
                if (ShipS[a].HI > 0)
                {
                    spriteBatch.Draw(ShipTextures[a], ShipPositions[a], Color.White);
                }
                //Draws Ship Readout Backgrounds.
                if (ShipS[a].Alignment == 0)
                {
                    spriteBatch.Draw(greenShipReadoutTexture, ShipReadoutPositions[a], Color.White);
                }
                else
                {
                    spriteBatch.Draw(redShipReadoutTexture, ShipReadoutPositions[a], Color.White);
                }
            }
            spriteBatch.End();
        }

        //Draws 1 Purple or Orange Border Around ShipSelectedReadout.
        public void DrawSelectionBox()
        {
            for (int a = 0; a <= 15; a++)
            {
                if (shipNumber == a)
                {
                    if (ShipS[a].Alignment == 0)
                    {
                        spriteBatch.Begin(SpriteSortMode.FrontToBack, BlendState.AlphaBlend);
                        spriteBatch.Draw(purpleSelectedReadoutTexture, ShipReadoutPositions[a], Color.White);
                        spriteBatch.End();

                        spriteBatch.Begin(SpriteSortMode.BackToFront, BlendState.AlphaBlend);
                        spriteBatch.Draw(greenSelectedReadoutTexture, ShipSelectedReadoutPositions[a], Color.White);
                        spriteBatch.End();
                    }
                    else
                    {
                        spriteBatch.Begin(SpriteSortMode.FrontToBack, BlendState.AlphaBlend);
                        spriteBatch.Draw(orangeSelectedReadoutTexture, ShipReadoutPositions[a], Color.White);
                        spriteBatch.End();

                        spriteBatch.Begin(SpriteSortMode.BackToFront, BlendState.AlphaBlend);
                        spriteBatch.Draw(redSelectedReadoutTexture, ShipSelectedReadoutPositions[a], Color.White);
                        spriteBatch.End();
                    }
                }
            }
        }
        //Draws all Ship Readouts over above selection boxes.
        public void DrawShipStats()
        {
            //Draws ALL ShipS Stastics over Selection Boxes
            for (int a = 0; a <= 15; a++)
            {
                if (ShipS[a].HI > 0)
                {
                    //Do If Else Statements for determining Color Purple Or Orange For Selected Subsystem
                    spriteBatch.Begin();
                    spriteBatch.DrawString(AstonF1, ShipNameTexts[a], ShipNamePositions[a], Color.Black,
                    0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    spriteBatch.DrawString(AstonF1, ShipHITexts[a], ShipHIPositions[a], Color.Black,
                    0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    spriteBatch.DrawString(AstonF1, ShipPSITexts[a], ShipPSIPositions[a], Color.Black,
                    0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    if (a == shipNumberOfActive && RailLaunchFromShip)
                        spriteBatch.DrawString(AstonF1, ShipRSITexts[a], ShipRSIPositions[a], Color.Purple,
                        0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    else
                        spriteBatch.DrawString(AstonF1, ShipRSITexts[a], ShipRSIPositions[a], Color.Black,
                        0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    spriteBatch.DrawString(AstonF1, ShipIDSITexts[a], ShipIDSIPositions[a], Color.Black,
                    0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    if (a == shipNumberOfActive && STEXLaunchFromShip)
                        spriteBatch.DrawString(AstonF1, ShipSTEXTexts[a], ShipSTEXPositions[a], Color.Purple,
                        0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    else
                        spriteBatch.DrawString(AstonF1, ShipSTEXTexts[a], ShipSTEXPositions[a], Color.Black,
                        0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    if (a == shipNumberOfActive && AutoRepairActivated)
                        spriteBatch.DrawString(AstonF1, ShipAutoRepairTexts[a], ShipAutoRepairPositions[a], Color.Purple,
                        0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    else
                        spriteBatch.DrawString(AstonF1, ShipAutoRepairTexts[a], ShipAutoRepairPositions[a], Color.Black,
                        0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    if (ShipS[a].Alignment == AlignmentOfTurn)
                    {
                        if (a == shipNumberOfActive && DetonateStandUp)
                        {
                            spriteBatch.DrawString(AstonF1, ShipDetonateText, ShipDetonateTextPositions[a], Color.Purple,
                            0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                            spriteBatch.DrawString(AstonF1, ShipDetonateSureText, ShipDetonateSureTextPositions[a], Color.White,
                            0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                        }
                        else
                            spriteBatch.DrawString(AstonF1, ShipDetonateText, ShipDetonateTextPositions[a], Color.Orange,
                            0, ShipTextOrigin, 1.0f, SpriteEffects.None, 0.5f);
                    }
                    spriteBatch.End();
                }
            }
        }
        //Draws 33 dots representing the future trajectory of the selected Ship.
        public void DrawFutureTrajectoryDots()
        {
            spriteBatch.Begin(SpriteSortMode.BackToFront, BlendState.AlphaBlend);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[0] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[1] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[2] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[3] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[4] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[5] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[6] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[7] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[8] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[9] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[10] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[11] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[12] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[13] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[14] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[15] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[16] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[17] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[18] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[19] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[20] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[21] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[22] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[23] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[24] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[25] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[26] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[27] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[28] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[29] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[30] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[31] - DotTextureSize / 2, Color.White);
            spriteBatch.Draw(DotTexture, FutureTrajectoryPoints[32] - DotTextureSize / 2, Color.White);
            spriteBatch.End();
        }
        //Tests Whether or not a player is victorious by destroying or captureing all enemy ships.
        public void VictoryTest()
        {
            int NumberOfGreenShips = 0;
            int NumberOfRedShips = 0;
            for (int a = 0; a <= 15; a++)
            {
                if (ShipS[a].Alignment == 0 && ShipS[a].HI > 0)
                    NumberOfGreenShips++;
                else
                    if (ShipS[a].Alignment == 1 && ShipS[a].HI > 0)
                        NumberOfRedShips++;
            }
            spriteBatch.Begin(SpriteSortMode.BackToFront, BlendState.AlphaBlend);
            if (NumberOfGreenShips == 0 && NumberOfRedShips == 0)
                spriteBatch.DrawString(AstonF1, "Stalemate", new Vector2(1077, 800), Color.Blue,
                                   0, ShipTextOrigin, 4.0f, SpriteEffects.None, 0.5f);
            else
                if (NumberOfGreenShips > 0 && NumberOfRedShips == 0)
                    spriteBatch.DrawString(AstonF1, "Green Is Victorious", new Vector2(866, 800), Color.Green,
                                   0, ShipTextOrigin, 4.0f, SpriteEffects.None, 0.5f);
                else
                    if (NumberOfGreenShips == 0 && NumberOfRedShips > 0)
                        spriteBatch.DrawString(AstonF1, "Red Is Victorious", new Vector2(930, 800), Color.Red,
                                   0, ShipTextOrigin, 4.0f, SpriteEffects.None, 0.5f);
            spriteBatch.End();
        }
    }
}