﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
//Below May Be Unnecessary
//using System.ComponentModel;
//using System.Data;
//using System.Drawing;
//using System.Windows.Forms;


namespace SpaceCommand.Resources
{

    abstract class SpaceShip
    {
        public float xL = 0;//1 of the 500 pixels is a kilometer across
        public float yL = 0;
        public float xV = 0;//Velocity is mesured in kilometers/second
        public float yV = 0;
        public float V = 0;
        public float Vanglev = 0;//angle is out of 360 degrees
        public float xA = 0;//Acceleration is kilometers/second sqared
        public float yA = 0;
        public float A = 0;
        public float Aangle = 0;
        public float TempxL = 0;
        public float TempyL = 0;
        public float TempxV = 0;
        public float TempyV = 0;
        public float TempxA = 0;
        public float TempyA = 0;
        public int TypeOfSpaceShip;
        public const float TimeInterval = 0.005f;
        public float XDim; //returns X dimension 
        public float YDim;
        public int STEX;//STrengh Enhancing Exosceleton, Can board or defend, counts evenly with Internal Defences
        public int HIMax; //maximum integrity
        public int PSIMax;   //maximum power system
        public int RSIMax;   //maximum rail system
        public int IDSIMax;  //maximum internal defence system
        public int HI;  //Hull integrity
        public int PSI; //Power system integrity
        public int RSI; //rail system integrity
        public int IDSI;//internal defence system, counts like a STEX defending can be repaired
        public int AutoRepairMax; //maximum repair fluid flow/count
        public int AutoRepair; //Current Level of AutoRepair
        public float MaxAcc; //MaxAcceleration
        public int Alignment;
        public static int NumTPs = 33;
        public bool CanLaunchRail = true;
        public TrajectoryPoint[] FutureTrajectory;
        abstract public void UpdateCoordsAndV();

        public struct TrajectoryPoint
        {
            public int x;
            public int y;
        }
        
        public SpaceShip(float xL, float yL, int Alignment, int TypeOfSpaceShip)
        {
            this.xL = xL;
            this.yL = yL;
            this.TypeOfSpaceShip = TypeOfSpaceShip;
            this.Alignment = Alignment;
        }

        public SpaceShip(float xL, float yL, float xV, float yV, float xA, float yA, int Alignment, int TypeOfSpaceShip)
        {
            this.xL = xL;
            this.yL = yL;
            this.xV = xV;
            this.yV = yV;
            this.xA = xA;
            this.yA = yA;
            this.Alignment = Alignment;
            this.TypeOfSpaceShip = TypeOfSpaceShip;
        }

        public SpaceShip(float xL, float yL, float xV, float yV, float xA, float yA, int Alignment,
            int TypeOfSpaceShip, int HI, int PSI, int RSI, int IDSI, int STEX)
        {
            this.xL = xL;
            this.yL = yL;
            this.xV = xV;
            this.yV = yV;
            this.xA = xA;
            this.yA = yA;
            this.Alignment = Alignment;
            this.TypeOfSpaceShip = TypeOfSpaceShip;
            this.HI = HI;
            this.PSI = PSI;
            this.RSI = RSI;
            this.IDSI = IDSI;
            this.STEX = STEX;
        }
    }

    class Ship : SpaceShip
    {
        public Ship(float xL, float yL, int Alignment, int TypeOfSpaceShip)
            : base( xL, yL, Alignment, TypeOfSpaceShip)
        {
            if (TypeOfSpaceShip == 0)
            {
                XDim       = 4;
                YDim       = 4;
                HIMax    = 100; //standard values for defult constructor
                PSIMax      = 50;
                RSIMax      = 20;
                IDSIMax     = 20;
                AutoRepairMax = 4;
                HI         = HIMax;
                PSI        = PSIMax;
                RSI        = RSIMax;
                IDSI       = IDSIMax;
                AutoRepair = 4;
                STEX       = 16;
                MaxAcc     = 4;  
            }

            if (TypeOfSpaceShip == 1)
            {
                XDim       = 2;
                YDim       = 2;
                HIMax      = 50; //standard values for defult constructor
                PSIMax      = 35;
                RSIMax      = 12;
                IDSIMax     = 15;
                AutoRepairMax = 2;
                HI         = HIMax;
                PSI        = PSIMax;
                RSI        = RSIMax;
                IDSI       = IDSIMax;
                AutoRepair = 2;
                STEX       = 4;
                MaxAcc     = 8;  
            }

            if (TypeOfSpaceShip == 2)
            {
                XDim       = 2;
                YDim       = 2;
                HIMax      = 50; //standard values for defult constructor
                PSIMax      = 25;
                RSIMax      = 5;
                IDSIMax     = 20;
                AutoRepairMax = 2;
                HI         = HIMax;
                PSI        = PSIMax;
                RSI        = RSIMax;
                IDSI       = IDSIMax;
                AutoRepair = 2;
                STEX       = 30;
                MaxAcc     = 6;  
            }
        }

        public Ship(float xL, float yL, float xV, float yV, float xA, float yA, int Alignment, int TypeOfSpaceShip)
            : base(xL, yL, xV, yV, xA, yA, Alignment, TypeOfSpaceShip)
        {
            /*xL = xL;
            yL = yL;
            Alignment = Alignment;
            TypeOfSpaceShip = TypeOfSpaceShip;*/
            if (TypeOfSpaceShip == 0)
            {
                XDim = 4;
                YDim = 4;
                HIMax = 100; //standard values for defult constructor
                PSIMax = 50;
                RSIMax = 20;
                IDSIMax = 20;
                AutoRepairMax = 4;
                HI = HIMax;
                PSI = PSIMax;
                RSI = RSIMax;
                IDSI = IDSIMax;
                AutoRepair = 4;
                STEX = 16;
                MaxAcc = 4;
            }

            if (TypeOfSpaceShip == 1)
            {
                XDim = 2;
                YDim = 2;
                HIMax = 50; //standard values for defult constructor
                PSIMax = 35;
                RSIMax = 12;
                IDSIMax = 15;
                AutoRepairMax = 2;
                HI = HIMax;
                PSI = PSIMax;
                RSI = RSIMax;
                IDSI = IDSIMax;
                AutoRepair = 2;
                STEX = 4;
                MaxAcc = 8;
            }

            if (TypeOfSpaceShip == 2)
            {
                XDim = 2;
                YDim = 2;
                HIMax = 50; //standard values for defult constructor
                PSIMax = 25;
                RSIMax = 5;
                IDSIMax = 20;
                AutoRepairMax = 2;
                HI = HIMax;
                PSI = PSIMax;
                RSI = RSIMax;
                IDSI = IDSIMax;
                AutoRepair = 2;
                STEX = 30;
                MaxAcc = 6;
            }
        }

        public Ship(float xL, float yL, float xV, float yV, float xA, float yA, int Alignment,
            int TypeOfSpaceShip, int HI, int PSI, int RSI, int IDSI, int STEX)
            : base(xL, yL, xV, yV, xA, yA, Alignment, TypeOfSpaceShip, HI, PSI, RSI, IDSI, STEX)
        {
            if (TypeOfSpaceShip == 0)
            {
                XDim = 4;
                YDim = 4;
                HIMax = 100; //standard values for defult constructor
                PSIMax = 50;
                RSIMax = 20;
                IDSIMax = 20;
                AutoRepairMax = 4;
                AutoRepair = 4;
                MaxAcc = 4;
            }

            if (TypeOfSpaceShip == 1)
            {
                XDim = 2;
                YDim = 2;
                HIMax = 50; //standard values for defult constructor
                PSIMax = 35;
                RSIMax = 12;
                IDSIMax = 15;
                AutoRepairMax = 2;
                AutoRepair = 2;
                MaxAcc = 8;
            }

            if (TypeOfSpaceShip == 2)
            {
                XDim = 2;
                YDim = 2;
                HIMax = 50; //standard values for defult constructor
                PSIMax = 25;
                RSIMax = 5;
                IDSIMax = 20;
                AutoRepairMax = 2;
                AutoRepair = 2;
                MaxAcc = 6;
            }
        }

        public void MapFutureTrajectory()
        {
            //Figures out 33 points of Future Trajectory
            TempxL = xL;
            TempyL = yL;
            TempxV = xV;
            TempyV = yV;
            TempxA = xA;
            TempyA = yA;
            //Make for () Statement To Do Many interations
            //TimeInterval = 0.005; Interate 1000 times
            RefreshCoords();
            if (FutureTrajectory == null)
                FutureTrajectory = new TrajectoryPoint[33];
            FutureTrajectory[0].x = (int)TempxL;
            FutureTrajectory[0].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[1].x = (int)TempxL;
            FutureTrajectory[1].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[2].x = (int)TempxL;
            FutureTrajectory[2].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[3].x = (int)TempxL;
            FutureTrajectory[3].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[4].x = (int)TempxL;
            FutureTrajectory[4].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[5].x = (int)TempxL;
            FutureTrajectory[5].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[6].x = (int)TempxL;
            FutureTrajectory[6].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[7].x = (int)TempxL;
            FutureTrajectory[7].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[8].x = (int)TempxL;
            FutureTrajectory[8].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[9].x = (int)TempxL;
            FutureTrajectory[9].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[10].x = (int)TempxL;
            FutureTrajectory[10].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[11].x = (int)TempxL;
            FutureTrajectory[11].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[12].x = (int)TempxL;
            FutureTrajectory[12].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[13].x = (int)TempxL;
            FutureTrajectory[13].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[14].x = (int)TempxL;
            FutureTrajectory[14].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[15].x = (int)TempxL;
            FutureTrajectory[15].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[16].x = (int)TempxL;
            FutureTrajectory[16].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[17].x = (int)TempxL;
            FutureTrajectory[17].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[18].x = (int)TempxL;
            FutureTrajectory[18].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[19].x = (int)TempxL;
            FutureTrajectory[19].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[20].x = (int)TempxL;
            FutureTrajectory[20].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[21].x = (int)TempxL;
            FutureTrajectory[21].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[22].x = (int)TempxL;
            FutureTrajectory[22].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[23].x = (int)TempxL;
            FutureTrajectory[23].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[24].x = (int)TempxL;
            FutureTrajectory[24].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[25].x = (int)TempxL;
            FutureTrajectory[25].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[26].x = (int)TempxL;
            FutureTrajectory[26].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[27].x = (int)TempxL;
            FutureTrajectory[27].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[28].x = (int)TempxL;
            FutureTrajectory[28].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[29].x = (int)TempxL;
            FutureTrajectory[29].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[30].x = (int)TempxL;
            FutureTrajectory[30].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[31].x = (int)TempxL;
            FutureTrajectory[31].y = (int)TempyL;
            RefreshCoords();
            FutureTrajectory[32].x = (int)TempxL;
            FutureTrajectory[32].y = (int)TempyL;
        }

        public void RefreshCoords()
        {
            for (int a = 0; a < 100; a++)
            {
                TempxV = TempxV + TempxA * PSI / PSIMax * TimeInterval / 2;
                TempyV = TempyV + TempyA * PSI / PSIMax * TimeInterval / 2;
                TempxL = TempxL + TempxV * TimeInterval;
                TempyL = TempyL + TempyV * TimeInterval;
                TempxV = TempxV + TempxA * PSI / PSIMax * TimeInterval / 2;
                TempyV = TempyV + TempyA * PSI / PSIMax * TimeInterval / 2;
            }
        }

        public override void UpdateCoordsAndV()
        {
            xV = xV + xA * PSI/PSIMax * TimeInterval / 2;
            yV = yV + yA * PSI/PSIMax * TimeInterval / 2;
            xL = xL + xV * TimeInterval;
            yL = yL + yV * TimeInterval;
            xV = xV + xA * PSI/PSIMax * TimeInterval / 2;
            yV = yV + yA * PSI/PSIMax * TimeInterval / 2;
            CanLaunchRail = true;
            AutoRepair = AutoRepairMax;
        }
    }
}