/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.movtool.streaming.MovieHelper;
import org.jcodec.movtool.streaming.MovieSegment;
import org.jcodec.movtool.streaming.VirtualMovie;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public class VirtualMP4Movie
extends VirtualMovie {
    private Brand brand;

    public VirtualMP4Movie(VirtualTrack ... tracks) throws IOException {
        this(Brand.MP4, tracks);
    }

    public VirtualMP4Movie(Brand brand, VirtualTrack ... tracks) throws IOException {
        super(tracks);
        this.brand = brand;
        this.muxTracks();
    }

    @Override
    protected MovieSegment headerChunk(List<MovieSegment> ch, VirtualTrack[] tracks, long dataSize) throws IOException {
        PacketChunk[] chunks = ch.toArray(new PacketChunk[0]);
        int headerSize = MovieHelper.produceHeader(chunks, tracks, dataSize, this.brand).remaining();
        for (PacketChunk chunk : chunks) {
            chunk.offset(headerSize);
        }
        final ByteBuffer header = MovieHelper.produceHeader(chunks, tracks, dataSize, this.brand);
        return new MovieSegment(){

            @Override
            public ByteBuffer getData() {
                return header.duplicate();
            }

            @Override
            public int getNo() {
                return 0;
            }

            @Override
            public long getPos() {
                return 0L;
            }

            @Override
            public int getDataLen() {
                return header.remaining();
            }
        };
    }

    @Override
    protected MovieSegment packetChunk(VirtualTrack track, VirtualPacket pkt, int chunkNo, int trackNo, long pos) {
        return new PacketChunk(pkt, trackNo, chunkNo, pos, track.getCodecMeta().getFourcc());
    }

    public class PacketChunk
    implements MovieSegment {
        private VirtualPacket packet;
        private int track;
        private int no;
        private long pos;
        private String fourcc;

        public PacketChunk(VirtualPacket packet, int track, int no, long pos, String fourcc) {
            this.packet = packet;
            this.track = track;
            this.no = no;
            this.pos = pos;
            this.fourcc = fourcc;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer buf = this.packet.getData().duplicate();
            return buf;
        }

        @Override
        public int getNo() {
            return this.no;
        }

        @Override
        public long getPos() {
            return this.pos;
        }

        public void offset(int off) {
            this.pos += (long)off;
        }

        @Override
        public int getDataLen() throws IOException {
            return this.packet.getDataLen();
        }

        public VirtualPacket getPacket() {
            return this.packet;
        }

        public int getTrackNo() {
            return this.track;
        }
    }
}

