/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.FielExtension;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.boxes.channel.ChannelUtils;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.FramesMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.PCMMP4DemuxerTrack;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.ByteChannelPool;

public class RealTrack
implements VirtualTrack {
    private TrakBox trak;
    private ByteChannelPool pool;
    private AbstractMP4DemuxerTrack demuxer;
    private MovieBox movie;

    public RealTrack(MovieBox movie, TrakBox trak, ByteChannelPool pool) {
        this.movie = movie;
        SampleSizesBox stsz = Box.findFirst((NodeBox)trak, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        this.demuxer = stsz.getDefaultSize() == 0 ? new FramesMP4DemuxerTrack(movie, trak, null){

            @Override
            protected ByteBuffer readPacketData(SeekableByteChannel ch, ByteBuffer buffer, long position, int size) throws IOException {
                return buffer;
            }
        } : new PCMMP4DemuxerTrack(movie, trak, null){

            @Override
            protected ByteBuffer readPacketData(SeekableByteChannel ch, ByteBuffer buffer, long position, int size) throws IOException {
                return buffer;
            }
        };
        this.trak = trak;
        this.pool = pool;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        MP4Packet pkt = this.demuxer.nextFrame(null);
        if (pkt == null) {
            return null;
        }
        return new RealPacket(pkt);
    }

    @Override
    public CodecMeta getCodecMeta() {
        SampleEntry se = this.trak.getSampleEntries()[0];
        if (se instanceof VideoSampleEntry) {
            VideoSampleEntry vse = (VideoSampleEntry)se;
            PixelAspectExt pasp = Box.findFirst((NodeBox)se, PixelAspectExt.class, "pasp");
            FielExtension fiel = Box.findFirst((NodeBox)se, FielExtension.class, "fiel");
            boolean interlace = false;
            boolean topField = false;
            if (fiel != null) {
                interlace = fiel.isInterlaced();
                topField = fiel.topFieldFirst();
            }
            return new VideoCodecMeta(se.getFourcc(), this.extractVideoCodecPrivate(se), new Size(vse.getWidth(), vse.getHeight()), pasp != null ? pasp.getRational() : null, interlace, topField);
        }
        if (se instanceof AudioSampleEntry) {
            AudioSampleEntry ase = (AudioSampleEntry)se;
            ByteBuffer codecPrivate = null;
            if ("mp4a".equals(ase.getFourcc())) {
                LeafBox lb = Box.findFirst((NodeBox)se, LeafBox.class, "esds");
                if (lb == null) {
                    lb = Box.findFirst((NodeBox)se, LeafBox.class, null, "esds");
                }
                codecPrivate = lb.getData();
            }
            return new AudioCodecMeta(se.getFourcc(), ase.calcSampleSize(), ase.getChannelCount(), (int)ase.getSampleRate(), ase.getEndian(), ase.isPCM(), ChannelUtils.getLabels(ase), codecPrivate);
        }
        throw new RuntimeException("Sample entry '" + se.getFourcc() + "' is not supported.");
    }

    private ByteBuffer extractVideoCodecPrivate(SampleEntry se) {
        if ("avc1".equals(se.getFourcc())) {
            LeafBox leaf = Box.findFirst((NodeBox)se, LeafBox.class, "avcC");
            return leaf.getData();
        }
        return null;
    }

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        List<Edit> edits = this.demuxer.getEdits();
        if (edits == null) {
            return null;
        }
        VirtualTrack.VirtualEdit[] result = new VirtualTrack.VirtualEdit[edits.size()];
        for (int i = 0; i < edits.size(); ++i) {
            Edit ee = edits.get(i);
            result[i] = new VirtualTrack.VirtualEdit((double)ee.getMediaTime() / (double)this.trak.getTimescale(), (double)ee.getDuration() / (double)this.movie.getTimescale());
        }
        return result;
    }

    @Override
    public int getPreferredTimescale() {
        return (int)this.demuxer.getTimescale();
    }

    public class RealPacket
    implements VirtualPacket {
        private MP4Packet packet;

        public RealPacket(MP4Packet nextFrame) {
            this.packet = nextFrame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(this.packet.getSize());
            SeekableByteChannel ch = null;
            try {
                ch = RealTrack.this.pool.getChannel();
                if (this.packet.getFileOff() >= ch.size()) {
                    ByteBuffer byteBuffer = null;
                    return byteBuffer;
                }
                ch.position(this.packet.getFileOff());
                ch.read(bb);
                bb.flip();
                ByteBuffer byteBuffer = bb;
                return byteBuffer;
            }
            finally {
                if (ch != null) {
                    ch.close();
                }
            }
        }

        @Override
        public int getDataLen() {
            return this.packet.getSize();
        }

        @Override
        public double getPts() {
            return (double)this.packet.getMediaPts() / (double)this.packet.getTimescale();
        }

        @Override
        public double getDuration() {
            return (double)this.packet.getDuration() / (double)this.packet.getTimescale();
        }

        @Override
        public boolean isKeyframe() {
            return this.packet.isKeyFrame() || this.packet.isPsync();
        }

        @Override
        public int getFrameNo() {
            return (int)this.packet.getFrameNo();
        }
    }
}

