/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.NIOUtils;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.Header;

public class NameBox
extends Box {
    private String name;

    public static String fourcc() {
        return "name";
    }

    public NameBox(String name) {
        this();
        this.name = name;
    }

    public NameBox() {
        super(new Header(NameBox.fourcc()));
    }

    private NameBox(Header header) {
        super(header);
    }

    @Override
    public void parse(ByteBuffer input) {
        this.name = NIOUtils.readNullTermString(input);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.put(JCodecUtil.asciiString(this.name));
        out.putInt(0);
    }

    public String getName() {
        return this.name;
    }
}

