/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.util.List;
import java.util.ListIterator;
import org.jcodec.common.model.Rational;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.QTTimeUtil;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.ClearApertureBox;
import org.jcodec.containers.mp4.boxes.ClipRegionBox;
import org.jcodec.containers.mp4.boxes.DataInfoBox;
import org.jcodec.containers.mp4.boxes.DataRefBox;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.EditListBox;
import org.jcodec.containers.mp4.boxes.EncodedPixelBox;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.HandlerBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MediaBox;
import org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import org.jcodec.containers.mp4.boxes.MediaInfoBox;
import org.jcodec.containers.mp4.boxes.NameBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.ProductionApertureBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import org.jcodec.containers.mp4.boxes.TrackHeaderBox;
import org.jcodec.containers.mp4.boxes.UrlBox;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;

public class TrakBox
extends NodeBox {
    public static String fourcc() {
        return "trak";
    }

    public TrakBox(Header atom) {
        super(atom);
    }

    public TrakBox() {
        super(new Header(TrakBox.fourcc()));
    }

    public void setDataRef(String url) {
        MediaInfoBox minf = this.getMdia().getMinf();
        DataInfoBox dinf = minf.getDinf();
        if (dinf == null) {
            dinf = new DataInfoBox();
            minf.add(dinf);
        }
        DataRefBox dref = dinf.getDref();
        UrlBox urlBox = new UrlBox(url);
        if (dref == null) {
            dref = new DataRefBox();
            dinf.add(dref);
            dref.add(urlBox);
        } else {
            ListIterator<UrlBox> lit = dref.boxes.listIterator();
            while (lit.hasNext()) {
                FullBox box = (FullBox)lit.next();
                if ((box.getFlags() & 1) == 0) continue;
                lit.set(urlBox);
            }
        }
    }

    public MediaBox getMdia() {
        return TrakBox.findFirst((NodeBox)this, MediaBox.class, "mdia");
    }

    public TrackHeaderBox getTrackHeader() {
        return TrakBox.findFirst((NodeBox)this, TrackHeaderBox.class, "tkhd");
    }

    public List<Edit> getEdits() {
        EditListBox elst = TrakBox.findFirst((NodeBox)this, EditListBox.class, "edts", "elst");
        if (elst == null) {
            return null;
        }
        return elst.getEdits();
    }

    public void setEdits(List<Edit> edits) {
        NodeBox edts = TrakBox.findFirst((NodeBox)this, NodeBox.class, "edts");
        if (edts == null) {
            edts = new NodeBox(new Header("edts"));
            this.add(edts);
        }
        edts.removeChildren("elst");
        edts.add(new EditListBox(edits));
        this.getTrackHeader().setDuration(QTTimeUtil.getEditedDuration(this));
    }

    public boolean isVideo() {
        return "vide".equals(this.getHandlerType());
    }

    public boolean isTimecode() {
        return "tmcd".equals(this.getHandlerType());
    }

    public String getHandlerType() {
        HandlerBox handlerBox = TrakBox.findFirst((NodeBox)this, HandlerBox.class, "mdia", "hdlr");
        if (handlerBox == null) {
            return null;
        }
        String type = handlerBox.getComponentSubType();
        return type;
    }

    public boolean isAudio() {
        return "soun".equals(this.getHandlerType());
    }

    public int getTimescale() {
        return TrakBox.findFirst((NodeBox)this, MediaHeaderBox.class, "mdia", "mdhd").getTimescale();
    }

    public long rescale(long tv, long ts) {
        return tv * (long)this.getTimescale() / ts;
    }

    public void setDuration(long duration) {
        this.getTrackHeader().setDuration(duration);
    }

    public long getDuration() {
        return this.getTrackHeader().getDuration();
    }

    public long getMediaDuration() {
        return TrakBox.findFirst((NodeBox)this, MediaHeaderBox.class, "mdia", "mdhd").getDuration();
    }

    public boolean isPureRef() {
        MediaInfoBox minf = this.getMdia().getMinf();
        DataInfoBox dinf = minf.getDinf();
        if (dinf == null) {
            return false;
        }
        DataRefBox dref = dinf.getDref();
        if (dref == null) {
            return false;
        }
        for (Box box : dref.boxes) {
            if ((((FullBox)box).getFlags() & 1) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean hasDataRef() {
        DataInfoBox dinf = this.getMdia().getMinf().getDinf();
        if (dinf == null) {
            return false;
        }
        DataRefBox dref = dinf.getDref();
        if (dref == null) {
            return false;
        }
        boolean result = false;
        for (Box box : dref.boxes) {
            result |= (((FullBox)box).getFlags() & 1) != 1;
        }
        return result;
    }

    public Rational getPAR() {
        PixelAspectExt pasp = NodeBox.findFirst((NodeBox)this, PixelAspectExt.class, "mdia", "minf", "stbl", "stsd", null, "pasp");
        return pasp == null ? new Rational(1, 1) : pasp.getRational();
    }

    public void setPAR(Rational par) {
        for (SampleEntry sampleEntry : this.getSampleEntries()) {
            sampleEntry.removeChildren("pasp");
            sampleEntry.add(new PixelAspectExt(par));
        }
    }

    public SampleEntry[] getSampleEntries() {
        return NodeBox.findAll((Box)this, SampleEntry.class, "mdia", "minf", "stbl", "stsd", null);
    }

    public void setClipRect(short x, short y, short width, short height) {
        NodeBox clip = NodeBox.findFirst((NodeBox)this, NodeBox.class, "clip");
        if (clip == null) {
            clip = new NodeBox(new Header("clip"));
            this.add(clip);
        }
        clip.replace("crgn", new ClipRegionBox(x, y, width, height));
    }

    public long getSampleCount() {
        return NodeBox.findFirst((NodeBox)this, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz").getCount();
    }

    public void setAperture(Size sar, Size dar) {
        this.removeChildren("tapt");
        NodeBox tapt = new NodeBox(new Header("tapt"));
        tapt.add(new ClearApertureBox(dar.getWidth(), dar.getHeight()));
        tapt.add(new ProductionApertureBox(dar.getWidth(), dar.getHeight()));
        tapt.add(new EncodedPixelBox(sar.getWidth(), sar.getHeight()));
        this.add(tapt);
    }

    public void setDimensions(Size dd) {
        this.getTrackHeader().setWidth(dd.getWidth());
        this.getTrackHeader().setHeight(dd.getHeight());
    }

    public int getFrameCount() {
        SampleSizesBox stsz = TrakBox.findFirst((NodeBox)this, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        return stsz.getDefaultSize() != 0 ? stsz.getCount() : stsz.getSizes().length;
    }

    public String getName() {
        NameBox nb = Box.findFirst((NodeBox)this, NameBox.class, "udta", "name");
        return nb == null ? null : nb.getName();
    }

    public void fixMediaTimescale(int ts) {
        TimeToSampleBox.TimeToSampleEntry[] entries;
        MediaHeaderBox mdhd = Box.findFirst((NodeBox)this, MediaHeaderBox.class, "mdia", "mdhd");
        int oldTs = mdhd.getTimescale();
        mdhd.setTimescale(ts);
        mdhd.setDuration((long)ts * mdhd.getDuration() / (long)oldTs);
        List<Edit> edits = this.getEdits();
        if (edits != null) {
            for (Edit edit : edits) {
                edit.setMediaTime((long)ts * edit.getMediaTime() / (long)oldTs);
            }
        }
        TimeToSampleBox tts = Box.findFirst((NodeBox)this, TimeToSampleBox.class, "mdia", "minf", "stbl", "stts");
        for (TimeToSampleBox.TimeToSampleEntry tte : entries = tts.getEntries()) {
            tte.setSampleDuration(ts * tte.getSampleDuration() / oldTs);
        }
    }

    public void setName(String string) {
        NodeBox udta = TrakBox.findFirst((NodeBox)this, NodeBox.class, "udta");
        if (udta == null) {
            udta = new NodeBox(new Header("udta"));
            this.add(udta);
        }
        udta.removeChildren("name");
        udta.add(new NameBox(string));
    }

    public Size getCodedSize() {
        SampleEntry se = this.getSampleEntries()[0];
        if (!(se instanceof VideoSampleEntry)) {
            throw new IllegalArgumentException("Not a video track");
        }
        VideoSampleEntry vse = (VideoSampleEntry)se;
        return new Size(vse.getWidth(), vse.getHeight());
    }

    @Override
    protected void getModelFields(List<String> model) {
    }
}

