/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import org.apache.commons.io.FileSystem;
import org.apache.commons.io.FileSystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class FileSystemUtilsTest {
    FileSystemUtilsTest() {
    }

    static char[] getIllegalFileNameChars() {
        return FileSystem.getCurrent().getIllegalFileNameChars();
    }

    @ParameterizedTest
    @MethodSource(value={"getIllegalFileNameChars"})
    void testGetFreeSpace_IllegalFileName(char illegalFileNameChar) throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileSystemUtils.freeSpace((String)("\\ \"" + illegalFileNameChar)));
    }

    @Test
    void testGetFreeSpace_IllegalFileNames() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileSystemUtils.freeSpace((String)"\\ \""));
    }

    @Test
    void testGetFreeSpace_String() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileSystemUtils.freeSpace(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileSystemUtils.freeSpace((String)"this directory does not exist, at all."));
        Assertions.assertTrue((FileSystemUtils.freeSpace((String)"") > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((FileSystemUtils.freeSpace((String)"target") > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((FileSystemUtils.freeSpace((String)"pom.xml") > 0L ? 1 : 0) != 0);
    }

    @Test
    void testGetFreeSpaceKb() throws Exception {
        Assertions.assertTrue((FileSystemUtils.freeSpaceKb() > 0L ? 1 : 0) != 0);
    }

    @Test
    void testGetFreeSpaceKb_long() throws Exception {
        Assertions.assertTrue((FileSystemUtils.freeSpaceKb((long)0L) > 0L ? 1 : 0) != 0);
    }

    @Test
    void testGetFreeSpaceKb_String() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileSystemUtils.freeSpaceKb(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileSystemUtils.freeSpaceKb((String)"this directory does not exist, at all."));
        Assertions.assertTrue((FileSystemUtils.freeSpaceKb((String)"") > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((FileSystemUtils.freeSpaceKb((String)"target") > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((FileSystemUtils.freeSpaceKb((String)"pom.xml") > 0L ? 1 : 0) != 0);
    }

    @Test
    void testGetFreeSpaceKb_String_long() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileSystemUtils.freeSpaceKb(null, (long)0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileSystemUtils.freeSpaceKb((String)"this directory does not exist, at all.", (long)0L));
        Assertions.assertTrue((FileSystemUtils.freeSpaceKb((String)"", (long)0L) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((FileSystemUtils.freeSpaceKb((String)"target", (long)0L) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((FileSystemUtils.freeSpaceKb((String)"pom.xml", (long)0L) > 0L ? 1 : 0) != 0);
    }
}

