/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.demuxer;

import java.nio.ByteBuffer;
import java.util.List;
import org.jcodec.codecs.aac.AACUtils;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.AudioCodecMeta;
import org.jcodec.common.Codec;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.Ints;
import org.jcodec.common.TrackType;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.RationalLarge;
import org.jcodec.containers.mp4.MP4TrackType;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import org.jcodec.containers.mp4.boxes.TrackHeaderBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.platform.Platform;

public class MP4DemuxerTrackMeta {
    public static DemuxerTrackMeta fromTrack(AbstractMP4DemuxerTrack track) {
        MP4TrackType type;
        int i;
        int[] seekFrames;
        int[] syncSamples;
        TrakBox trak = track.getBox();
        SyncSamplesBox stss = NodeBox.findFirstPath(trak, SyncSamplesBox.class, Box.path("mdia.minf.stbl.stss"));
        int[] nArray = syncSamples = stss == null ? null : stss.getSyncSamples();
        if (syncSamples == null) {
            seekFrames = new int[(int)track.getFrameCount()];
            for (i = 0; i < seekFrames.length; ++i) {
                seekFrames[i] = i;
            }
        } else {
            seekFrames = Platform.copyOfInt(syncSamples, syncSamples.length);
            i = 0;
            while (i < seekFrames.length) {
                int n = i++;
                seekFrames[n] = seekFrames[n] - 1;
            }
        }
        TrackType t = (type = track.getType()) == MP4TrackType.VIDEO ? TrackType.VIDEO : (type == MP4TrackType.SOUND ? TrackType.AUDIO : TrackType.OTHER);
        VideoCodecMeta videoCodecMeta = null;
        AudioCodecMeta audioCodecMeta = null;
        if (type == MP4TrackType.VIDEO) {
            videoCodecMeta = VideoCodecMeta.createSimpleVideoCodecMeta(trak.getCodedSize(), MP4DemuxerTrackMeta.getColorInfo(track));
            PixelAspectExt pasp = NodeBox.findFirst(track.getSampleEntries()[0], PixelAspectExt.class, "pasp");
            if (pasp != null) {
                videoCodecMeta.setPixelAspectRatio(pasp.getRational());
            }
        } else if (type == MP4TrackType.SOUND) {
            AudioSampleEntry ase = (AudioSampleEntry)track.getSampleEntries()[0];
            audioCodecMeta = AudioCodecMeta.fromAudioFormat(ase.getFormat());
        }
        RationalLarge duration = track.getDuration();
        double sec = (double)duration.getNum() / (double)duration.getDen();
        int frameCount = Ints.checkedCast(track.getFrameCount());
        DemuxerTrackMeta meta = new DemuxerTrackMeta(t, Codec.codecByFourcc(track.getFourcc()), sec, seekFrames, frameCount, MP4DemuxerTrackMeta.getCodecPrivate(track), videoCodecMeta, audioCodecMeta);
        if (type == MP4TrackType.VIDEO) {
            TrackHeaderBox tkhd = NodeBox.findFirstPath(trak, TrackHeaderBox.class, Box.path("tkhd"));
            DemuxerTrackMeta.Orientation orientation = tkhd.isOrientation90() ? DemuxerTrackMeta.Orientation.D_90 : (tkhd.isOrientation180() ? DemuxerTrackMeta.Orientation.D_180 : (tkhd.isOrientation270() ? DemuxerTrackMeta.Orientation.D_270 : DemuxerTrackMeta.Orientation.D_0));
            meta.setOrientation(orientation);
        }
        return meta;
    }

    protected static ColorSpace getColorInfo(AbstractMP4DemuxerTrack track) {
        AvcCBox avcC;
        List<ByteBuffer> spsList;
        Codec codec = Codec.codecByFourcc(track.getFourcc());
        if (codec == Codec.H264 && (spsList = (avcC = H264Utils.parseAVCC((VideoSampleEntry)track.getSampleEntries()[0])).getSpsList()).size() > 0) {
            SeqParameterSet sps = SeqParameterSet.read(spsList.get(0).duplicate());
            return sps.getChromaFormatIdc();
        }
        return null;
    }

    public static ByteBuffer getCodecPrivate(AbstractMP4DemuxerTrack track) {
        Codec codec = Codec.codecByFourcc(track.getFourcc());
        if (codec == Codec.H264) {
            AvcCBox avcC = H264Utils.parseAVCC((VideoSampleEntry)track.getSampleEntries()[0]);
            return H264Utils.avcCToAnnexB(avcC);
        }
        if (codec == Codec.AAC) {
            return AACUtils.getCodecPrivate(track.getSampleEntries()[0]);
        }
        return null;
    }
}

