/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.ExperimentalApi;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableListMultimap;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.com.google.common.collect.ImmutableMultimap;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.execution.AbortExecutionException;
import graphql.execution.CoercedVariables;
import graphql.execution.MergedField;
import graphql.execution.NormalizedVariables;
import graphql.execution.RawVariables;
import graphql.execution.ValuesResolver;
import graphql.execution.conditional.ConditionalNodes;
import graphql.execution.directives.QueryDirectives;
import graphql.execution.directives.QueryDirectivesImpl;
import graphql.execution.incremental.IncrementalUtils;
import graphql.introspection.Introspection;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.NodeUtil;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.VariableDefinition;
import graphql.normalized.ENFMerger;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.normalized.NormalizedInputValue;
import graphql.normalized.incremental.NormalizedDeferredExecution;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.impl.SchemaUtil;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@PublicApi
public class ExecutableNormalizedOperationFactory {
    private static final ConditionalNodes conditionalNodes = new ConditionalNodes();

    private ExecutableNormalizedOperationFactory() {
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, Document document, String operationName, CoercedVariables coercedVariableValues) {
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperation(graphQLSchema, document, operationName, coercedVariableValues, Options.defaultOptions());
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, Document document, String operationName, CoercedVariables coercedVariableValues, Options options) {
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operationName);
        return new ExecutableNormalizedOperationFactoryImpl(graphQLSchema, getOperationResult.operationDefinition, getOperationResult.fragmentsByName, coercedVariableValues, null, options).createNormalizedQueryImpl();
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, CoercedVariables coercedVariableValues) {
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperation(graphQLSchema, operationDefinition, fragments, coercedVariableValues, Options.defaultOptions());
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, CoercedVariables coercedVariableValues, Options options) {
        return new ExecutableNormalizedOperationFactoryImpl(graphQLSchema, operationDefinition, fragments, coercedVariableValues, null, options).createNormalizedQueryImpl();
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperationWithRawVariables(GraphQLSchema graphQLSchema, Document document, String operationName, RawVariables rawVariables) {
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperationWithRawVariables(graphQLSchema, document, operationName, rawVariables, Options.defaultOptions());
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperationWithRawVariables(GraphQLSchema graphQLSchema, Document document, String operationName, RawVariables rawVariables, GraphQLContext graphQLContext, Locale locale) {
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperationWithRawVariables(graphQLSchema, document, operationName, rawVariables, Options.defaultOptions().graphQLContext(graphQLContext).locale(locale));
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperationWithRawVariables(GraphQLSchema graphQLSchema, Document document, String operationName, RawVariables rawVariables, Options options) {
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operationName);
        OperationDefinition operationDefinition = getOperationResult.operationDefinition;
        List<VariableDefinition> variableDefinitions = operationDefinition.getVariableDefinitions();
        CoercedVariables coercedVariableValues = ValuesResolver.coerceVariableValues(graphQLSchema, variableDefinitions, rawVariables, options.getGraphQLContext(), options.getLocale());
        NormalizedVariables normalizedVariableValues = ValuesResolver.getNormalizedVariableValues(graphQLSchema, variableDefinitions, rawVariables, options.getGraphQLContext(), options.getLocale());
        return new ExecutableNormalizedOperationFactoryImpl(graphQLSchema, operationDefinition, getOperationResult.fragmentsByName, coercedVariableValues, normalizedVariableValues, options).createNormalizedQueryImpl();
    }

    private static class ExecutableNormalizedOperationFactoryImpl {
        private final GraphQLSchema graphQLSchema;
        private final OperationDefinition operationDefinition;
        private final Map<String, FragmentDefinition> fragments;
        private final CoercedVariables coercedVariableValues;
        private final @Nullable NormalizedVariables normalizedVariableValues;
        private final Options options;
        private final List<PossibleMerger> possibleMergerList = new ArrayList<PossibleMerger>();
        private final ImmutableListMultimap.Builder<Field, ExecutableNormalizedField> fieldToNormalizedField = ImmutableListMultimap.builder();
        private final ImmutableMap.Builder<ExecutableNormalizedField, MergedField> normalizedFieldToMergedField = ImmutableMap.builder();
        private final ImmutableMap.Builder<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives = ImmutableMap.builder();
        private final ImmutableListMultimap.Builder<FieldCoordinates, ExecutableNormalizedField> coordinatesToNormalizedFields = ImmutableListMultimap.builder();
        private int fieldCount = 0;
        private int maxDepthSeen = 0;
        private final List<ExecutableNormalizedField> rootEnfs = new ArrayList<ExecutableNormalizedField>();

        private ExecutableNormalizedOperationFactoryImpl(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, CoercedVariables coercedVariableValues, @Nullable NormalizedVariables normalizedVariableValues, Options options) {
            this.graphQLSchema = graphQLSchema;
            this.operationDefinition = operationDefinition;
            this.fragments = fragments;
            this.coercedVariableValues = coercedVariableValues;
            this.normalizedVariableValues = normalizedVariableValues;
            this.options = options;
        }

        private ExecutableNormalizedOperation createNormalizedQueryImpl() {
            this.buildEnfsRecursively(null, null, 0);
            for (PossibleMerger possibleMerger : this.possibleMergerList) {
                List<ExecutableNormalizedField> childrenWithSameResultKey = possibleMerger.parent.getChildrenWithSameResultKey(possibleMerger.resultKey);
                ENFMerger.merge(possibleMerger.parent, childrenWithSameResultKey, this.graphQLSchema, this.options.deferSupport);
            }
            return new ExecutableNormalizedOperation(this.operationDefinition.getOperation(), this.operationDefinition.getName(), new ArrayList<ExecutableNormalizedField>(this.rootEnfs), (ImmutableListMultimap<Field, ExecutableNormalizedField>)this.fieldToNormalizedField.build(), this.normalizedFieldToMergedField.build(), this.normalizedFieldToQueryDirectives.build(), (ImmutableListMultimap<FieldCoordinates, ExecutableNormalizedField>)this.coordinatesToNormalizedFields.build(), this.fieldCount, this.maxDepthSeen);
        }

        private void captureMergedField(ExecutableNormalizedField enf, MergedField mergedFld) {
            QueryDirectivesImpl queryDirectives = new QueryDirectivesImpl(mergedFld, this.graphQLSchema, this.coercedVariableValues, () -> this.normalizedVariableValues, this.options.getGraphQLContext(), this.options.getLocale());
            this.normalizedFieldToQueryDirectives.put(enf, queryDirectives);
            this.normalizedFieldToMergedField.put(enf, mergedFld);
        }

        private void buildEnfsRecursively(@Nullable ExecutableNormalizedField executableNormalizedField, @Nullable ImmutableList<CollectedField> fieldAndAstParents, int curLevel) {
            ArrayList<CollectedField> collectedFields;
            ImmutableSet<GraphQLObjectType> possibleObjects;
            if (this.maxDepthSeen < curLevel) {
                this.maxDepthSeen = curLevel;
                this.checkMaxDepthExceeded(curLevel);
            }
            if (executableNormalizedField == null) {
                GraphQLObjectType rootType = SchemaUtil.getOperationRootType(this.graphQLSchema, this.operationDefinition);
                possibleObjects = ImmutableSet.of(rootType);
                collectedFields = new ArrayList<CollectedField>();
                this.collectFromSelectionSet(this.operationDefinition.getSelectionSet(), collectedFields, rootType, possibleObjects, null);
            } else {
                List<GraphQLFieldDefinition> fieldDefs = executableNormalizedField.getFieldDefinitions(this.graphQLSchema);
                possibleObjects = this.resolvePossibleObjects(fieldDefs);
                if (possibleObjects.isEmpty()) {
                    return;
                }
                collectedFields = new ArrayList();
                for (CollectedField fieldAndAstParent : fieldAndAstParents) {
                    if (fieldAndAstParent.field.getSelectionSet() == null) continue;
                    GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(this.graphQLSchema, fieldAndAstParent.astTypeCondition, fieldAndAstParent.field.getName());
                    GraphQLCompositeType selectionSetType = (GraphQLCompositeType)((Object)GraphQLTypeUtil.unwrapAll(fieldDefinition.getType()));
                    this.collectFromSelectionSet(fieldAndAstParent.field.getSelectionSet(), collectedFields, selectionSetType, possibleObjects, null);
                }
            }
            Map<String, List<CollectedField>> fieldsByName = this.fieldsByResultKey(collectedFields);
            ImmutableList.Builder<ExecutableNormalizedField> resultNFs = ImmutableList.builder();
            ImmutableListMultimap.Builder<ExecutableNormalizedField, CollectedField> normalizedFieldToAstFields = ImmutableListMultimap.builder();
            this.createNFs(resultNFs, fieldsByName, normalizedFieldToAstFields, curLevel + 1, executableNormalizedField);
            ImmutableCollection nextLevelChildren = resultNFs.build();
            ImmutableMultimap nextLevelNormalizedFieldToAstFields = normalizedFieldToAstFields.build();
            for (ExecutableNormalizedField childENF : nextLevelChildren) {
                if (executableNormalizedField == null) {
                    this.rootEnfs.add(childENF);
                } else {
                    executableNormalizedField.addChild(childENF);
                }
                ImmutableCollection childFieldAndAstParents = ((ImmutableListMultimap)nextLevelNormalizedFieldToAstFields).get(childENF);
                MergedField mergedField = ExecutableNormalizedOperationFactoryImpl.newMergedField((ImmutableList<CollectedField>)childFieldAndAstParents);
                this.captureMergedField(childENF, mergedField);
                this.updateFieldToNFMap(childENF, (ImmutableList<CollectedField>)childFieldAndAstParents);
                this.updateCoordinatedToNFMap(childENF);
                this.buildEnfsRecursively(childENF, (ImmutableList<CollectedField>)childFieldAndAstParents, curLevel + 1);
            }
        }

        private void checkMaxDepthExceeded(int depthSeen) {
            if (depthSeen > this.options.getMaxChildrenDepth()) {
                throw new AbortExecutionException("Maximum query depth exceeded. " + depthSeen + " > " + this.options.getMaxChildrenDepth());
            }
        }

        private static MergedField newMergedField(ImmutableList<CollectedField> fieldAndAstParents) {
            return MergedField.newMergedField(ImmutableKit.map(fieldAndAstParents, fieldAndAstParent -> fieldAndAstParent.field)).build();
        }

        private void updateFieldToNFMap(ExecutableNormalizedField executableNormalizedField, ImmutableList<CollectedField> mergedField) {
            for (CollectedField astField : mergedField) {
                this.fieldToNormalizedField.put((Object)astField.field, (Object)executableNormalizedField);
            }
        }

        private void updateCoordinatedToNFMap(ExecutableNormalizedField topLevel) {
            for (String objectType : topLevel.getObjectTypeNames()) {
                FieldCoordinates coordinates = FieldCoordinates.coordinates(objectType, topLevel.getFieldName());
                this.coordinatesToNormalizedFields.put((Object)coordinates, (Object)topLevel);
            }
        }

        private Map<String, List<CollectedField>> fieldsByResultKey(List<CollectedField> collectedFields) {
            LinkedHashMap<String, List<CollectedField>> fieldsByName = new LinkedHashMap<String, List<CollectedField>>();
            for (CollectedField collectedField : collectedFields) {
                fieldsByName.computeIfAbsent(collectedField.field.getResultKey(), ignored -> new ArrayList()).add(collectedField);
            }
            return fieldsByName;
        }

        private void createNFs(ImmutableList.Builder<ExecutableNormalizedField> nfListBuilder, Map<String, List<CollectedField>> fieldsByName, ImmutableListMultimap.Builder<ExecutableNormalizedField, CollectedField> normalizedFieldToAstFields, int level, ExecutableNormalizedField parent) {
            for (String resultKey : fieldsByName.keySet()) {
                List<CollectedField> fieldsWithSameResultKey = fieldsByName.get(resultKey);
                List<CollectedFieldGroup> commonParentsGroups = this.groupByCommonParents(fieldsWithSameResultKey);
                for (CollectedFieldGroup fieldGroup : commonParentsGroups) {
                    ExecutableNormalizedField nf = this.createNF(fieldGroup, level, parent);
                    if (nf == null) continue;
                    for (CollectedField collectedField : fieldGroup.fields) {
                        normalizedFieldToAstFields.put((Object)nf, (Object)collectedField);
                    }
                    nfListBuilder.add((Object)nf);
                    if (!this.options.deferSupport) continue;
                    nf.addDeferredExecutions(fieldGroup.deferredExecutions);
                }
                if (commonParentsGroups.size() <= 1) continue;
                this.possibleMergerList.add(new PossibleMerger(parent, resultKey));
            }
        }

        private ExecutableNormalizedField createNF(CollectedFieldGroup collectedFieldGroup, int level, ExecutableNormalizedField parent) {
            ++this.fieldCount;
            if (this.fieldCount > this.options.getMaxFieldsCount()) {
                throw new AbortExecutionException("Maximum field count exceeded. " + this.fieldCount + " > " + this.options.getMaxFieldsCount());
            }
            Set<GraphQLObjectType> objectTypes = collectedFieldGroup.objectTypes;
            Field field = collectedFieldGroup.fields.iterator().next().field;
            String fieldName = field.getName();
            GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDefinition(this.graphQLSchema, objectTypes.iterator().next(), fieldName);
            Map<String, Object> argumentValues = ValuesResolver.getArgumentValues(fieldDefinition.getArguments(), field.getArguments(), CoercedVariables.of(this.coercedVariableValues.toMap()), this.options.graphQLContext, this.options.locale);
            Map<String, NormalizedInputValue> normalizedArgumentValues = null;
            if (this.normalizedVariableValues != null) {
                normalizedArgumentValues = ValuesResolver.getNormalizedArgumentValues(fieldDefinition.getArguments(), field.getArguments(), this.normalizedVariableValues.toMap());
            }
            ImmutableList<String> objectTypeNames = ImmutableKit.map(objectTypes, GraphQLObjectType::getName);
            return ExecutableNormalizedField.newNormalizedField().alias(field.getAlias()).resolvedArguments(argumentValues).normalizedArguments(normalizedArgumentValues).astArguments(field.getArguments()).objectTypeNames(objectTypeNames).fieldName(fieldName).level(level).parent(parent).build();
        }

        private List<CollectedFieldGroup> groupByCommonParents(Collection<CollectedField> fields) {
            if (this.options.deferSupport) {
                return this.groupByCommonParentsWithDeferSupport(fields);
            }
            return this.groupByCommonParentsNoDeferSupport(fields);
        }

        private List<CollectedFieldGroup> groupByCommonParentsNoDeferSupport(Collection<CollectedField> fields) {
            ImmutableSet.Builder objectTypes = ImmutableSet.builder();
            for (CollectedField collectedField : fields) {
                objectTypes.addAll(collectedField.objectTypes);
            }
            ImmutableCollection allRelevantObjects = objectTypes.build();
            Map<GraphQLType, ImmutableList<CollectedField>> groupByAstParent = FpKit.groupingBy(fields, fieldAndType -> fieldAndType.astTypeCondition);
            if (groupByAstParent.size() == 1) {
                return Collections.singletonList(new CollectedFieldGroup(ImmutableSet.copyOf(fields), (Set<GraphQLObjectType>)((Object)allRelevantObjects), null));
            }
            ImmutableList.Builder result = ImmutableList.builder();
            for (GraphQLObjectType objectType : allRelevantObjects) {
                Set<CollectedField> relevantFields = FpKit.filterSet(fields, field -> field.objectTypes.contains(objectType));
                result.add(new CollectedFieldGroup(relevantFields, Collections.singleton(objectType), null));
            }
            return result.build();
        }

        private List<CollectedFieldGroup> groupByCommonParentsWithDeferSupport(Collection<CollectedField> fields) {
            Map<GraphQLType, ImmutableList<CollectedField>> groupByAstParent;
            ImmutableSet.Builder objectTypes = ImmutableSet.builder();
            ImmutableSet.Builder deferredExecutionsBuilder = ImmutableSet.builder();
            for (CollectedField collectedField : fields) {
                objectTypes.addAll(collectedField.objectTypes);
                NormalizedDeferredExecution collectedDeferredExecution = collectedField.deferredExecution;
                if (collectedDeferredExecution == null) continue;
                deferredExecutionsBuilder.add(collectedDeferredExecution);
            }
            ImmutableCollection allRelevantObjects = objectTypes.build();
            ImmutableCollection deferredExecutions = deferredExecutionsBuilder.build();
            Set<String> duplicatedLabels = this.listDuplicatedLabels(deferredExecutions);
            if (!duplicatedLabels.isEmpty()) {
                Assert.assertShouldNeverHappen("Duplicated @defer labels are not allowed: [%s]", String.join((CharSequence)",", duplicatedLabels));
            }
            if ((groupByAstParent = FpKit.groupingBy(fields, fieldAndType -> fieldAndType.astTypeCondition)).size() == 1) {
                return Collections.singletonList(new CollectedFieldGroup(ImmutableSet.copyOf(fields), (Set<GraphQLObjectType>)((Object)allRelevantObjects), (Set<NormalizedDeferredExecution>)((Object)deferredExecutions)));
            }
            ImmutableList.Builder result = ImmutableList.builder();
            for (GraphQLObjectType objectType : allRelevantObjects) {
                Set<CollectedField> relevantFields = FpKit.filterSet(fields, field -> field.objectTypes.contains(objectType));
                Set filteredDeferredExecutions = deferredExecutions.stream().filter(ExecutableNormalizedOperationFactoryImpl.filterExecutionsFromType(objectType)).collect(Collectors.toCollection(LinkedHashSet::new));
                result.add(new CollectedFieldGroup(relevantFields, Collections.singleton(objectType), filteredDeferredExecutions));
            }
            return result.build();
        }

        private static Predicate<NormalizedDeferredExecution> filterExecutionsFromType(GraphQLObjectType objectType) {
            String objectTypeName = objectType.getName();
            return deferredExecution -> deferredExecution.getPossibleTypes().stream().map(GraphQLObjectType::getName).anyMatch(objectTypeName::equals);
        }

        private Set<String> listDuplicatedLabels(Collection<NormalizedDeferredExecution> deferredExecutions) {
            return deferredExecutions.stream().map(NormalizedDeferredExecution::getLabel).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        private void collectFromSelectionSet(SelectionSet selectionSet, List<CollectedField> result, GraphQLCompositeType astTypeCondition, Set<GraphQLObjectType> possibleObjects, NormalizedDeferredExecution deferredExecution) {
            for (Selection selection : selectionSet.getSelections()) {
                if (selection instanceof Field) {
                    this.collectField(result, (Field)selection, possibleObjects, astTypeCondition, deferredExecution);
                    continue;
                }
                if (selection instanceof InlineFragment) {
                    this.collectInlineFragment(result, (InlineFragment)selection, possibleObjects, astTypeCondition);
                    continue;
                }
                if (!(selection instanceof FragmentSpread)) continue;
                this.collectFragmentSpread(result, (FragmentSpread)selection, possibleObjects);
            }
        }

        private void collectFragmentSpread(List<CollectedField> result, FragmentSpread fragmentSpread, Set<GraphQLObjectType> possibleObjects) {
            if (!conditionalNodes.shouldInclude(fragmentSpread, this.coercedVariableValues.toMap(), this.graphQLSchema, this.options.graphQLContext)) {
                return;
            }
            FragmentDefinition fragmentDefinition = Assert.assertNotNull(this.fragments.get(fragmentSpread.getName()));
            if (!conditionalNodes.shouldInclude(fragmentDefinition, this.coercedVariableValues.toMap(), this.graphQLSchema, this.options.graphQLContext)) {
                return;
            }
            GraphQLCompositeType newAstTypeCondition = (GraphQLCompositeType)Assert.assertNotNull(this.graphQLSchema.getType(fragmentDefinition.getTypeCondition().getName()));
            Set<GraphQLObjectType> newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newAstTypeCondition);
            NormalizedDeferredExecution newDeferredExecution = this.buildDeferredExecution(fragmentSpread.getDirectives(), newPossibleObjects);
            this.collectFromSelectionSet(fragmentDefinition.getSelectionSet(), result, newAstTypeCondition, newPossibleObjects, newDeferredExecution);
        }

        private void collectInlineFragment(List<CollectedField> result, InlineFragment inlineFragment, Set<GraphQLObjectType> possibleObjects, GraphQLCompositeType astTypeCondition) {
            if (!conditionalNodes.shouldInclude(inlineFragment, this.coercedVariableValues.toMap(), this.graphQLSchema, this.options.graphQLContext)) {
                return;
            }
            Set<GraphQLObjectType> newPossibleObjects = possibleObjects;
            GraphQLCompositeType newAstTypeCondition = astTypeCondition;
            if (inlineFragment.getTypeCondition() != null) {
                newAstTypeCondition = (GraphQLCompositeType)this.graphQLSchema.getType(inlineFragment.getTypeCondition().getName());
                newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newAstTypeCondition);
            }
            NormalizedDeferredExecution newDeferredExecution = this.buildDeferredExecution(inlineFragment.getDirectives(), newPossibleObjects);
            this.collectFromSelectionSet(inlineFragment.getSelectionSet(), result, newAstTypeCondition, newPossibleObjects, newDeferredExecution);
        }

        private @Nullable NormalizedDeferredExecution buildDeferredExecution(List<Directive> directives, Set<GraphQLObjectType> newPossibleObjects) {
            if (!this.options.deferSupport) {
                return null;
            }
            return IncrementalUtils.createDeferredExecution(this.coercedVariableValues.toMap(), directives, label -> new NormalizedDeferredExecution((String)label, newPossibleObjects));
        }

        private void collectField(List<CollectedField> result, Field field, Set<GraphQLObjectType> possibleObjectTypes, GraphQLCompositeType astTypeCondition, NormalizedDeferredExecution deferredExecution) {
            if (!conditionalNodes.shouldInclude(field, this.coercedVariableValues.toMap(), this.graphQLSchema, this.options.graphQLContext)) {
                return;
            }
            if (possibleObjectTypes.isEmpty()) {
                return;
            }
            result.add(new CollectedField(field, possibleObjectTypes, astTypeCondition, deferredExecution));
        }

        private Set<GraphQLObjectType> narrowDownPossibleObjects(Set<GraphQLObjectType> currentOnes, GraphQLCompositeType typeCondition) {
            ImmutableSet<GraphQLObjectType> resolvedTypeCondition = this.resolvePossibleObjects(typeCondition);
            if (currentOnes.isEmpty()) {
                return resolvedTypeCondition;
            }
            return FpKit.intersection(currentOnes, resolvedTypeCondition);
        }

        private ImmutableSet<GraphQLObjectType> resolvePossibleObjects(List<GraphQLFieldDefinition> defs) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (GraphQLFieldDefinition def : defs) {
                GraphQLUnmodifiedType outputType = GraphQLTypeUtil.unwrapAll(def.getType());
                if (!(outputType instanceof GraphQLCompositeType)) continue;
                builder.addAll(this.resolvePossibleObjects((GraphQLCompositeType)((Object)outputType)));
            }
            return builder.build();
        }

        private ImmutableSet<GraphQLObjectType> resolvePossibleObjects(GraphQLCompositeType type) {
            if (type instanceof GraphQLObjectType) {
                return ImmutableSet.of((GraphQLObjectType)type);
            }
            if (type instanceof GraphQLInterfaceType) {
                return ImmutableSet.copyOf(this.graphQLSchema.getImplementations((GraphQLInterfaceType)type));
            }
            if (type instanceof GraphQLUnionType) {
                List<GraphQLNamedOutputType> unionTypes = ((GraphQLUnionType)type).getTypes();
                return ImmutableSet.copyOf(ImmutableKit.map(unionTypes, GraphQLObjectType.class::cast));
            }
            return (ImmutableSet)Assert.assertShouldNeverHappen();
        }

        private static class CollectedFieldGroup {
            Set<GraphQLObjectType> objectTypes;
            Set<CollectedField> fields;
            Set<NormalizedDeferredExecution> deferredExecutions;

            public CollectedFieldGroup(Set<CollectedField> fields, Set<GraphQLObjectType> objectTypes, Set<NormalizedDeferredExecution> deferredExecutions) {
                this.fields = fields;
                this.objectTypes = objectTypes;
                this.deferredExecutions = deferredExecutions;
            }
        }

        private static class CollectedField {
            Field field;
            Set<GraphQLObjectType> objectTypes;
            GraphQLCompositeType astTypeCondition;
            NormalizedDeferredExecution deferredExecution;

            public CollectedField(Field field, Set<GraphQLObjectType> objectTypes, GraphQLCompositeType astTypeCondition, NormalizedDeferredExecution deferredExecution) {
                this.field = field;
                this.objectTypes = objectTypes;
                this.astTypeCondition = astTypeCondition;
                this.deferredExecution = deferredExecution;
            }
        }

        private static class PossibleMerger {
            ExecutableNormalizedField parent;
            String resultKey;

            public PossibleMerger(ExecutableNormalizedField parent, String resultKey) {
                this.parent = parent;
                this.resultKey = resultKey;
            }
        }
    }

    public static class Options {
        private final GraphQLContext graphQLContext;
        private final Locale locale;
        private final int maxChildrenDepth;
        private final int maxFieldsCount;
        private final boolean deferSupport;
        public static final int DEFAULT_MAX_FIELDS_COUNT = 100000;
        private static Options defaultOptions = new Options(GraphQLContext.getDefault(), Locale.getDefault(), Integer.MAX_VALUE, 100000, false);

        private Options(GraphQLContext graphQLContext, Locale locale, int maxChildrenDepth, int maxFieldsCount, boolean deferSupport) {
            this.graphQLContext = graphQLContext;
            this.locale = locale;
            this.maxChildrenDepth = maxChildrenDepth;
            this.deferSupport = deferSupport;
            this.maxFieldsCount = maxFieldsCount;
        }

        public static void setDefaultOptions(Options options) {
            defaultOptions = Assert.assertNotNull(options);
        }

        public static Options defaultOptions() {
            return defaultOptions;
        }

        public Options locale(Locale locale) {
            return new Options(this.graphQLContext, locale, this.maxChildrenDepth, this.maxFieldsCount, this.deferSupport);
        }

        public Options graphQLContext(GraphQLContext graphQLContext) {
            return new Options(graphQLContext, this.locale, this.maxChildrenDepth, this.maxFieldsCount, this.deferSupport);
        }

        public Options maxChildrenDepth(int maxChildrenDepth) {
            return new Options(this.graphQLContext, this.locale, maxChildrenDepth, this.maxFieldsCount, this.deferSupport);
        }

        public Options maxFieldsCount(int maxFieldsCount) {
            return new Options(this.graphQLContext, this.locale, this.maxChildrenDepth, maxFieldsCount, this.deferSupport);
        }

        @ExperimentalApi
        public Options deferSupport(boolean deferSupport) {
            return new Options(this.graphQLContext, this.locale, this.maxChildrenDepth, this.maxFieldsCount, deferSupport);
        }

        public GraphQLContext getGraphQLContext() {
            return this.graphQLContext;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public int getMaxChildrenDepth() {
            return this.maxChildrenDepth;
        }

        public int getMaxFieldsCount() {
            return this.maxFieldsCount;
        }

        @ExperimentalApi
        public boolean getDeferSupport() {
            return this.deferSupport;
        }
    }
}

