/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;

public class RoutableHttpClientFactory
implements HttpClient.Factory {
    private final URL self;
    private final CombinedHandler handler;
    private final HttpClient.Factory delegate;

    public RoutableHttpClientFactory(URL self, CombinedHandler handler, HttpClient.Factory delegate) {
        this.self = Require.nonNull("URL", self);
        this.handler = Require.nonNull("Handler", handler);
        this.delegate = Require.nonNull("Delegate", delegate);
    }

    @Override
    public HttpClient createClient(ClientConfig config) {
        Require.nonNull("Client config", config);
        URI url = config.baseUri();
        if (this.self.getProtocol().equals(url.getScheme()) && this.self.getHost().equals(url.getHost()) && this.self.getPort() == url.getPort()) {
            return new HttpClient(){

                @Override
                public HttpResponse execute(org.openqa.selenium.remote.http.HttpRequest request) throws UncheckedIOException {
                    if (!RoutableHttpClientFactory.this.handler.test(request)) {
                        HttpResponse response = new HttpResponse();
                        response.setStatus(404);
                        response.setContent(Contents.asJson(ImmutableMap.of("value", request.getUri(), "message", "Unable to route " + String.valueOf(request), "error", UnsupportedCommandException.class.getName())));
                        return response;
                    }
                    return RoutableHttpClientFactory.this.handler.execute(request);
                }

                @Override
                public WebSocket openSocket(org.openqa.selenium.remote.http.HttpRequest request, WebSocket.Listener listener) {
                    throw new UnsupportedOperationException("openSocket");
                }

                @Override
                public <T> CompletableFuture<java.net.http.HttpResponse<T>> sendAsyncNative(HttpRequest request, HttpResponse.BodyHandler<T> handler) {
                    throw new UnsupportedOperationException("sendAsyncNative is not supported");
                }

                @Override
                public <T> java.net.http.HttpResponse<T> sendNative(HttpRequest request, HttpResponse.BodyHandler<T> handler) throws IOException, InterruptedException {
                    throw new UnsupportedOperationException("sendNative is not supported");
                }
            };
        }
        return this.delegate.createClient(config);
    }

    @Override
    public void cleanupIdleClients() {
        this.delegate.cleanupIdleClients();
    }
}

