/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.DatastoreV4Proxy;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

abstract class BaseInternalTransactionV4<T>
implements TransactionImpl.InternalTransaction {
    private static final AtomicLong clientIdGenerator = new AtomicLong();
    private static final Map<String, BaseInternalTransactionV4<?>> internalTransactionRegister = new MapMaker().weakValues().makeMap();
    private final String clientId = Long.toString(clientIdGenerator.getAndIncrement());
    private final Map<EntityV4.Key, T> mutationMap = Maps.newLinkedHashMap();
    private final Future<DatastoreV4.BeginTransactionResponse> beginTxnFuture;
    protected final DatastoreV4Proxy dsApiProxy;
    private boolean isWritable = true;

    BaseInternalTransactionV4(DatastoreV4Proxy dsApiProxy, Future<DatastoreV4.BeginTransactionResponse> beginTxnFuture) {
        this.dsApiProxy = dsApiProxy;
        this.beginTxnFuture = beginTxnFuture;
    }

    abstract T serializeMutation(DatastoreV4.Mutation var1);

    abstract Future<?> sendCommit(Collection<T> var1);

    static <T> BaseInternalTransactionV4<T> registerTxn(BaseInternalTransactionV4<T> txn) {
        internalTransactionRegister.put(txn.clientId, txn);
        return txn;
    }

    ByteString getHandle() {
        return FutureHelper.quietGet(this.beginTxnFuture).getTransaction();
    }

    void deferPut(Entity entity) {
        this.deferPut(DataTypeTranslator.toV4Entity(entity));
    }

    void deferPut(EntityV4.Entity.Builder entityProto) {
        this.checkWritable();
        this.mutationMap.put(entityProto.getKey(), this.serializeMutation(DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.UPSERT).setEntity(entityProto).build()));
    }

    void deferDelete(Key key) {
        this.checkWritable();
        EntityV4.Key v4Key = DataTypeTranslator.toV4Key(key).build();
        this.mutationMap.put(v4Key, this.serializeMutation(DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.DELETE).setKey(v4Key).build()));
    }

    @Override
    public Future<Void> doCommitAsync() {
        this.isWritable = false;
        VoidFutureWrapper result = new VoidFutureWrapper(this.sendCommit(this.mutationMap.values()));
        this.mutationMap.clear();
        return result;
    }

    @Override
    public Future<Void> doRollbackAsync() {
        this.isWritable = false;
        this.mutationMap.clear();
        return new VoidFutureWrapper<DatastoreV4.RollbackResponse>(this.dsApiProxy.rollback(DatastoreV4.RollbackRequest.newBuilder().setTransaction(this.getHandle()).build()));
    }

    @Override
    public String getId() {
        return this.clientId;
    }

    private void checkWritable() {
        if (!this.isWritable) {
            throw new IllegalStateException("Transaction is not writable.");
        }
    }

    static BaseInternalTransactionV4<?> getById(String txnClientId) {
        BaseInternalTransactionV4<?> txnImpl = internalTransactionRegister.get(txnClientId);
        if (txnImpl == null) {
            throw new IllegalArgumentException("Transaction not found with ID: " + txnClientId);
        }
        return txnImpl;
    }

    private static class VoidFutureWrapper<T>
    extends FutureWrapper<T, Void> {
        public VoidFutureWrapper(Future<T> parent) {
            super(parent);
        }

        @Override
        protected Void wrap(T ignore) throws Exception {
            return null;
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            return cause;
        }
    }
}

