/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppEngineDatastoreV4Proxy;
import com.google.appengine.api.datastore.AsyncDatastoreServiceImpl;
import com.google.appengine.api.datastore.AsyncDatastoreServiceInternal;
import com.google.appengine.api.datastore.AsyncDatastoreV4ServiceImpl;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceImpl;
import com.google.appengine.api.datastore.DatastoreV4Proxy;
import com.google.appengine.api.datastore.IDatastoreServiceFactory;
import com.google.appengine.api.datastore.TransactionStackImpl;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;

final class DatastoreServiceFactoryImpl
implements IDatastoreServiceFactory {
    DatastoreServiceFactoryImpl() {
    }

    @Override
    public DatastoreService getDatastoreService(DatastoreServiceConfig config) {
        return new DatastoreServiceImpl(this.getAsyncDatastoreService(config));
    }

    @Override
    public AsyncDatastoreServiceInternal getAsyncDatastoreService(DatastoreServiceConfig config) {
        TransactionStackImpl txnStack = new TransactionStackImpl();
        DatastoreV4Proxy datastoreProxy = config.getDatastoreV4Proxy();
        DatastoreServiceConfig.ApiVersion apiVersion = config.getApiVersion();
        switch (apiVersion) {
            case V3: {
                Preconditions.checkState(datastoreProxy == null);
                return new AsyncDatastoreServiceImpl(config, config.constructApiConfig(), txnStack);
            }
            case V4: {
                Preconditions.checkState(datastoreProxy == null);
                return new AsyncDatastoreV4ServiceImpl(config, new AppEngineDatastoreV4Proxy(config.constructApiConfig()), txnStack);
            }
            case CLOUD_DATASTORE: {
                return new AsyncDatastoreV4ServiceImpl(config, datastoreProxy, txnStack);
            }
        }
        throw new IllegalArgumentException("Can't instantiate service with version: " + (Object)((Object)apiVersion));
    }
}

