/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.api.search.DocumentPb;

@AppEngineInternal
public final class FacetChecker {
    public static String checkFacetName(String name) {
        return FacetChecker.checkFacetName(name, "facet name");
    }

    public static String checkFacetName(String name, String callerContext) {
        return FieldChecker.checkFieldName(name, callerContext);
    }

    public static String checkAtom(String atom) {
        FieldChecker.checkAtom(atom);
        Preconditions.checkArgument(!atom.isEmpty(), "Facet atom is empty");
        return atom;
    }

    public static Double checkNumber(Double value) {
        return FieldChecker.checkNumber(value);
    }

    public static DocumentPb.FacetValue checkFacetValue(DocumentPb.FacetValue value) {
        if (value != null) {
            switch (value.getType()) {
                case ATOM: {
                    FacetChecker.checkAtom(value.getStringValue());
                    break;
                }
                case NUMBER: {
                    FacetChecker.checkNumber(Double.parseDouble(value.getStringValue()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported facet type: " + value.getType());
                }
            }
        }
        return value;
    }

    public static DocumentPb.Facet checkValid(DocumentPb.Facet facet) {
        FacetChecker.checkFacetName(facet.getName());
        FacetChecker.checkFacetValue(facet.getValue());
        return facet;
    }

    private FacetChecker() {
    }
}

