/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.AppEngineSocketImplFactory;
import com.google.appengine.api.socket.AppEngineSocketInputStream;
import com.google.appengine.api.socket.AppEngineSocketOptions;
import com.google.appengine.api.socket.AppEngineSocketOptionsClient;
import com.google.appengine.api.socket.AppEngineSocketOutputStream;
import com.google.appengine.api.socket.AppEngineSocketUtils;
import com.google.appengine.api.socket.SocketApiHelper;
import com.google.appengine.api.socket.SocketServicePb;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

class AppEngineSocketImpl
extends SocketImpl
implements AppEngineSocketOptionsClient,
Serializable {
    private static final long serialVersionUID = -2683691443688405980L;
    SocketState currentState = SocketState.UNINITIALIZED;
    private SocketApiHelper socketHelper = null;
    String descriptor = null;
    int soTimeout = -1;
    private boolean readsShutdown = false;
    private boolean writesShutdown = false;
    private final AtomicLong sendOffset = new AtomicLong(0L);
    private AppEngineSocketInputStream socketInputStream = null;
    private boolean stream;
    private InetAddress localAddress;

    AppEngineSocketImpl() {
    }

    AppEngineSocketImpl(SocketApiHelper socketHelper) {
        this.socketHelper = socketHelper;
    }

    SocketApiHelper getSocketApiHelper() {
        return this.socketHelper == null ? AppEngineSocketImplFactory.SOCKET_API_HELPER : this.socketHelper;
    }

    protected InetAddress toInetAddress(SocketServicePb.AddressPort addressPort) throws UnknownHostException {
        return InetAddress.getByAddress(addressPort.getPackedAddressAsBytes());
    }

    void setOption(AppEngineSocketOptions.Option option, Object value) throws SocketException {
        this.checkNotClosed();
        option.validateAndApply(this, value);
    }

    private void createSocketOrCheckNotClosed() throws SocketException {
        if (this.currentState == SocketState.CREATE_CALLED) {
            try {
                this.createSocket(null, 0, null, 0, false);
            }
            catch (SocketTimeoutException e) {
                throw new SocketException(e.getMessage());
            }
        } else {
            this.checkNotClosed();
        }
    }

    @Override
    public void setOption(int opt, Object value) throws SocketException {
        AppEngineSocketOptions.Option option = AppEngineSocketOptions.getOptionById(opt);
        if (option == null) {
            throw new SocketException("unrecognized socket option: " + opt);
        }
        this.setOption(option, value);
    }

    String statesToString(SocketState ... socketStates) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (SocketState state : socketStates) {
            builder.append(prefix);
            prefix = ", ";
            builder.append((Object)state);
        }
        return builder.toString();
    }

    void checkStateIsOneOf(String errorMsg, SocketState ... socketStates) throws SocketException {
        for (SocketState state : socketStates) {
            if (this.currentState != state) continue;
            return;
        }
        throw new SocketException(errorMsg + ": Expected to be in one of states : (" + this.statesToString(socketStates) + "), was in state " + (Object)((Object)this.currentState));
    }

    void checkStateIsNotOneOf(String errorMsg, SocketState ... socketStates) throws SocketException {
        for (SocketState state : socketStates) {
            if (this.currentState != state) continue;
            throw new SocketException(errorMsg + ": Expected to not be in one of (" + this.statesToString(socketStates) + "), was in state " + (Object)((Object)this.currentState));
        }
    }

    private void checkNotClosed() throws SocketException {
        this.checkStateIsNotOneOf("Socket is closed", SocketState.UNINITIALIZED, SocketState.CLOSED);
    }

    @Override
    public void setSocketOptionAsBytes(AppEngineSocketOptions.Option opt, byte[] value) throws SocketException {
        SocketServicePb.SocketOption.SocketOptionName name = opt.getOptName();
        if (name == null) {
            return;
        }
        this.createSocketOrCheckNotClosed();
        SocketServicePb.SetSocketOptionsRequest request = new SocketServicePb.SetSocketOptionsRequest();
        SocketServicePb.SetSocketOptionsReply response = new SocketServicePb.SetSocketOptionsReply();
        request.setSocketDescriptor(this.descriptor);
        request.addOptions().setLevel(opt.getLevel()).setOption(name).setValueAsBytes(value);
        this.getSocketApiHelper().makeSyncCall("SetSocketOptions", request, response, null);
    }

    @Override
    public void setTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        if (15 == optID) {
            if (this.localAddress == null) {
                this.createSocketOrCheckNotClosed();
                this.fixLocalAddress();
            }
            return this.localAddress;
        }
        if (4102 == optID) {
            return this.soTimeout <= 0 ? 0 : this.soTimeout;
        }
        AppEngineSocketOptions.Option option = AppEngineSocketOptions.getOptionById(optID);
        if (option == null) {
            throw new SocketException("unrecognized socket option: " + optID);
        }
        try {
            return this.getOption(option);
        }
        catch (SocketException e) {
            if (128 == optID) {
                return -1;
            }
            throw e;
        }
    }

    private Object getOption(AppEngineSocketOptions.Option option) throws SocketException {
        this.createSocketOrCheckNotClosed();
        return option.getOption(this);
    }

    @Override
    public byte[] getSocketOptionAsBytes(AppEngineSocketOptions.Option option) throws SocketException {
        SocketServicePb.GetSocketOptionsRequest request = new SocketServicePb.GetSocketOptionsRequest();
        SocketServicePb.GetSocketOptionsReply response = new SocketServicePb.GetSocketOptionsReply();
        request.setSocketDescriptor(this.descriptor);
        request.addOptions().setLevel(option.getLevel()).setOption(option.getOptName());
        this.getSocketApiHelper().makeSyncCall("GetSocketOptions", request, response, null);
        return response.optionss().get(0).getValueAsBytes();
    }

    @Override
    protected synchronized void create(boolean stream) throws IOException {
        this.checkStateIsOneOf("Socket is already created", SocketState.UNINITIALIZED);
        this.currentState = SocketState.CREATE_CALLED;
        this.stream = stream;
    }

    @Override
    protected synchronized void connect(String host, int port) throws IOException {
        try {
            InetAddress address = InetAddress.getByName(host);
            this.connectToAddress(address, port, null);
        }
        catch (UnknownHostException e) {
            this.releaseSocket();
            throw e;
        }
    }

    @Override
    protected synchronized void connect(InetAddress address, int port) throws IOException {
        if (address == null) {
            throw new IllegalArgumentException("null address is illegal for connect");
        }
        this.checkStateIsOneOf("socket is not created", SocketState.CREATE_CALLED, SocketState.BOUND);
        this.connectToAddress(address, port, null);
    }

    @Override
    protected synchronized void connect(SocketAddress socketAddress, int timeout) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("null address is illegal for connect");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Address must be of type InetSocketAddress");
        }
        InetSocketAddress addr = (InetSocketAddress)socketAddress;
        if (addr.isUnresolved()) {
            throw new UnknownHostException(addr.getHostName());
        }
        this.connectToAddress(addr.getAddress(), addr.getPort(), timeout == 0 ? null : Integer.valueOf(timeout));
    }

    private void connectToAddress(InetAddress address, int port, Integer timeoutMillis) throws SocketException, SocketTimeoutException {
        switch (this.currentState) {
            case CREATE_CALLED: {
                if (timeoutMillis == null) {
                    this.createSocket(null, 0, address, port, true);
                    break;
                }
                this.createSocket(null, 0, address, port, false);
                this.connectSocket(address, port, timeoutMillis);
                break;
            }
            case BOUND: {
                this.connectSocket(address, port, timeoutMillis);
                break;
            }
        }
        this.port = port;
        this.address = address;
    }

    private void processConnectError(SocketServicePb.RemoteSocketServiceError serviceError) throws SocketException, SocketTimeoutException {
        this.releaseSocket();
        if (SocketServicePb.RemoteSocketServiceError.SystemError.valueOf(serviceError.getSystemError()) == SocketServicePb.RemoteSocketServiceError.SystemError.SYS_EINPROGRESS) {
            throw new SocketTimeoutException();
        }
        if (SocketServicePb.RemoteSocketServiceError.SystemError.valueOf(serviceError.getSystemError()) == SocketServicePb.RemoteSocketServiceError.SystemError.SYS_ETIMEDOUT) {
            throw new SocketTimeoutException();
        }
        if (SocketServicePb.RemoteSocketServiceError.SystemError.valueOf(serviceError.getSystemError()) == SocketServicePb.RemoteSocketServiceError.SystemError.SYS_ECONNREFUSED) {
            throw new ConnectException(serviceError.getErrorDetail());
        }
        throw SocketApiHelper.translateError(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR.getValue(), "errno: " + serviceError.getSystemError() + ", detail:" + serviceError.getErrorDetail());
    }

    private void connectSocket(InetAddress remoteAddress, int remotePort, Integer timeoutMillis) throws SocketException, SocketTimeoutException {
        if (remoteAddress == null) {
            throw new IllegalArgumentException("remoteAddress must not be null if connect requested");
        }
        SocketServicePb.ConnectRequest request = new SocketServicePb.ConnectRequest().setSocketDescriptor(this.descriptor);
        SocketServicePb.ConnectReply response = new SocketServicePb.ConnectReply();
        request.getMutableRemoteIp().setPort(remotePort).setPackedAddressAsBytes(AppEngineSocketUtils.addrAsIpv6Bytes(remoteAddress));
        if (timeoutMillis != null) {
            request.setTimeoutSeconds(0.001 * (double)timeoutMillis.intValue());
        }
        SocketServicePb.RemoteSocketServiceError serviceError = new SocketServicePb.RemoteSocketServiceError();
        if (!this.getSocketApiHelper().makeSyncCall("Connect", request, response, serviceError)) {
            this.processConnectError(serviceError);
        }
        this.currentState = SocketState.CONNECTED;
        this.fixLocalAddress();
    }

    private void releaseSocket() {
        this.readsShutdown = false;
        this.writesShutdown = false;
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.currentState = SocketState.CLOSED;
    }

    private void fixLocalAddress() throws SocketException {
        SocketServicePb.GetSocketNameRequest request = new SocketServicePb.GetSocketNameRequest().setSocketDescriptor(this.descriptor);
        SocketServicePb.GetSocketNameReply response = new SocketServicePb.GetSocketNameReply();
        this.getSocketApiHelper().makeSyncCall("GetSocketName", request, response, null);
        SocketServicePb.AddressPort externalIp = response.getProxyExternalIp();
        this.localport = externalIp.getPort();
        try {
            this.localAddress = this.toInetAddress(externalIp);
        }
        catch (UnknownHostException e) {
            throw new SocketException(e.toString());
        }
    }

    private void createSocket(InetAddress bindAddress, int bindPort, InetAddress remoteAddress, int remotePort, boolean connect) throws SocketException, SocketTimeoutException {
        SocketServicePb.CreateSocketRequest request = new SocketServicePb.CreateSocketRequest();
        SocketServicePb.CreateSocketReply response = new SocketServicePb.CreateSocketReply();
        request.setFamily(SocketServicePb.CreateSocketRequest.SocketFamily.IPv6);
        request.setProtocol(this.stream ? SocketServicePb.CreateSocketRequest.SocketProtocol.TCP : SocketServicePb.CreateSocketRequest.SocketProtocol.UDP);
        if (bindAddress != null) {
            request.getMutableProxyExternalIp().setPort(bindPort).setPackedAddressAsBytes(AppEngineSocketUtils.addrAsIpv6Bytes(bindAddress));
        }
        if (connect) {
            if (remoteAddress == null) {
                throw new IllegalArgumentException("remoteAddress must not be null if connect requested");
            }
            request.getMutableRemoteIp().setPort(remotePort).setPackedAddressAsBytes(AppEngineSocketUtils.addrAsIpv6Bytes(remoteAddress));
            SocketServicePb.RemoteSocketServiceError serviceError = new SocketServicePb.RemoteSocketServiceError();
            if (!this.getSocketApiHelper().makeSyncCall("CreateSocket", request, response, serviceError)) {
                this.processConnectError(serviceError);
            }
        } else {
            this.getSocketApiHelper().makeSyncCall("CreateSocket", request, response, null);
        }
        this.descriptor = response.getSocketDescriptor();
        SocketState socketState = this.currentState = connect ? SocketState.CONNECTED : SocketState.BOUND;
        if (connect) {
            this.fixLocalAddress();
        }
    }

    @Override
    protected synchronized void bind(InetAddress host, int port) throws IOException {
        this.createSocket(host, port, null, 0, false);
        this.currentState = SocketState.BOUND;
    }

    @Override
    protected void listen(int backlog) throws IOException {
        this.checkStateIsNotOneOf("Socket must be in a bound state.", SocketState.UNINITIALIZED, SocketState.CREATE_CALLED, SocketState.CONNECTED, SocketState.CLOSED);
        SocketServicePb.ListenRequest request = new SocketServicePb.ListenRequest().setSocketDescriptor(this.descriptor).setBacklog(backlog);
        this.getSocketApiHelper().makeSyncCall("Listen", request, new SocketServicePb.ListenReply(), null);
        this.currentState = SocketState.LISTEN;
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        this.checkStateIsOneOf("Socket is not in passive (accepting) mode.", SocketState.LISTEN);
        if (!(s instanceof AppEngineSocketImpl)) {
            throw new IllegalStateException("Expected a SocketImpl compatable with '" + this.getClass().getName() + "'. A '" + s.getClass().getName() + "' was received.");
        }
        AppEngineSocketImpl acceptingSocket = (AppEngineSocketImpl)s;
        SocketServicePb.AcceptReply response = new SocketServicePb.AcceptReply();
        SocketServicePb.AcceptRequest request = new SocketServicePb.AcceptRequest().setSocketDescriptor(this.descriptor);
        this.getSocketApiHelper().makeSyncCall("Accept", request, response, null);
        acceptingSocket.doAccept(response);
    }

    private void doAccept(SocketServicePb.AcceptReply response) throws SocketException {
        switch (this.currentState) {
            case CREATE_CALLED: 
            case UNINITIALIZED: 
            case CLOSED: {
                break;
            }
            default: {
                this.releaseSocket();
            }
        }
        this.stream = true;
        this.descriptor = response.getNewSocketDescriptor();
        SocketServicePb.AddressPort addressPort = response.getRemoteAddress();
        try {
            this.address = InetAddress.getByAddress(addressPort.getPackedAddressAsBytes());
        }
        catch (UnknownHostException e) {
            throw new SocketException(e.getMessage());
        }
        this.port = addressPort.getPort();
        this.currentState = SocketState.CONNECTED;
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.currentState == SocketState.CLOSED) {
            throw new IOException("Socket closed.");
        }
        if (this.readsShutdown) {
            throw new IOException("Socket input is shutdown.");
        }
        if (this.socketInputStream == null) {
            this.socketInputStream = new AppEngineSocketInputStream(this);
        }
        return this.socketInputStream;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        if (this.currentState == SocketState.CLOSED) {
            throw new IOException("Socket closed.");
        }
        if (this.writesShutdown) {
            throw new IOException("Socket output is shutdown.");
        }
        return new AppEngineSocketOutputStream(this);
    }

    @Override
    protected int available() throws IOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        if (this.descriptor != null) {
            try {
                SocketServicePb.CloseRequest request = new SocketServicePb.CloseRequest().setSocketDescriptor(this.descriptor).setSendOffset(this.sendOffset.get());
                this.getSocketApiHelper().makeSyncCall("Close", request, new SocketServicePb.CloseReply(), null);
            }
            finally {
                this.currentState = SocketState.CLOSED;
                this.descriptor = null;
            }
        }
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        throw new IllegalStateException("AppEngineSocketImpl#sendUrgentData() function is unimplemented.");
    }

    @Override
    protected void shutdownInput() throws IOException {
        if (this.currentState == SocketState.CONNECTED && !this.readsShutdown) {
            SocketServicePb.ShutDownRequest request = new SocketServicePb.ShutDownRequest().setSocketDescriptor(this.descriptor).setSendOffset(this.sendOffset.get()).setHow(SocketServicePb.ShutDownRequest.How.SOCKET_SHUT_RD);
            this.getSocketApiHelper().makeSyncCall("ShutDown", request, new SocketServicePb.ShutDownReply(), null);
            this.readsShutdown = true;
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        if (this.currentState == SocketState.CONNECTED && !this.writesShutdown) {
            SocketServicePb.ShutDownRequest request = new SocketServicePb.ShutDownRequest().setSocketDescriptor(this.descriptor).setSendOffset(this.sendOffset.get()).setHow(SocketServicePb.ShutDownRequest.How.SOCKET_SHUT_WR);
            this.getSocketApiHelper().makeSyncCall("ShutDown", request, new SocketServicePb.ShutDownReply(), null);
            this.writesShutdown = true;
        }
    }

    protected void send(byte[] buf, int off, int len) throws IOException {
        this.checkStateIsNotOneOf("Socket is closed.", SocketState.UNINITIALIZED, SocketState.CREATE_CALLED, SocketState.CLOSED);
        if (this.writesShutdown) {
            throw new IOException("Socket output is shutdown.");
        }
        byte[] copy = Arrays.copyOfRange(buf, off, off + len);
        SocketServicePb.SendRequest request = new SocketServicePb.SendRequest().setSocketDescriptor(this.descriptor).setStreamOffset(this.sendOffset.getAndAdd(copy.length)).setDataAsBytes(copy);
        if (this.soTimeout > 0) {
            request.setTimeoutSeconds((double)this.soTimeout * 0.001);
        }
        SocketServicePb.RemoteSocketServiceError serviceError = new SocketServicePb.RemoteSocketServiceError();
        if (!this.getSocketApiHelper().makeSyncCall("Send", request, new SocketServicePb.SendReply(), serviceError)) {
            if (serviceError.getSystemError() == SocketServicePb.RemoteSocketServiceError.SystemError.SYS_EAGAIN.getValue()) {
                throw new SocketTimeoutException("Write timed out");
            }
            throw SocketApiHelper.translateError(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR.getValue(), "errno: " + serviceError.getSystemError() + ", detail:" + serviceError.getErrorDetail());
        }
    }

    protected int receive(byte[] buf, int off, int len) throws IOException {
        this.checkStateIsNotOneOf("Socket is closed.", SocketState.UNINITIALIZED, SocketState.CREATE_CALLED, SocketState.CLOSED);
        if (this.readsShutdown) {
            throw new IOException("Socket input is shutdown.");
        }
        if (len < 0 || off < 0 || buf.length - off < len) {
            if (len == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        SocketServicePb.ReceiveReply response = new SocketServicePb.ReceiveReply();
        SocketServicePb.ReceiveRequest request = new SocketServicePb.ReceiveRequest().setSocketDescriptor(this.descriptor).setDataSize(len);
        if (this.soTimeout > 0) {
            request.setTimeoutSeconds((double)this.soTimeout * 0.001);
        }
        SocketServicePb.RemoteSocketServiceError serviceError = new SocketServicePb.RemoteSocketServiceError();
        if (!this.getSocketApiHelper().makeSyncCall("Receive", request, response, serviceError)) {
            if (serviceError.getSystemError() == SocketServicePb.RemoteSocketServiceError.SystemError.SYS_EAGAIN.getValue()) {
                throw new SocketTimeoutException("Read timed out");
            }
            throw SocketApiHelper.translateError(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR.getValue(), "errno: " + serviceError.getSystemError() + ", detail:" + serviceError.getErrorDetail());
        }
        byte[] readBytes = response.getDataAsBytes();
        if (readBytes.length <= 0) {
            return -1;
        }
        System.arraycopy(readBytes, 0, buf, off, readBytes.length);
        return readBytes.length;
    }

    static enum SocketState {
        UNINITIALIZED,
        CREATE_CALLED,
        BOUND,
        CONNECTED,
        LISTEN,
        CLOSED;

    }
}

