/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base.shell;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.io.base.shell.LogUtil;
import com.google.appengine.repackaged.com.google.io.base.shell.TerminationStatus;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CommandResult {
    private static final Logger log = Logger.getLogger("com.google.appengine.repackaged.com.google.io.base.shell.Command");
    @Deprecated
    public static final int NO_EXIT_STATUS = Integer.MIN_VALUE;
    private static final byte[] NO_BYTES = new byte[0];
    static final ByteArrayOutputStream EMPTY_OUTPUT = new ByteArrayOutputStream(){

        @Override
        public byte[] toByteArray() {
            return NO_BYTES;
        }
    };
    static final ByteArrayOutputStream NO_OUTPUT_COLLECTED = new ByteArrayOutputStream(){

        @Override
        public byte[] toByteArray() {
            throw new IllegalStateException("Output was not collected");
        }
    };
    private final ByteArrayOutputStream stdout;
    private final ByteArrayOutputStream stderr;
    private final TerminationStatus terminationStatus;

    @VisibleForTesting
    public static CommandResult createForTesting(ByteArrayOutputStream stdout, ByteArrayOutputStream stderr, TerminationStatus status) {
        return new CommandResult(stdout, stderr, status);
    }

    CommandResult(ByteArrayOutputStream stdout, ByteArrayOutputStream stderr, TerminationStatus terminationStatus) {
        Preconditions.checkNotNull(stdout);
        Preconditions.checkNotNull(stderr);
        Preconditions.checkNotNull(terminationStatus);
        this.stdout = stdout;
        this.stderr = stderr;
        this.terminationStatus = terminationStatus;
    }

    public byte[] getStdout() {
        return this.stdout.toByteArray();
    }

    public byte[] getStderr() {
        return this.stderr.toByteArray();
    }

    @Deprecated
    public int getExitStatus() {
        return this.terminationStatus.getRawResult();
    }

    public TerminationStatus getTerminationStatus() {
        return this.terminationStatus;
    }

    void logThis() {
        if (!log.isLoggable(Level.FINER)) {
            return;
        }
        log.finer(this.terminationStatus.toString());
        if (this.stdout == NO_OUTPUT_COLLECTED) {
            return;
        }
        String string = String.valueOf(LogUtil.toTruncatedString(this.stdout.toByteArray()));
        log.finer(string.length() != 0 ? "Stdout: ".concat(string) : new String("Stdout: "));
        String string2 = String.valueOf(LogUtil.toTruncatedString(this.stderr.toByteArray()));
        log.finer(string2.length() != 0 ? "Stderr: ".concat(string2) : new String("Stderr: "));
    }
}

