/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.MapFieldLite;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapField<K, V> {
    private final Converter<K, V> converter;
    private volatile StorageMode mode;
    private Map<K, V> mapData;
    private List<Message> listData;

    private MapField(Converter<K, V> converter, StorageMode mode, Map<K, V> mapData, List<Message> listData) {
        this.converter = converter;
        this.mode = mode;
        this.mapData = mapData;
        this.listData = listData;
    }

    public static <K, V> MapField<K, V> emptyMapField(Converter<K, V> converter) {
        return new MapField<K, V>(converter, StorageMode.MAP, Collections.emptyMap(), null);
    }

    public static <K, V> MapField<K, V> newMapField(Converter<K, V> converter) {
        return new MapField<K, V>(converter, StorageMode.MAP, new HashMap(), null);
    }

    private List<Message> convertMapToList(Map<K, V> mapData) {
        ArrayList<Message> listData = new ArrayList<Message>();
        for (Map.Entry<K, V> entry : mapData.entrySet()) {
            listData.add(this.converter.convertKeyAndValueToMessage(entry.getKey(), entry.getValue()));
        }
        return listData;
    }

    private Map<K, V> convertListToMap(List<Message> listData) {
        HashMap mapData = new HashMap();
        for (Message item : listData) {
            Converter.Pair<K, V> pair = this.converter.convertMessageToKeyAndValue(item);
            mapData.put(pair.key, pair.value);
        }
        return mapData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getMap() {
        if (this.mode == StorageMode.LIST) {
            MapField mapField = this;
            synchronized (mapField) {
                if (this.mode == StorageMode.LIST) {
                    this.mapData = this.convertListToMap(this.listData);
                    this.mode = StorageMode.BOTH;
                }
            }
        }
        return Collections.unmodifiableMap(this.mapData);
    }

    public Map<K, V> getMutableMap() {
        if (this.mode != StorageMode.MAP) {
            if (this.mode == StorageMode.LIST) {
                this.mapData = this.convertListToMap(this.listData);
            }
            this.listData = null;
            this.mode = StorageMode.MAP;
        }
        return this.mapData;
    }

    public void mergeFrom(MapField<K, V> other) {
        this.getMutableMap().putAll(MapFieldLite.copy(other.getMap()));
    }

    public void clear() {
        this.mapData = new HashMap();
        this.mode = StorageMode.MAP;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapField)) {
            return false;
        }
        MapField other = (MapField)object;
        return MapFieldLite.equals(this.getMap(), other.getMap());
    }

    public int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this.getMap());
    }

    public MapField<K, V> copy() {
        return new MapField<K, V>(this.converter, StorageMode.MAP, MapFieldLite.copy(this.getMap()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getList() {
        if (this.mode == StorageMode.MAP) {
            MapField mapField = this;
            synchronized (mapField) {
                if (this.mode == StorageMode.MAP) {
                    this.listData = this.convertMapToList(this.mapData);
                    this.mode = StorageMode.BOTH;
                }
            }
        }
        return Collections.unmodifiableList(this.listData);
    }

    List<Message> getMutableList() {
        if (this.mode != StorageMode.LIST) {
            if (this.mode == StorageMode.MAP) {
                this.listData = this.convertMapToList(this.mapData);
            }
            this.mapData = null;
            this.mode = StorageMode.LIST;
        }
        return this.listData;
    }

    Message getMapEntryMessageDefaultInstance() {
        return this.converter.getMessageDefaultInstance();
    }

    private static enum StorageMode {
        MAP,
        LIST,
        BOTH;

    }

    public static interface Converter<K, V> {
        public Message convertKeyAndValueToMessage(K var1, V var2);

        public Pair<K, V> convertMessageToKeyAndValue(Message var1);

        public Message getMessageDefaultInstance();

        public static class Pair<K, V> {
            public K key;
            public V value;
        }
    }
}

