/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.datastore.DatastoreV4;

public class QueryV4Normalizer {
    private EntityV4Normalizer entityNormalizer;

    public QueryV4Normalizer(EntityV4Normalizer entityNormalizer) {
        this.entityNormalizer = entityNormalizer;
    }

    public DatastoreV4.RunQueryRequest toV4RunQueryRequest(DatastoreService.RunQueryRequest req) {
        DatastoreV4.RunQueryRequest.Builder reqV4 = DatastoreV4.RunQueryRequest.newBuilder();
        reqV4.setPartitionId(this.entityNormalizer.normalizePartitionId(req.getPartitionId()));
        EntityV4Normalizer contextNormalizer = this.entityNormalizer.overrideDefaultPartitionId(reqV4.getPartitionId());
        if (req.hasQuery()) {
            reqV4.setQuery(QueryV4Normalizer.normalizeQuery(contextNormalizer, req.getQuery()));
        }
        if (req.hasGqlQuery()) {
            reqV4.setGqlQuery(QueryV4Normalizer.normalizeGqlQuery(contextNormalizer, req.getGqlQuery()));
        }
        reqV4.setSuggestedBatchSize(Integer.MAX_VALUE);
        if (req.hasReadOptions()) {
            reqV4.setReadOptions(req.getReadOptions());
        }
        return reqV4.build();
    }

    private static void normalizeQueryFilter(EntityV4Normalizer contextNormalizer, DatastoreV4.Filter.Builder filter) {
        if (filter.hasCompositeFilter()) {
            for (DatastoreV4.Filter.Builder subFilter : filter.getCompositeFilterBuilder().getFilterBuilderList()) {
                QueryV4Normalizer.normalizeQueryFilter(contextNormalizer, subFilter);
            }
        }
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilter.Builder propertyFilter = filter.getPropertyFilterBuilder();
            propertyFilter.setValue(contextNormalizer.normalizeValue(propertyFilter.getValue()));
        }
    }

    private static DatastoreV4.Query normalizeQuery(EntityV4Normalizer contextNormalizer, DatastoreV4.Query query) {
        if (!query.hasFilter()) {
            return query;
        }
        DatastoreV4.Query.Builder normQuery = query.toBuilder();
        QueryV4Normalizer.normalizeQueryFilter(contextNormalizer, normQuery.getFilterBuilder());
        return normQuery.build();
    }

    private static void normalizeGqlQueryArg(EntityV4Normalizer contextNormalizer, DatastoreV4.GqlQueryArg.Builder gqlQueryArg) {
        if (gqlQueryArg.hasValue()) {
            gqlQueryArg.setValue(contextNormalizer.normalizeValue(gqlQueryArg.getValue()));
        }
    }

    private static DatastoreV4.GqlQuery normalizeGqlQuery(EntityV4Normalizer contextNormalizer, DatastoreV4.GqlQuery gqlQuery) {
        if (gqlQuery.getNameArgCount() == 0 && gqlQuery.getNumberArgCount() == 0) {
            return gqlQuery;
        }
        DatastoreV4.GqlQuery.Builder normGqlQuery = gqlQuery.toBuilder();
        for (DatastoreV4.GqlQueryArg.Builder nameArg : normGqlQuery.getNameArgBuilderList()) {
            QueryV4Normalizer.normalizeGqlQueryArg(contextNormalizer, nameArg);
        }
        for (DatastoreV4.GqlQueryArg.Builder numberArg : normGqlQuery.getNumberArgBuilderList()) {
            QueryV4Normalizer.normalizeGqlQueryArg(contextNormalizer, numberArg);
        }
        return normGqlQuery.build();
    }
}

