/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.Wrapper;
import com.google.protos.cloud.sql.Client;
import java.sql.SQLException;
import java.util.List;

public final class ResultSetMetaData
extends Wrapper
implements java.sql.ResultSetMetaData {
    private final List<Client.ColumnProto> columns;
    private final String defaultCatalogName;

    ResultSetMetaData(List<Client.ColumnProto> columns, String defaultCatalogName) {
        this.columns = columns;
        this.defaultCatalogName = defaultCatalogName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        String columnName = this.getColumn(column).getCatalogName();
        return !Util.isEmpty(columnName) ? columnName : this.defaultCatalogName;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        JdbcType dataType = JdbcType.fromCode(this.getColumn(column).getType());
        return dataType.getColumnClass().getName();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumn(column).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int columnNumber) throws SQLException {
        Client.ColumnProto column = this.getColumn(columnNumber);
        return !Util.isEmpty(column.getLabel()) ? column.getLabel() : column.getName();
    }

    @Override
    public String getColumnName(int columnNumber) throws SQLException {
        Client.ColumnProto column = this.getColumn(columnNumber);
        return !Util.isEmpty(column.getName()) ? column.getName() : column.getLabel();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumn(column).getType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn(column).getColumnTypeName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getColumn(column).getSchemaName();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumn(column).getTableName();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getColumn(column).getAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumn(column).getCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getColumn(column).getCurrency();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.getColumn(column).getDefinitelyWritable();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (!this.getColumn(column).hasNullable()) {
            return 2;
        }
        return this.getColumn(column).getNullable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.getColumn(column).getReadOnly();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getColumn(column).getSearchable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumn(column).getSigned();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.getColumn(column).getWritable();
    }

    private Client.ColumnProto getColumn(int column) throws SQLException {
        try {
            return this.columns.get(column - 1);
        }
        catch (IndexOutOfBoundsException e) {
            int n = column;
            throw new SQLException(new StringBuilder(46).append("column ").append(n).append(" does not exist in resultset").toString(), e);
        }
    }
}

