/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Service;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;

public final class Session {
    private static final Class[] PARAM_TYPES = new Class[]{Session.class, URLName.class};
    private static final WeakHashMap addressMapsByClassLoader = new WeakHashMap();
    private static Session DEFAULT_SESSION;
    private Map passwordAuthentications = new HashMap();
    private final Properties properties;
    private final Authenticator authenticator;
    private boolean debug;
    private PrintStream debugOut = System.out;
    private static final WeakHashMap providersByClassLoader;

    private Session(Properties properties, Authenticator authenticator) {
        this.properties = properties;
        this.authenticator = authenticator;
        this.debug = Boolean.valueOf(properties.getProperty("mail.debug"));
    }

    public static Session getInstance(Properties properties, Authenticator authenticator) {
        return new Session(new Properties(properties), authenticator);
    }

    public static Session getInstance(Properties properties) {
        return Session.getInstance(properties, null);
    }

    public static synchronized Session getDefaultInstance(Properties properties) {
        return Session.getDefaultInstance(properties, null);
    }

    public static synchronized Session getDefaultInstance(Properties properties, Authenticator authenticator) {
        if (DEFAULT_SESSION == null) {
            DEFAULT_SESSION = Session.getInstance(properties, authenticator);
        } else if (authenticator != Session.DEFAULT_SESSION.authenticator && (authenticator == null || Session.DEFAULT_SESSION.authenticator == null || authenticator.getClass().getClassLoader() != Session.DEFAULT_SESSION.authenticator.getClass().getClassLoader())) {
            throw new SecurityException();
        }
        return DEFAULT_SESSION;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebugOut(PrintStream out) {
        this.debugOut = out == null ? System.out : out;
    }

    public PrintStream getDebugOut() {
        return this.debugOut;
    }

    public Provider[] getProviders() {
        ProviderInfo info = this.getProviderInfo();
        return info.all.toArray(new Provider[info.all.size()]);
    }

    public Provider getProvider(String protocol) throws NoSuchProviderException {
        ProviderInfo info = this.getProviderInfo();
        Provider provider = null;
        String string = String.valueOf(String.valueOf(protocol));
        String providerName = this.properties.getProperty(new StringBuilder(11 + string.length()).append("mail.").append(string).append(".class").toString());
        if (providerName != null) {
            provider = (Provider)info.byClassName.get(providerName);
            if (this.debug) {
                String string2 = String.valueOf(provider.toString());
                this.writeDebug(string2.length() != 0 ? "DEBUG: new provider loaded: ".concat(string2) : new String("DEBUG: new provider loaded: "));
            }
        }
        if (provider == null) {
            provider = (Provider)info.byProtocol.get(protocol);
        }
        if (provider == null) {
            String string3 = String.valueOf(protocol);
            throw new NoSuchProviderException(string3.length() != 0 ? "Unable to locate provider for protocol: ".concat(string3) : new String("Unable to locate provider for protocol: "));
        }
        if (this.debug) {
            String string4 = String.valueOf(provider.toString());
            this.writeDebug(string4.length() != 0 ? "DEBUG: getProvider() returning provider ".concat(string4) : new String("DEBUG: getProvider() returning provider "));
        }
        return provider;
    }

    public void setProvider(Provider provider) throws NoSuchProviderException {
        ProviderInfo info = this.getProviderInfo();
        info.byProtocol.put(provider.getProtocol(), provider);
    }

    public Store getStore() throws NoSuchProviderException {
        String protocol = this.properties.getProperty("mail.store.protocol");
        if (protocol == null) {
            throw new NoSuchProviderException("mail.store.protocol property is not set");
        }
        return this.getStore(protocol);
    }

    public Store getStore(String protocol) throws NoSuchProviderException {
        Provider provider = this.getProvider(protocol);
        return this.getStore(provider);
    }

    public Store getStore(URLName url) throws NoSuchProviderException {
        return (Store)this.getService(this.getProvider(url.getProtocol()), url);
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        if (Provider.Type.STORE != provider.getType()) {
            String string = String.valueOf(String.valueOf(provider));
            throw new NoSuchProviderException(new StringBuilder(22 + string.length()).append("Not a Store Provider: ").append(string).toString());
        }
        return (Store)this.getService(provider, null);
    }

    public Folder getFolder(URLName name) throws MessagingException {
        Store store = this.getStore(name);
        return store.getFolder(name);
    }

    public Transport getTransport() throws NoSuchProviderException {
        String protocol = this.properties.getProperty("mail.transport.protocol");
        if (protocol == null) {
            throw new NoSuchProviderException("mail.transport.protocol property is not set");
        }
        return this.getTransport(protocol);
    }

    public Transport getTransport(String protocol) throws NoSuchProviderException {
        Provider provider = this.getProvider(protocol);
        return this.getTransport(provider);
    }

    public Transport getTransport(URLName name) throws NoSuchProviderException {
        return (Transport)this.getService(this.getProvider(name.getProtocol()), name);
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String type = address.getType();
        Map addressMap = this.getAddressMap();
        String protocolName = (String)addressMap.get(type);
        if (protocolName == null) {
            String string = String.valueOf(type);
            throw new NoSuchProviderException(string.length() != 0 ? "No provider for address type ".concat(string) : new String("No provider for address type "));
        }
        return this.getTransport(protocolName);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return (Transport)this.getService(provider, null);
    }

    public void setPasswordAuthentication(URLName name, PasswordAuthentication authenticator) {
        if (authenticator == null) {
            this.passwordAuthentications.remove(name);
        } else {
            this.passwordAuthentications.put(name, authenticator);
        }
    }

    public PasswordAuthentication getPasswordAuthentication(URLName name) {
        return (PasswordAuthentication)this.passwordAuthentications.get(name);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress host, int port, String protocol, String prompt, String defaultUserName) {
        if (this.authenticator == null) {
            return null;
        }
        return this.authenticator.authenticate(host, port, protocol, prompt, defaultUserName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String property) {
        return this.getProperties().getProperty(property);
    }

    public synchronized void addProvider(Provider provider) {
        ProviderInfo info = this.getProviderInfo();
        info.addProvider(provider);
    }

    public void setProtocolForAddress(String addressType, String protocol) {
        Map addressMap = this.getAddressMap();
        if (protocol == null) {
            addressMap.remove(addressType);
        } else {
            addressMap.put(addressType, protocol);
        }
    }

    private Service getService(Provider provider, URLName name) throws NoSuchProviderException {
        try {
            if (name == null) {
                name = new URLName(provider.getProtocol(), null, -1, null, null, null);
            }
            ClassLoader cl = this.getClassLoader();
            Class<?> clazz = cl.loadClass(provider.getClassName());
            Constructor<?> ctr = clazz.getConstructor(PARAM_TYPES);
            return (Service)ctr.newInstance(this, name);
        }
        catch (ClassNotFoundException e) {
            String string = String.valueOf(String.valueOf(provider));
            throw (NoSuchProviderException)new NoSuchProviderException(new StringBuilder(35 + string.length()).append("Unable to load class for provider: ").append(string).toString()).initCause(e);
        }
        catch (NoSuchMethodException e) {
            String string = String.valueOf(String.valueOf(provider));
            throw (NoSuchProviderException)new NoSuchProviderException(new StringBuilder(62 + string.length()).append("Provider class does not have a constructor(Session, URLName): ").append(string).toString()).initCause(e);
        }
        catch (InstantiationException e) {
            String string = String.valueOf(String.valueOf(provider));
            throw (NoSuchProviderException)new NoSuchProviderException(new StringBuilder(38 + string.length()).append("Unable to instantiate provider class: ").append(string).toString()).initCause(e);
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(String.valueOf(provider));
            throw (NoSuchProviderException)new NoSuchProviderException(new StringBuilder(38 + string.length()).append("Unable to instantiate provider class: ").append(string).toString()).initCause(e);
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(String.valueOf(provider));
            throw (NoSuchProviderException)new NoSuchProviderException(new StringBuilder(46 + string.length()).append("Exception from constructor of provider class: ").append(string).toString()).initCause(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo getProviderInfo() {
        ClassLoader cl = this.getClassLoader();
        WeakHashMap weakHashMap = providersByClassLoader;
        synchronized (weakHashMap) {
            ProviderInfo info = (ProviderInfo)providersByClassLoader.get(cl);
            if (info == null) {
                info = this.loadProviders(cl);
            }
            return info;
        }
    }

    private synchronized Map getAddressMap() {
        ClassLoader cl = this.getClassLoader();
        Map addressMap = (Map)addressMapsByClassLoader.get(cl);
        if (addressMap == null) {
            addressMap = Session.loadAddressMap(cl);
        }
        return addressMap;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.authenticator != null ? this.authenticator.getClass().getClassLoader() : this.getClass().getClassLoader();
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo loadProviders(ClassLoader cl) {
        InputStream is;
        URL url;
        Enumeration<URL> e;
        ProviderInfo info = new ProviderInfo();
        try {
            File file = new File(System.getProperty("java.home"), "lib/javamail.providers");
            try (FileInputStream is2 = new FileInputStream(file);){
                this.loadProviders(info, is2);
                if (this.debug) {
                    String string = String.valueOf(file.toString());
                    this.writeDebug(string.length() != 0 ? "Loaded lib/javamail.providers from ".concat(string) : new String("Loaded lib/javamail.providers from "));
                }
            }
        }
        catch (SecurityException e2) {
        }
        catch (IOException e3) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.providers");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                if (this.debug) {
                    String string = String.valueOf(url.toString());
                    this.writeDebug(string.length() != 0 ? "Loading META-INF/javamail.providers from ".concat(string) : new String("Loading META-INF/javamail.providers from "));
                }
                is = url.openStream();
                try {
                    this.loadProviders(info, is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e4) {
        }
        catch (IOException e5) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.default.providers");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                if (this.debug) {
                    String string = String.valueOf(url.toString());
                    this.writeDebug(string.length() != 0 ? "Loading javamail.default.providers from ".concat(string) : new String("Loading javamail.default.providers from "));
                }
                is = url.openStream();
                try {
                    this.loadProviders(info, is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e6) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        providersByClassLoader.put(cl, info);
        return info;
    }

    private void loadProviders(ProviderInfo info, InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            String property;
            if (line.startsWith("#")) continue;
            StringTokenizer tok = new StringTokenizer(line, ";");
            String protocol = null;
            Provider.Type type = null;
            String className = null;
            String vendor = null;
            String version = null;
            while (tok.hasMoreTokens()) {
                property = tok.nextToken();
                int index = property.indexOf(61);
                if (index == -1) continue;
                String key = property.substring(0, index).trim().toLowerCase();
                String value = property.substring(index + 1).trim();
                if (protocol == null && "protocol".equals(key)) {
                    protocol = value;
                    continue;
                }
                if (type == null && "type".equals(key)) {
                    if ("store".equals(value)) {
                        type = Provider.Type.STORE;
                        continue;
                    }
                    if (!"transport".equals(value)) continue;
                    type = Provider.Type.TRANSPORT;
                    continue;
                }
                if (className == null && "class".equals(key)) {
                    className = value;
                    continue;
                }
                if ("vendor".equals(key)) {
                    vendor = value;
                    continue;
                }
                if (!"version".equals(key)) continue;
                version = value;
            }
            if (protocol == null || type == null || className == null) continue;
            if (this.debug) {
                property = String.valueOf(String.valueOf(protocol));
                String string = String.valueOf(String.valueOf(className));
                String string2 = String.valueOf(String.valueOf(vendor));
                String string3 = String.valueOf(String.valueOf(version));
                this.writeDebug(new StringBuilder(68 + property.length() + string.length() + string2.length() + string3.length()).append("DEBUG: loading new provider protocol=").append(property).append(", className=").append(string).append(", vendor=").append(string2).append(", version=").append(string3).toString());
            }
            Provider provider = new Provider(type, protocol, className, vendor, version);
            info.addProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadAddressMap(ClassLoader cl) {
        InputStream is;
        URL url;
        Enumeration<URL> e;
        Properties addressMap = new Properties();
        addressMapsByClassLoader.put(cl, addressMap);
        try {
            e = cl.getResources("META-INF/javamail.default.address.map");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                is = url.openStream();
                try {
                    addressMap.load(is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e2) {
        }
        catch (IOException e3) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.address.map");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                is = url.openStream();
                try {
                    addressMap.load(is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e4) {
        }
        catch (IOException e5) {
            // empty catch block
        }
        try {
            File file = new File(System.getProperty("java.home"), "lib/javamail.address.map");
            try (FileInputStream is2 = new FileInputStream(file);){
                addressMap.load(is2);
            }
        }
        catch (SecurityException e6) {
        }
        catch (IOException e7) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.address.map");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                is = url.openStream();
                try {
                    addressMap.load(is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e8) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (addressMap.isEmpty()) {
            addressMap.put("rfc822", "smtp");
        }
        return addressMap;
    }

    private void writeDebug(String msg) {
        this.debugOut.println(msg);
    }

    static {
        providersByClassLoader = new WeakHashMap();
    }

    private static class ProviderInfo {
        private final Map byClassName = new HashMap();
        private final Map byProtocol = new HashMap();
        private final List all = new ArrayList();

        private ProviderInfo() {
        }

        public void addProvider(Provider provider) {
            String protocol;
            String className = provider.getClassName();
            if (!this.byClassName.containsKey(className)) {
                this.byClassName.put(className, provider);
            }
            if (!this.byProtocol.containsKey(protocol = provider.getProtocol())) {
                this.byProtocol.put(protocol, provider);
            }
            this.all.add(provider);
        }
    }
}

