/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.auth.UserContainer;
import com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class AuthUtils {
    private static final Logger logger = Logger.getLogger(AuthUtils.class.getName());
    @VisibleForTesting
    protected static final List<String> SKIP_CLIENT_ID_CHECK_LIST = ImmutableList.of((Object)"*");
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_PEER_AUTHORIZATION = "Peer-Authorization";
    public static final String ATTR_AUTHENTICATED_ENDPOINTS_USER = "Authenticated-Endpoints-User";
    @VisibleForTesting
    static final String[] ALLOWED_AUTH_SCHEMES = new String[]{"Bearer", "OAuth"};
    @VisibleForTesting
    static final String[] BEARER_TOKEN_PARAMETER_NAMES = new String[]{"access_token", "bearer_token"};
    @VisibleForTesting
    static final String[] OAUTH2_TOKEN_PREFIXES = new String[]{"ya29.", "1/"};
    private static HttpTransport transport;
    private static JsonFactory jsonFactory;

    @VisibleForTesting
    static String getAuthToken(HttpServletRequest request) {
        String token = AuthUtils.getAuthTokenFromHeader(request.getHeader(HEADER_AUTHORIZATION));
        if (token == null) {
            token = AuthUtils.getAuthTokenFromQueryParameters(request);
        }
        return token;
    }

    private static String getAuthTokenFromQueryParameters(HttpServletRequest request) {
        for (String parameterName : BEARER_TOKEN_PARAMETER_NAMES) {
            String token = request.getParameter(parameterName);
            if (token == null) continue;
            return token;
        }
        return null;
    }

    private static String getAuthTokenFromHeader(String authHeader) {
        String authScheme = AuthUtils.matchAuthScheme(authHeader);
        if (authScheme == null) {
            return null;
        }
        return authHeader.substring(authScheme.length() + 1);
    }

    @VisibleForTesting
    static String matchAuthScheme(String authHeader) {
        if (authHeader == null) {
            return null;
        }
        for (String authScheme : ALLOWED_AUTH_SCHEMES) {
            if (!authHeader.startsWith(authScheme)) continue;
            return authScheme;
        }
        return null;
    }

    public static synchronized HttpTransport getHttpTransport() {
        if (transport == null) {
            transport = EnvUtil.isRunningOnAppEngineProd() ? new UrlFetchTransport() : new NetHttpTransport();
        }
        return transport;
    }

    public static synchronized JsonFactory getJsonFactory() {
        if (jsonFactory == null) {
            jsonFactory = new JacksonFactory();
        }
        return jsonFactory;
    }

    @VisibleForTesting
    static boolean isIdToken(String token) {
        if (token == null) {
            return false;
        }
        String strippedToken = token.trim().replaceFirst("^['\"]", "");
        for (String prefix : OAUTH2_TOKEN_PREFIXES) {
            if (!strippedToken.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrWhitespace(String string) {
        return string == null || string.trim().isEmpty();
    }

    @VisibleForTesting
    static boolean isClientIdAllowed(boolean clientIdWhitelistEnabled, String clientId, List<String> allowedClientIds, boolean allowSkipClientIdCheck) {
        if (!clientIdWhitelistEnabled) {
            logger.info("Client allowed because the whitelist is disabled");
            return true;
        }
        if (allowedClientIds == null || allowedClientIds.size() == 0) {
            return false;
        }
        if (allowSkipClientIdCheck && allowedClientIds.equals(SKIP_CLIENT_ID_CHECK_LIST)) {
            return true;
        }
        return !AuthUtils.isEmptyOrWhitespace(clientId) && allowedClientIds.contains(clientId);
    }

    public static String getPeerAuthorizationToken(HttpServletRequest request) {
        return request.getHeader(HEADER_PEER_AUTHORIZATION);
    }

    public static synchronized void setAuthenticatedUser(HttpServletRequest request, UserContainer user) {
        request.setAttribute(ATTR_AUTHENTICATED_ENDPOINTS_USER, (Object)user);
    }

    public static synchronized void clearAuthenticatedUser(HttpServletRequest request) {
        request.removeAttribute(ATTR_AUTHENTICATED_ENDPOINTS_USER);
    }

    public static synchronized UserContainer getAuthenticatedUser(HttpServletRequest request) {
        return (UserContainer)request.getAttribute(ATTR_AUTHENTICATED_ENDPOINTS_USER);
    }
}

