/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.server.spi.auth.AuthUtils;
import com.google.api.server.spi.auth.common.User;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GoogleIdTokenUtils {
    private static final Logger logger = Logger.getLogger(GoogleIdTokenUtils.class.getName());
    private static final GoogleIdTokenUtils DEFAULT = new GoogleIdTokenUtils();
    private final GoogleIdTokenVerifier verifier;

    private GoogleIdTokenUtils() {
        this(new GoogleIdTokenVerifier.Builder(AuthUtils.getHttpTransport(), AuthUtils.getJsonFactory()).build());
    }

    private GoogleIdTokenUtils(GoogleIdTokenVerifier verifier) {
        this.verifier = verifier;
    }

    static GoogleIdTokenUtils getInstance() {
        return DEFAULT;
    }

    @VisibleForTesting
    static GoogleIdTokenUtils getInstance(GoogleIdTokenVerifier verifier) {
        return new GoogleIdTokenUtils(verifier);
    }

    @VisibleForTesting
    static String extractAudience(GoogleIdToken idToken) {
        return (String)idToken.getPayload().getAudience();
    }

    @VisibleForTesting
    static String extractClientId(GoogleIdToken idToken) {
        return idToken.getPayload().getAuthorizedParty();
    }

    @VisibleForTesting
    static String extractEmail(GoogleIdToken idToken) {
        return idToken.getPayload().getEmail();
    }

    @VisibleForTesting
    GoogleIdToken verifyToken(String token) {
        if (token == null) {
            return null;
        }
        try {
            return this.verifier.verify(token);
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            String string = String.valueOf(e.getMessage());
            logger.warning(string.length() != 0 ? "verifyToken: ".concat(string) : new String("verifyToken: "));
            return null;
        }
    }

    private static boolean isClientIdAllowed(boolean clientIdWhitelistEnabled, List<String> allowedClientIds, GoogleIdToken idToken) {
        return AuthUtils.isClientIdAllowed(clientIdWhitelistEnabled, GoogleIdTokenUtils.extractClientId(idToken), allowedClientIds, false);
    }

    private static boolean isAudienceAllowed(List<String> allowedAudiences, GoogleIdToken idToken) {
        String audience = GoogleIdTokenUtils.extractAudience(idToken);
        if (AuthUtils.isEmptyOrWhitespace(audience)) {
            String string = String.valueOf(String.valueOf(idToken.getPayload()));
            logger.warning(new StringBuilder(29 + string.length()).append("Token contained no audience: ").append(string).toString());
            return false;
        }
        if (allowedAudiences != null && allowedAudiences.size() != 0) {
            for (String allowedAudience : allowedAudiences) {
                if (!audience.equals(allowedAudience)) continue;
                return true;
            }
        }
        if (audience.equals(GoogleIdTokenUtils.extractClientId(idToken))) {
            return true;
        }
        String string = String.valueOf(audience);
        logger.warning(string.length() != 0 ? "Audience in token was not allowed: ".concat(string) : new String("Audience in token was not allowed: "));
        return false;
    }

    User getCurrentUser(boolean clientIdWhitelistEnabled, String token, List<String> allowedClientIds, List<String> allowedAudiences) {
        GoogleIdToken idToken = this.verifyToken(token);
        if (idToken == null) {
            logger.warning("getCurrentUser: idToken=null");
            return null;
        }
        if (!GoogleIdTokenUtils.isClientIdAllowed(clientIdWhitelistEnabled, allowedClientIds, idToken) || !GoogleIdTokenUtils.isAudienceAllowed(allowedAudiences, idToken)) {
            return null;
        }
        String email = GoogleIdTokenUtils.extractEmail(idToken);
        logger.log(Level.INFO, "getCurrentUser: IdToken; email={0}", email);
        return email == null ? null : new User(email);
    }
}

