/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.scope;

import com.google.api.server.spi.config.scope.AbstractAuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.api.server.spi.config.scope.ConjunctAuthScopeExpression;
import com.google.api.server.spi.config.scope.DisjunctAuthScopeExpression;
import com.google.api.server.spi.config.scope.SingleAuthScopeExpression;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AuthScopeExpressions {
    static final Joiner CONJUNCT_SCOPE_JOINER = Joiner.on((String)" ");
    private static final Splitter CONJUNCT_SCOPE_SPLITTER = Splitter.on((String)" ").omitEmptyStrings();

    private AuthScopeExpressions() {
    }

    public static AuthScopeExpression interpret(String ... scopes) {
        return AuthScopeExpressions.interpret(Arrays.asList(scopes));
    }

    public static AuthScopeExpression interpret(List<String> scopes) {
        ArrayList innerAuthScopeExpressions = Lists.newArrayList();
        for (String scope : scopes) {
            AbstractAuthScopeExpression innerAuthScopeExpression = AuthScopeExpressions.interpretConjunct(scope);
            if (innerAuthScopeExpressions.contains(innerAuthScopeExpression)) continue;
            innerAuthScopeExpressions.add(innerAuthScopeExpression);
        }
        if (innerAuthScopeExpressions.size() == 1) {
            return (AuthScopeExpression)innerAuthScopeExpressions.get(0);
        }
        return new DisjunctAuthScopeExpression(innerAuthScopeExpressions);
    }

    public static List<String> encode(AuthScopeExpression authScopeExpression) {
        try {
            return ((AbstractAuthScopeExpression)authScopeExpression).encode();
        }
        catch (ClassCastException e) {
            String string = String.valueOf(String.valueOf(authScopeExpression.getClass()));
            throw new IllegalArgumentException(new StringBuilder(39 + string.length()).append("Expressions of type ").append(string).append(" are not supported.").toString());
        }
    }

    private static AbstractAuthScopeExpression interpretConjunct(String conjunctScopeExpression) {
        List scopes = CONJUNCT_SCOPE_SPLITTER.splitToList((CharSequence)conjunctScopeExpression);
        if (scopes.size() == 1) {
            return new SingleAuthScopeExpression((String)scopes.get(0));
        }
        ArrayList innerAuthScopeExpressions = Lists.newArrayList();
        for (String scope : scopes) {
            SingleAuthScopeExpression innerAuthScopeExpression = new SingleAuthScopeExpression(scope);
            if (innerAuthScopeExpressions.contains(innerAuthScopeExpression)) continue;
            innerAuthScopeExpressions.add(innerAuthScopeExpression);
        }
        return new ConjunctAuthScopeExpression(innerAuthScopeExpressions);
    }
}

