/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.guice;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.inject.Binder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;

public class ServiceMap {
    private final Map<Class<?>, Provider<?>> services;

    public static ServiceMap create(Binder binder, Iterable<Class<?>> classes) {
        HashMap services = new HashMap();
        for (Class<?> clazz : classes) {
            com.google.inject.Provider object = binder.getProvider(clazz);
            if (object == null) continue;
            services.put(clazz, (Provider<?>)object);
        }
        return new ServiceMap(services);
    }

    private ServiceMap(Map<Class<?>, Provider<?>> services) {
        this.services = (Map)Preconditions.checkNotNull(services, (Object)"services");
    }

    public <T> T get(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        String string = String.valueOf(String.valueOf(clazz));
        Provider provider = (Provider)Preconditions.checkNotNull(this.services.get(clazz), (Object)new StringBuilder(12 + string.length()).append("provider of ").append(string).toString());
        return (T)provider.get();
    }

    Iterable<Class<?>> getClasses() {
        return this.services.keySet();
    }

    Collection<Object> getServices() {
        return new ArrayList<Object>(){
            {
                for (Provider provider : ServiceMap.this.services.values()) {
                    this.add(provider.get());
                }
            }
        };
    }
}

