/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.mapping;

import com.google.appengine.datanucleus.mapping.DatastoreTable;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

class DatastoreProperty
implements DatastoreField {
    private DatastoreIdentifier identifier;
    private ColumnMetaData columnMetaData;
    private final DatastoreTable table;
    private DatastoreMapping datastoreMapping = null;
    private final String storedJavaType;
    private final MappedStoreManager storeMgr;
    private boolean isPrimaryKey;
    private boolean isNullable;
    private AbstractMemberMetaData ammd;

    public DatastoreProperty(DatastoreTable table, String javaType, DatastoreIdentifier identifier, ColumnMetaData colmd) {
        this.table = table;
        this.storedJavaType = javaType;
        this.storeMgr = table.getStoreManager();
        this.setIdentifier(identifier);
        this.columnMetaData = colmd == null ? new ColumnMetaData() : colmd;
        boolean bl = this.isNullable = !Boolean.FALSE.equals(this.columnMetaData.getAllowsNull());
        if (this.columnMetaData.getUnique()) {
            throw new UnsupportedOperationException("No support for uniqueness constraints");
        }
    }

    public String getStoredJavaType() {
        return this.storedJavaType;
    }

    public void setAsPrimaryKey() {
        this.isPrimaryKey = true;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public DatastoreMapping getDatastoreMapping() {
        return this.datastoreMapping;
    }

    public void setDatastoreMapping(DatastoreMapping mapping) {
        this.datastoreMapping = mapping;
    }

    public DatastoreTable getDatastoreContainerObject() {
        return this.table;
    }

    public String applySelectFunction(String replacementValue) {
        throw new UnsupportedOperationException("Select function not supported");
    }

    public void copyConfigurationTo(DatastoreField field) {
        DatastoreProperty prop = (DatastoreProperty)field;
        prop.isPrimaryKey = this.isPrimaryKey;
    }

    public DatastoreField setNullable() {
        return this;
    }

    public DatastoreField setDefaultable() {
        throw new UnsupportedOperationException("Default values not supported");
    }

    public void setIdentifier(DatastoreIdentifier identifier) {
        this.identifier = identifier;
    }

    public MappedStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public DatastoreIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isDefaultable() {
        return false;
    }

    public DatastoreField setUnique() {
        return this;
    }

    public boolean isUnique() {
        return false;
    }

    public DatastoreField setIdentity(boolean b) {
        this.isPrimaryKey = b;
        return this;
    }

    public boolean isIdentity() {
        return this.isPrimaryKey();
    }

    public void setDefaultValue(Object o) {
        throw new UnsupportedOperationException("Default values not supported.");
    }

    public Object getDefaultValue() {
        return null;
    }

    public void setColumnMetaData(ColumnMetaData columnMetaData) {
        this.columnMetaData = columnMetaData;
    }

    public ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public JavaTypeMapping getJavaTypeMapping() {
        return this.datastoreMapping.getJavaTypeMapping();
    }

    public AbstractMemberMetaData getMemberMetaData() {
        if (this.ammd != null) {
            return this.ammd;
        }
        if (this.columnMetaData != null && this.columnMetaData.getParent() instanceof AbstractMemberMetaData) {
            return (AbstractMemberMetaData)this.columnMetaData.getParent();
        }
        return null;
    }

    void setMemberMetaData(AbstractMemberMetaData ammd) {
        this.ammd = ammd;
    }
}

