/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.mapping;

import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreFKMapping;
import com.google.appengine.datanucleus.mapping.DatastoreProperty;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.store.exceptions.NoSuchPersistentFieldException;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.DuplicateDatastoreFieldException;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorLongMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorStringMapping;
import org.datanucleus.store.mapped.mapping.IndexMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DatastoreTable
implements DatastoreClass {
    private static final MultiMap callbacks = new MultiMap();
    private final DatastoreManager storeMgr;
    private final AbstractClassMetaData cmd;
    private final ClassLoaderResolver clr;
    private final DatastoreAdapter dba;
    private final DatastoreIdentifier identifier;
    private final Map<AbstractMemberMetaData, JavaTypeMapping> fieldMappingsMap = new LinkedHashMap<AbstractMemberMetaData, JavaTypeMapping>();
    private final Map<AbstractMemberMetaData, JavaTypeMapping> embeddedFieldMappingsMap = new LinkedHashMap<AbstractMemberMetaData, JavaTypeMapping>();
    private final List<DatastoreProperty> datastoreProperties = Utils.newArrayList(new Object[0]);
    protected Map<String, DatastoreProperty> datastorePropertiesByName = Utils.newHashMap();
    private JavaTypeMapping datastoreIDMapping;
    private JavaTypeMapping[] pkMappings;
    private JavaTypeMapping idMapping;
    protected DiscriminatorMetaData discriminatorMetaData;
    private JavaTypeMapping discriminatorMapping;
    private int highestFieldNumber = 0;
    private final Map<AbstractMemberMetaData, JavaTypeMapping> externalFkMappings = Utils.newHashMap();
    private final Map<AbstractMemberMetaData, JavaTypeMapping> externalOrderMappings = Utils.newHashMap();
    private AbstractMemberMetaData parentMappingMemberMetaData;
    private final Collection<AbstractClassMetaData> managedClassMetaData = new HashSet<AbstractClassMetaData>();

    public DatastoreTable(String kind, DatastoreManager storeMgr, AbstractClassMetaData cmd, ClassLoaderResolver clr, DatastoreAdapter dba) {
        this.storeMgr = storeMgr;
        this.cmd = cmd;
        this.clr = clr;
        this.dba = dba;
        this.identifier = new DatastoreKind(kind);
    }

    public String getType() {
        return this.cmd.getFullClassName();
    }

    public IdentityType getIdentityType() {
        return this.cmd.getIdentityType();
    }

    public boolean isObjectIdDatastoreAttributed() {
        return true;
    }

    public boolean isBaseDatastoreClass() {
        return true;
    }

    public DatastoreClass getBaseDatastoreClass() {
        return this;
    }

    public DatastoreClass getBaseDatastoreClassWithMember(AbstractMemberMetaData fmd) {
        if (this.fieldMappingsMap.get(fmd) != null) {
            return this;
        }
        return null;
    }

    public DatastoreClass getSuperDatastoreClass() {
        return null;
    }

    public Collection getSecondaryDatastoreClasses() {
        return null;
    }

    public boolean managesClass(String className) {
        return this.cmd.getFullClassName().equals(className);
    }

    public JavaTypeMapping getDatastoreObjectIdMapping() {
        return this.datastoreIDMapping;
    }

    public JavaTypeMapping getMemberMapping(String fieldName) {
        AbstractMemberMetaData fmd = this.getFieldMetaData(fieldName);
        JavaTypeMapping m = this.getMemberMapping(fmd);
        if (m == null) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), fieldName);
        }
        return m;
    }

    private AbstractMemberMetaData getFieldMetaData(String fieldName) {
        return this.cmd.getMetaDataForMember(fieldName);
    }

    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return null;
        }
        return this.fieldMappingsMap.get(mmd);
    }

    public JavaTypeMapping getMemberMappingInDatastoreClass(AbstractMemberMetaData mmd) {
        return this.getMemberMapping(mmd);
    }

    public DatastoreProperty addDatastoreField(String storedJavaType, DatastoreIdentifier name, JavaTypeMapping mapping, ColumnMetaData colmd) {
        DatastoreProperty prop = new DatastoreProperty(this, mapping.getJavaType().getName(), name, colmd);
        if (this.hasColumnName(name)) {
            if (colmd == null || !(colmd instanceof ColumnMetaData)) {
                throw new NucleusException("invalid column meta data property name on class " + this.getType() + " : " + colmd);
            }
            if ((colmd.getInsertable() || colmd.getUpdateable()) && !this.isSuperclassColumn(prop, mapping, (MetaData)colmd)) {
                throw new NucleusException("Duplicate property name on class " + this.getType() + " : " + name);
            }
        }
        DatastoreIdentifier colName = prop.getIdentifier();
        this.datastoreProperties.add(prop);
        this.datastorePropertiesByName.put(colName.getIdentifierName(), prop);
        return prop;
    }

    protected boolean hasColumnName(DatastoreIdentifier colName) {
        return this.getDatastoreField(colName) != null;
    }

    public boolean hasDatastoreField(DatastoreIdentifier identifier) {
        return this.hasColumnName(identifier);
    }

    public boolean isSuperclassColumn(DatastoreField col, JavaTypeMapping mapping, MetaData colmd) {
        DatastoreIdentifier name = col.getIdentifier();
        DatastoreField existingCol = this.getDatastoreField(name);
        MetaData md = existingCol.getColumnMetaData().getParent();
        while (!(md instanceof AbstractClassMetaData)) {
            if (md == null) {
                throw new NucleusUserException(MessageFormat.format("The property \"{0}\" exists in entity \"{1}\" and has invalid metadata. The existing property is \"{2}\"", name, this.identifier, colmd.toString()));
            }
            md = md.getParent();
        }
        MetaData dupMd = colmd.getParent();
        while (!(dupMd instanceof AbstractClassMetaData)) {
            if ((dupMd = dupMd.getParent()) != null) continue;
            throw new NucleusUserException(MessageFormat.format("The column \"{0}\" exists in table \"{1}\" and cannot be validated because a duplicated column has been specified and the metadata is invalid. The column is \"{2}\"", name, this.identifier, colmd.toString()));
        }
        if (((AbstractClassMetaData)md).getFullClassName().equals(((AbstractClassMetaData)dupMd).getFullClassName())) {
            throw new DuplicateDatastoreFieldException(this.toString(), existingCol, col);
        }
        if (mapping != null && !mapping.getClass().isAssignableFrom(existingCol.getJavaTypeMapping().getClass()) && !existingCol.getJavaTypeMapping().getClass().isAssignableFrom(mapping.getClass())) {
            throw new DuplicateDatastoreFieldException(this.toString(), existingCol, col);
        }
        Class fieldStoredJavaTypeClass = null;
        Class existingColStoredJavaTypeClass = null;
        try {
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            fieldStoredJavaTypeClass = clr.classForName(col.getStoredJavaType());
            existingColStoredJavaTypeClass = clr.classForName(col.getStoredJavaType());
        }
        catch (RuntimeException cnfe) {
            // empty catch block
        }
        if (fieldStoredJavaTypeClass != null && existingColStoredJavaTypeClass != null && !fieldStoredJavaTypeClass.isAssignableFrom(existingColStoredJavaTypeClass) && !existingColStoredJavaTypeClass.isAssignableFrom(fieldStoredJavaTypeClass)) {
            throw new DuplicateDatastoreFieldException(this.toString(), existingCol, col);
        }
        return true;
    }

    public DatastoreField getDatastoreField(String colName) {
        return this.datastorePropertiesByName.get(colName);
    }

    public DatastoreField getDatastoreField(DatastoreIdentifier identifier) {
        return this.getDatastoreField(identifier.getIdentifierName());
    }

    public JavaTypeMapping getIdMapping() {
        return this.idMapping;
    }

    public MappedStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public DatastoreIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isSuperDatastoreClass(DatastoreClass datastoreClass) {
        return false;
    }

    public boolean managesMapping(JavaTypeMapping javaTypeMapping) {
        return true;
    }

    public DatastoreField[] getDatastoreFields() {
        return this.datastoreProperties.toArray(new DatastoreField[this.datastoreProperties.size()]);
    }

    public void buildMapping() {
        this.initializePK();
        this.initializeNonPK();
        this.initializeDiscriminatorMapping(this.cmd.getDiscriminatorMetaDataForTable());
        this.runCallBacks();
        this.managedClassMetaData.add(this.cmd);
    }

    public void manageClass(AbstractClassMetaData cmd) {
        if (this.getDiscriminatorMetaData() == null) {
            throw new NucleusUserException("Descriminator meta data for " + cmd.getFullClassName() + " is missing. Please specify at least the discriminator column.");
        }
        for (AbstractMemberMetaData fmd : cmd.getManagedMembers()) {
            this.addFieldMapping(cmd, fmd);
        }
        this.managedClassMetaData.add(cmd);
    }

    public String[] getManagedClasses() {
        List<String> list = Utils.transform(this.managedClassMetaData, new Utils.Function<AbstractClassMetaData, String>(){

            @Override
            public String apply(AbstractClassMetaData cmd) {
                return cmd.getFullClassName();
            }
        });
        return list.toArray(new String[list.size()]);
    }

    private void initializeNonPK() {
        LinkedList<AbstractClassMetaData> cmdl = this.buildClassMetaDataList();
        HashMap<String, AbstractMemberMetaData> overriddenFieldMap = new HashMap<String, AbstractMemberMetaData>();
        for (AbstractClassMetaData curCmd : cmdl) {
            for (AbstractMemberMetaData fmd : curCmd.getOverriddenMembers()) {
                overriddenFieldMap.put(fmd.getFullFieldName(), fmd);
            }
        }
        for (AbstractClassMetaData curCmd : cmdl) {
            for (AbstractMemberMetaData fmd : curCmd.getManagedMembers()) {
                if (overriddenFieldMap.containsKey(fmd.getFullFieldName())) {
                    fmd = (AbstractMemberMetaData)overriddenFieldMap.get(fmd.getFullFieldName());
                }
                this.addFieldMapping(curCmd, fmd);
            }
        }
        Class curClass = this.clr.classForName(this.cmd.getFullClassName()).getSuperclass();
        while (!Object.class.equals(curClass)) {
            DatastoreTable dt = null;
            try {
                dt = this.storeMgr.getDatastoreClass(curClass.getName(), this.clr);
            }
            catch (NoTableManagedException ntme) {
                // empty catch block
            }
            if (dt != null) {
                if (this.parentMappingMemberMetaData == null && dt.parentMappingMemberMetaData != null) {
                    this.parentMappingMemberMetaData = dt.parentMappingMemberMetaData;
                    break;
                }
                if (!dt.externalFkMappings.isEmpty()) {
                    this.externalFkMappings.putAll(dt.externalFkMappings);
                }
            }
            curClass = curClass.getSuperclass();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addFieldMapping(AbstractClassMetaData curCmd, AbstractMemberMetaData fmd) {
        if (fmd.isPrimaryKey()) {
            this.embeddedFieldMappingsMap.put(fmd, this.pkMappings[0]);
            return;
        } else {
            if (this.managesField(fmd.getFullFieldName())) {
                if (fmd.getClassName(true).equals(curCmd.getFullClassName())) return;
                throw new UnsupportedOperationException("Overrides not currently supported.");
            }
            MetaDataManager mmgr = this.storeMgr.getMetaDataManager();
            JavaTypeMapping mapping = null;
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                boolean isPrimary = true;
                if (fmd.getTable() != null && fmd.getJoinMetaData() == null) {
                    isPrimary = false;
                }
                if (!isPrimary) throw new UnsupportedOperationException("No support for secondary tables.");
                mapping = this.dba.getMappingManager((MappedStoreManager)this.storeMgr).getMapping((DatastoreContainerObject)this, fmd, this.clr, 2);
                this.addFieldMapping(mapping);
                this.embeddedFieldMappingsMap.put(fmd, this.fieldMappingsMap.get(fmd));
            } else if (fmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                throw new NucleusException("Invalid persistence-modifier for field ").setFatal();
            }
            boolean needsFKToContainerOwner = false;
            int relationType = fmd.getRelationType(this.clr);
            if (relationType == 4) {
                needsFKToContainerOwner = true;
            } else if (relationType == 3) {
                needsFKToContainerOwner = true;
            } else if (relationType == 2) {
                if (fmd.getMappedBy() != null && MetaDataUtils.isOwnedRelation(fmd, this.storeMgr)) {
                    DatastoreTable dt = this.storeMgr.getDatastoreClass(fmd.getAbstractClassMetaData().getFullClassName(), this.clr);
                    dt.runCallBacks();
                    dt.markFieldAsParentKeyProvider(fmd.getName());
                }
            } else if (relationType == 6) {
                // empty if block
            }
            if (!needsFKToContainerOwner) return;
            if (fmd.getCollection() != null && !SCOUtils.collectionHasSerialisedElements((AbstractMemberMetaData)fmd) || fmd.getArray() != null && !SCOUtils.arrayIsStoredInSingleColumn((AbstractMemberMetaData)fmd, (MetaDataManager)mmgr)) {
                void var8_10;
                AbstractClassMetaData elementCmd = fmd.hasCollection() ? mmgr.getMetaDataForClass(fmd.getCollection().getElementType(), this.clr) : mmgr.getMetaDataForClass(fmd.getType().getComponentType(), this.clr);
                if (elementCmd == null) return;
                if (elementCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    AbstractClassMetaData[] abstractClassMetaDataArray = this.storeMgr.getClassesManagingTableForClass(elementCmd, this.clr);
                } else {
                    ClassMetaData[] classMetaDataArray = new ClassMetaData[]{elementCmd};
                }
                for (void elementCmd1 : var8_10) {
                    callbacks.put((Object)elementCmd1.getFullClassName(), (Object)new CallBack(fmd, this.cmd.getFullClassName()));
                    DatastoreTable dt = this.storeMgr.getDatastoreClass(elementCmd1.getFullClassName(), this.clr);
                    dt.runCallBacks();
                    if (fmd.getMappedBy() == null || !MetaDataUtils.isOwnedRelation(fmd, this.storeMgr)) continue;
                    dt.markFieldAsParentKeyProvider(fmd.getMappedBy());
                }
                return;
            } else {
                AbstractClassMetaData keyCmd;
                if (fmd.getMap() == null || SCOUtils.mapHasSerialisedKeysAndValues((AbstractMemberMetaData)fmd)) return;
                if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
                    AbstractClassMetaData valueCmd = mmgr.getMetaDataForClass(fmd.getMap().getValueType(), this.clr);
                    if (valueCmd != null) return;
                }
                if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() != null && (keyCmd = mmgr.getMetaDataForClass(fmd.getMap().getKeyType(), this.clr)) != null) return;
            }
        }
    }

    private LinkedList<AbstractClassMetaData> buildClassMetaDataList() {
        LinkedList<Object> stack = Utils.newLinkedList(new Object[0]);
        for (AbstractClassMetaData curCmd = this.cmd; curCmd != null; curCmd = curCmd.getSuperAbstractClassMetaData()) {
            stack.addFirst(curCmd);
        }
        return stack;
    }

    private void markFieldAsParentKeyProvider(String mappedBy) {
        AbstractMemberMetaData newParentMappingField = this.getFieldMetaData(mappedBy);
        if (this.parentMappingMemberMetaData == null) {
            this.parentMappingMemberMetaData = newParentMappingField;
        } else if (this.parentMappingMemberMetaData != newParentMappingField) {
            throw new NucleusException("App Engine ORM does not support multiple parent key provider fields : class=" + this.cmd.getFullClassName() + " requested to have member=" + mappedBy + " but already have member=" + this.parentMappingMemberMetaData.getName());
        }
    }

    protected void addFieldMapping(JavaTypeMapping fieldMapping) {
        AbstractMemberMetaData fmd = fieldMapping.getMemberMetaData();
        this.fieldMappingsMap.put(fmd, fieldMapping);
        int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
        if (absoluteFieldNumber > this.highestFieldNumber) {
            this.highestFieldNumber = absoluteFieldNumber;
        }
    }

    public boolean managesField(String fieldName) {
        return fieldName != null && this.getMappingForFullFieldName(fieldName) != null;
    }

    public JavaTypeMapping getMappingForFullFieldName(String fieldName) {
        Set<AbstractMemberMetaData> fields = this.fieldMappingsMap.keySet();
        for (AbstractMemberMetaData field : fields) {
            AbstractMemberMetaData fmd = field;
            if (!fmd.getFullFieldName().equals(fieldName)) continue;
            return this.fieldMappingsMap.get(fmd);
        }
        return null;
    }

    public JavaTypeMapping getMappingForSimpleFieldName(String fieldName) {
        Set<AbstractMemberMetaData> fields = this.fieldMappingsMap.keySet();
        for (AbstractMemberMetaData field : fields) {
            AbstractMemberMetaData fmd = field;
            if (!fmd.getName().equals(fieldName)) continue;
            return this.fieldMappingsMap.get(fmd);
        }
        return null;
    }

    void addDatastoreId(ColumnMetaData columnMetaData, DatastoreClass refTable, AbstractClassMetaData cmd) {
        this.datastoreIDMapping = new OIDMapping();
        this.datastoreIDMapping.initialize((MappedStoreManager)this.storeMgr, cmd.getFullClassName());
        ColumnMetaData colmd = columnMetaData == null ? new ColumnMetaData() : columnMetaData;
        if (colmd.getName() == null) {
            if (refTable != null) {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(refTable.getIdentifier().getIdentifierName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(OID.class), 1).getIdentifierName());
            } else {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(this.identifier.getIdentifierName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(OID.class), 0).getIdentifierName());
            }
        }
        DatastoreProperty idColumn = this.addDatastoreField(OID.class.getName(), this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, colmd.getName()), this.datastoreIDMapping, colmd);
        idColumn.setAsPrimaryKey();
        String strategyName = cmd.getIdentityMetaData().getValueStrategy().toString();
        if (cmd.getIdentityMetaData().getValueStrategy().equals((Object)IdentityStrategy.CUSTOM)) {
            strategyName = cmd.getIdentityMetaData().getValueStrategy().getCustomName();
        }
        Class poidClass = Long.class;
        ConfigurationElement elem = this.storeMgr.getNucleusContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategyName, "true"});
        if (elem == null) {
            elem = this.storeMgr.getNucleusContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeMgr.getStoreManagerKey()});
        }
        if (elem != null) {
            String generatorClassName = elem.getAttribute("class-name");
            Class generatorClass = this.getStoreManager().getNucleusContext().getClassLoaderResolver(null).classForName(generatorClassName);
            try {
                poidClass = (Class)generatorClass.getMethod("getStorageClass", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                NucleusLogger.VALUEGENERATION.warn((Object)("Error retrieving storage class for POID generator " + generatorClassName + " " + e.getMessage()));
            }
        }
        this.dba.getMappingManager((MappedStoreManager)this.storeMgr).createDatastoreMapping(this.datastoreIDMapping, (DatastoreField)idColumn, poidClass.getName());
        if (this.isObjectIdDatastoreAttributed()) {
            // empty if block
        }
    }

    private void initializePK() {
        AbstractMemberMetaData[] fieldsToAdd = new AbstractMemberMetaData[this.cmd.getNoOfPrimaryKeyMembers()];
        int pkFieldNum = 0;
        int fieldCount = this.cmd.getNoOfManagedMembers();
        boolean hasPrimaryKeyInThisClass = false;
        if (this.cmd.getNoOfPrimaryKeyMembers() > 0) {
            this.pkMappings = new JavaTypeMapping[this.cmd.getNoOfPrimaryKeyMembers()];
            if (this.cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                AbstractClassMetaData baseCmd = this.cmd.getBaseAbstractClassMetaData();
                fieldCount = baseCmd.getNoOfManagedMembers();
                for (int relFieldNum = 0; relFieldNum < fieldCount; ++relFieldNum) {
                    AbstractMemberMetaData mmd = baseCmd.getMetaDataForManagedMemberAtPosition(relFieldNum);
                    if (!mmd.isPrimaryKey()) continue;
                    if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                        fieldsToAdd[pkFieldNum++] = mmd;
                        hasPrimaryKeyInThisClass = true;
                        continue;
                    }
                    if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                    throw new NucleusException("Invalid persistence-modifier for field " + mmd.getName()).setFatal();
                }
            } else {
                for (int relFieldNum = 0; relFieldNum < fieldCount; ++relFieldNum) {
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtPosition(relFieldNum);
                    if (!fmd.isPrimaryKey()) continue;
                    if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                        fieldsToAdd[pkFieldNum++] = fmd;
                        hasPrimaryKeyInThisClass = true;
                        continue;
                    }
                    if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                    throw new NucleusException("Invalid persistence-modifier for field" + fmd.getName()).setFatal();
                }
            }
        }
        if (!hasPrimaryKeyInThisClass) {
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
                DatastoreTable elementCT = this.storeMgr.getDatastoreClass(this.cmd.getPersistenceCapableSuperclass(), this.clr);
                if (elementCT != null) {
                    JoinMetaData colContainer = null;
                    if (this.cmd.getInheritanceMetaData() != null) {
                        colContainer = this.cmd.getInheritanceMetaData().getJoinMetaData();
                    }
                    if (colContainer == null) {
                        colContainer = this.cmd.getPrimaryKeyMetaData();
                    }
                    this.addApplicationIdUsingClassTableId((ColumnMetaDataContainer)colContainer, elementCT, this.clr, this.cmd);
                } else {
                    AbstractClassMetaData pkCmd = this.storeMgr.getClassWithPrimaryKeyForClass(this.cmd.getSuperAbstractClassMetaData(), this.clr);
                    if (pkCmd != null) {
                        this.pkMappings = new JavaTypeMapping[pkCmd.getNoOfPrimaryKeyMembers()];
                        pkFieldNum = 0;
                        fieldCount = pkCmd.getNoOfInheritedManagedMembers() + pkCmd.getNoOfManagedMembers();
                        for (int absFieldNum = 0; absFieldNum < fieldCount; ++absFieldNum) {
                            AbstractMemberMetaData fmd = pkCmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNum);
                            if (!fmd.isPrimaryKey()) continue;
                            AbstractMemberMetaData overriddenFmd = this.cmd.getOverriddenMember(fmd.getName());
                            if (overriddenFmd != null) {
                                fmd = overriddenFmd;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                                fieldsToAdd[pkFieldNum++] = fmd;
                                continue;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                            throw new NucleusException("Invalid persistence-modifier for field " + fmd.getName()).setFatal();
                        }
                    }
                }
            } else if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                ColumnMetaData colmd = null;
                if (this.cmd.getIdentityMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData() != null) {
                    colmd = this.cmd.getIdentityMetaData().getColumnMetaData();
                }
                if (colmd == null && this.cmd.getPrimaryKeyMetaData() != null && this.cmd.getPrimaryKeyMetaData().getColumnMetaData() != null && this.cmd.getPrimaryKeyMetaData().getColumnMetaData().length > 0) {
                    colmd = this.cmd.getPrimaryKeyMetaData().getColumnMetaData()[0];
                }
                this.addDatastoreId(colmd, null, this.cmd);
            } else if (this.cmd.getIdentityType() == IdentityType.NONDURABLE) {
                // empty if block
            }
        }
        for (int i = 0; i < fieldsToAdd.length; ++i) {
            if (fieldsToAdd[i] == null) continue;
            try {
                DatastoreClass datastoreClass = this.getStoreManager().getDatastoreClass(fieldsToAdd[i].getType().getName(), this.clr);
                if (datastoreClass.getIdMapping() == null) {
                    throw new NucleusException("Unsupported relationship with field " + fieldsToAdd[i].getFullFieldName()).setFatal();
                }
            }
            catch (NoTableManagedException ex) {
                // empty catch block
            }
            JavaTypeMapping fieldMapping = this.dba.getMappingManager((MappedStoreManager)this.storeMgr).getMapping((DatastoreContainerObject)this, fieldsToAdd[i], this.clr, 2);
            this.addFieldMapping(fieldMapping);
            this.pkMappings[i] = fieldMapping;
        }
        this.initializeIDMapping();
    }

    private void initializeDiscriminatorMapping(DiscriminatorMetaData dismd) {
        if (dismd != null) {
            this.discriminatorMetaData = dismd;
            if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                this.discriminatorMapping = new DiscriminatorStringMapping(this.dba, (DatastoreContainerObject)this, this.dba.getMappingManager((MappedStoreManager)this.storeMgr).getMapping(String.class));
            } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                ColumnMetaData disColmd = dismd.getColumnMetaData();
                this.discriminatorMapping = disColmd != null && disColmd.getJdbcType() != null ? (disColmd.getJdbcType().equalsIgnoreCase("INTEGER") || disColmd.getJdbcType().equalsIgnoreCase("BIGINT") || disColmd.getJdbcType().equalsIgnoreCase("NUMERIC") ? new DiscriminatorLongMapping(this.dba, (DatastoreContainerObject)this, this.dba.getMappingManager((MappedStoreManager)this.storeMgr).getMapping(Long.class)) : new DiscriminatorStringMapping(this.dba, (DatastoreContainerObject)this, this.dba.getMappingManager((MappedStoreManager)this.storeMgr).getMapping(String.class))) : new DiscriminatorStringMapping(this.dba, (DatastoreContainerObject)this, this.dba.getMappingManager((MappedStoreManager)this.storeMgr).getMapping(String.class));
            }
        }
    }

    private void initializeIDMapping() {
        if (this.idMapping != null) {
            return;
        }
        PersistableMapping mapping = new PersistableMapping();
        mapping.initialize(this.getStoreManager(), this.cmd.getFullClassName());
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            mapping.addJavaTypeMapping(this.datastoreIDMapping);
        } else if (this.getIdentityType() == IdentityType.APPLICATION) {
            for (JavaTypeMapping pkMapping : this.pkMappings) {
                mapping.addJavaTypeMapping(pkMapping);
            }
        }
        this.idMapping = mapping;
    }

    final void addApplicationIdUsingClassTableId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, ClassLoaderResolver clr, AbstractClassMetaData cmd) {
        ColumnMetaData[] userdefinedCols = null;
        int nextUserdefinedCol = 0;
        if (columnContainer != null) {
            userdefinedCols = columnContainer.getColumnMetaData();
        }
        this.pkMappings = new JavaTypeMapping[cmd.getPKMemberPositions().length];
        for (int i = 0; i < cmd.getPKMemberPositions().length; ++i) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
            JavaTypeMapping mapping = refTable.getMemberMapping(fmd);
            if (mapping == null) {
                throw new NucleusUserException("Cannot find mapping for field " + fmd.getFullFieldName() + " in table " + refTable.toString() + " " + StringUtils.objectArrayToString((Object[])refTable.getDatastoreFields()));
            }
            JavaTypeMapping masterMapping = this.storeMgr.getMappingManager().getMapping(clr.classForName(mapping.getType()));
            masterMapping.setMemberMetaData(fmd);
            this.pkMappings[i] = masterMapping;
            for (int j = 0; j < mapping.getNumberOfDatastoreMappings(); ++j) {
                JavaTypeMapping m = masterMapping;
                DatastoreField refColumn = mapping.getDatastoreMapping(j).getDatastoreField();
                if (mapping instanceof PersistableMapping) {
                    m = this.storeMgr.getMappingManager().getMapping(clr.classForName(refColumn.getJavaTypeMapping().getType()));
                    ((PersistableMapping)masterMapping).addJavaTypeMapping(m);
                }
                ColumnMetaData userdefinedColumn = null;
                if (userdefinedCols != null) {
                    for (ColumnMetaData userdefinedCol : userdefinedCols) {
                        if (!refColumn.getIdentifier().toString().equals(userdefinedCol.getTarget())) continue;
                        userdefinedColumn = userdefinedCol;
                        break;
                    }
                    if (userdefinedColumn == null && nextUserdefinedCol < userdefinedCols.length) {
                        userdefinedColumn = userdefinedCols[nextUserdefinedCol++];
                    }
                }
                DatastoreProperty idColumn = userdefinedColumn != null ? this.addDatastoreField(refColumn.getStoredJavaType(), this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, userdefinedColumn.getName()), m, refColumn.getColumnMetaData()) : this.addDatastoreField(refColumn.getStoredJavaType(), refColumn.getIdentifier(), m, refColumn.getColumnMetaData());
                if (mapping != null && mapping.getDatastoreMapping(j).getDatastoreField().getColumnMetaData() != null) {
                    refColumn.copyConfigurationTo((DatastoreField)idColumn);
                }
                idColumn.setAsPrimaryKey();
                this.getStoreManager().getMappingManager().createDatastoreMapping(m, (DatastoreField)idColumn, refColumn.getJavaTypeMapping().getType());
            }
            int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
            if (absoluteFieldNumber <= this.highestFieldNumber) continue;
            this.highestFieldNumber = absoluteFieldNumber;
        }
    }

    public void provideDatastoreIdMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            consumer.consumeMapping(this.getDatastoreObjectIdMapping(), 2);
        }
    }

    public void providePrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.pkMappings != null) {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            for (int i = 0; i < this.pkMappings.length; ++i) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.pkMappings[i], fmd);
            }
        } else {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            int countPkFields = this.cmd.getNoOfPrimaryKeyMembers();
            for (int i = 0; i < countPkFields; ++i) {
                AbstractMemberMetaData pkfmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.getMemberMapping(pkfmd), pkfmd);
            }
        }
    }

    public void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
        this.provideNonPrimaryKeyMappings(consumer, false);
    }

    public void provideNonPrimaryKeyMappings(MappingConsumer consumer, boolean isEmbedded) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        Set<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> entries = isEmbedded ? this.embeddedFieldMappingsMap.entrySet() : this.fieldMappingsMap.entrySet();
        for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry : entries) {
            if (entry.getValue() == null || entry.getKey().isPrimaryKey() && !isEmbedded) continue;
            consumer.consumeMapping(entry.getValue(), entry.getKey());
        }
    }

    public void provideMappingsForMembers(MappingConsumer consumer, AbstractMemberMetaData[] mmds, boolean includeSecondaryTables) {
        for (AbstractMemberMetaData aFieldMetaData : mmds) {
            JavaTypeMapping fieldMapping = this.fieldMappingsMap.get(aFieldMetaData);
            if (fieldMapping == null || aFieldMetaData.isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, aFieldMetaData);
        }
    }

    public void provideVersionMappings(MappingConsumer consumer) {
    }

    public void provideDiscriminatorMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getDiscriminatorMapping(false) != null) {
            consumer.consumeMapping(this.getDiscriminatorMapping(false), 3);
        }
    }

    public void provideUnmappedDatastoreFields(MappingConsumer consumer) {
    }

    public void provideExternalMappings(MappingConsumer consumer, int mappingType) {
    }

    public JavaTypeMapping getExternalMapping(AbstractMemberMetaData fmd, int mappingType) {
        if (mappingType == 5) {
            return this.getExternalFkMappings().get(fmd);
        }
        if (mappingType == 6) {
            return null;
        }
        if (mappingType == 4) {
            return this.getExternalOrderMappings().get(fmd);
        }
        return null;
    }

    public AbstractMemberMetaData getMetaDataForExternalMapping(JavaTypeMapping mapping, int mappingType) {
        if (mappingType == 5) {
            Set<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> entries = this.getExternalFkMappings().entrySet();
            for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry1 : entries) {
                Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry = entry1;
                if (entry.getValue() != mapping) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public DiscriminatorMetaData getDiscriminatorMetaData() {
        return this.discriminatorMetaData;
    }

    public JavaTypeMapping getDiscriminatorMapping(boolean allowSuperclasses) {
        return this.discriminatorMapping;
    }

    public VersionMetaData getVersionMetaData() {
        return null;
    }

    public JavaTypeMapping getVersionMapping(boolean allowSuperclasses) {
        return null;
    }

    public Map<AbstractMemberMetaData, JavaTypeMapping> getExternalFkMappings() {
        return this.externalFkMappings;
    }

    public Map<AbstractMemberMetaData, JavaTypeMapping> getExternalOrderMappings() {
        return this.externalOrderMappings;
    }

    private void runCallBacks() {
        Collection c = (Collection)callbacks.remove((Object)this.cmd.getFullClassName());
        if (c == null) {
            return;
        }
        for (Object aC : c) {
            CallBack callback = (CallBack)aC;
            AbstractMemberMetaData ownerFmd = callback.fmd;
            if (ownerFmd.getMappedBy() != null) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForMember(ownerFmd.getMappedBy());
                if (fmd == null) {
                    throw new NucleusUserException(String.format("Unable to find the field \"{0}\" in the class \"{1}\" with a relationship to the field \"{2}\"", ownerFmd.getMappedBy(), this.cmd.getFullClassName(), ownerFmd.getFullFieldName()));
                }
                this.addOrderMapping(ownerFmd, null);
                continue;
            }
            String ownerClassName = callback.ownerClassName;
            PersistableMapping fkMapping = new PersistableMapping();
            fkMapping.initialize((MappedStoreManager)this.storeMgr, ownerClassName);
            JavaTypeMapping orderMapping = null;
            JavaTypeMapping ownerIdMapping = this.storeMgr.getDatastoreClass(ownerClassName, this.clr).getIdMapping();
            ElementMetaData colmdContainer = null;
            if (ownerFmd.hasCollection() || ownerFmd.hasArray()) {
                colmdContainer = ownerFmd.getElementMetaData();
            } else if (ownerFmd.hasMap() && ownerFmd.getKeyMetaData() != null && ownerFmd.getKeyMetaData().getMappedBy() != null) {
                colmdContainer = ownerFmd.getValueMetaData();
            } else if (ownerFmd.hasMap() && ownerFmd.getValueMetaData() != null && ownerFmd.getValueMetaData().getMappedBy() != null) {
                colmdContainer = ownerFmd.getKeyMetaData();
            }
            CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper((ColumnMetaDataContainer)colmdContainer, ownerIdMapping, true);
            int countIdFields = ownerIdMapping.getNumberOfDatastoreMappings();
            for (int i = 0; i < countIdFields; ++i) {
                DatastoreMapping refDatastoreMapping = ownerIdMapping.getDatastoreMapping(i);
                JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType());
                ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refDatastoreMapping.getDatastoreField().getIdentifier());
                if (colmd == null) {
                    throw new NucleusFatalUserException(String.format("Primary Key column \"%s\" for table \"%s\" is not mapped.", refDatastoreMapping.getDatastoreField().getIdentifier(), this.toString()));
                }
                IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
                DatastoreIdentifier identifier = colmd.getName() == null || colmd.getName().length() < 1 ? idFactory.newForeignKeyFieldIdentifier(ownerFmd, null, refDatastoreMapping.getDatastoreField().getIdentifier(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(mapping.getJavaType()), 1) : idFactory.newDatastoreFieldIdentifier(colmd.getName());
                if (this.datastorePropertiesByName.containsKey(identifier.getIdentifierName())) continue;
                DatastoreProperty refColumn = this.addDatastoreField(mapping.getJavaType().getName(), identifier, mapping, colmd);
                refDatastoreMapping.getDatastoreField().copyConfigurationTo((DatastoreField)refColumn);
                if (colmd.getAllowsNull() == null || colmd.getAllowsNull() != null && colmd.isAllowsNull()) {
                    refColumn.setNullable();
                }
                fkMapping.addDatastoreMapping(this.getStoreManager().getMappingManager().createDatastoreMapping(mapping, (DatastoreField)refColumn, refDatastoreMapping.getJavaTypeMapping().getJavaType().getName()));
                fkMapping.addJavaTypeMapping(mapping);
            }
            this.getExternalFkMappings().put(ownerFmd, (JavaTypeMapping)fkMapping);
            this.addOrderMapping(ownerFmd, orderMapping);
        }
    }

    private JavaTypeMapping addOrderMapping(AbstractMemberMetaData fmd, JavaTypeMapping orderMapping) {
        boolean needsOrderMapping = false;
        OrderMetaData omd = fmd.getOrderMetaData();
        if (fmd.hasArray()) {
            needsOrderMapping = true;
        } else if (List.class.isAssignableFrom(fmd.getType())) {
            needsOrderMapping = omd == null || omd.isIndexedList();
        } else if (Collection.class.isAssignableFrom(fmd.getType()) && omd != null && omd.isIndexedList() && omd.getMappedBy() == null) {
            needsOrderMapping = true;
        }
        if (needsOrderMapping) {
            if (orderMapping == null) {
                orderMapping = this.addOrderColumn(fmd);
            }
            if (!MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, fmd)) {
                this.getExternalOrderMappings().put(fmd, orderMapping);
            }
        }
        return orderMapping;
    }

    private JavaTypeMapping addOrderColumn(AbstractMemberMetaData fmd) {
        DatastoreField column;
        Class<Integer> indexType = Integer.class;
        IndexMapping indexMapping = new IndexMapping();
        indexMapping.initialize((MappedStoreManager)this.storeMgr, indexType.getName());
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier indexColumnName = null;
        ColumnMetaData colmd = null;
        OrderMetaData omd = fmd.getOrderMetaData();
        if (omd != null) {
            ColumnMetaData columnMetaData = colmd = omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 ? omd.getColumnMetaData()[0] : null;
            if (omd.getMappedBy() != null) {
                JavaTypeMapping orderMapping = this.getMemberMapping(omd.getMappedBy());
                if (orderMapping == null) {
                    throw new NucleusUserException(String.format("Field \"{0}\" has an <order> defined to be persisted into the columns in the element table for element field \"{1}\". This field is not found in the element class.", fmd.getFullFieldName(), omd.getMappedBy()));
                }
                if (!(orderMapping instanceof IntegerMapping) && !(orderMapping instanceof LongMapping)) {
                    throw new NucleusUserException(String.format("Field \"{0}\" has an <order> defined to be persisted into the column of field \"{1}\". This field is of an invalid type. Must be an int/Integer.", fmd.getFullFieldName(), omd.getMappedBy()));
                }
                return orderMapping;
            }
            if (omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 && omd.getColumnMetaData()[0].getName() != null) {
                String colName = omd.getColumnMetaData()[0].getName();
                indexColumnName = idFactory.newDatastoreFieldIdentifier(colName);
            }
        }
        if (indexColumnName == null) {
            indexColumnName = idFactory.newForeignKeyFieldIdentifier(fmd, null, null, true, 7);
        }
        if ((column = (DatastoreField)this.datastorePropertiesByName.get(indexColumnName.getIdentifierName())) == null) {
            column = this.addDatastoreField(indexType.getName(), indexColumnName, (JavaTypeMapping)indexMapping, colmd);
        }
        if (colmd == null || colmd.getAllowsNull() == null || colmd.getAllowsNull() != null && colmd.isAllowsNull()) {
            column.setNullable();
        }
        DatastoreFKMapping fkMapping = (DatastoreFKMapping)this.storeMgr.getMappingManager().createDatastoreMapping((JavaTypeMapping)indexMapping, column, indexType.getName());
        DatastoreProperty field = fkMapping.getDatastoreField();
        DatastoreTable elementTable = field.getDatastoreContainerObject();
        PropertyMetaData pmd = new PropertyMetaData((MetaData)elementTable.getClassMetaData(), indexColumnName.getIdentifierName());
        field.setMemberMetaData((AbstractMemberMetaData)pmd);
        return indexMapping;
    }

    public boolean isParentKeyProvider(AbstractMemberMetaData ammd) {
        return ammd.equals(this.parentMappingMemberMetaData);
    }

    public AbstractMemberMetaData getParentMappingMemberMetaData() {
        return this.parentMappingMemberMetaData;
    }

    public String toString() {
        return this.cmd.getFullClassName();
    }

    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    public JavaTypeMapping getMultitenancyMapping() {
        return null;
    }

    public void provideMultitenancyMapping(MappingConsumer consumer) {
    }

    class DatastoreKind
    implements DatastoreIdentifier {
        private final String identifier;

        public DatastoreKind(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifierName() {
            return this.identifier;
        }

        public String getFullyQualifiedName(boolean adapterCase) {
            return this.getIdentifierName();
        }

        public void setCatalogName(String s) {
        }

        public void setSchemaName(String s) {
        }

        public String getCatalogName() {
            return null;
        }

        public String getSchemaName() {
            return null;
        }
    }

    private static class CallBack {
        final AbstractMemberMetaData fmd;
        final String ownerClassName;

        public CallBack(AbstractMemberMetaData fmd, String ownerClassName) {
            this.fmd = fmd;
            this.ownerClassName = ownerClassName;
        }
    }
}

